/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.integrations;

import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.carton.CartonsBuildHelper;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;

final class ImplPMP {
    private static final String _CORN = "veget_corn";
    private static final String _CASSAVA = "root_cassa";
    private static final String _TARO = "root_taro";
    private static final String _RICE = "seedf_rice";
    private static final String _SOYBEAN = "seedf_soybe";
    private static final String _TOFU = "food_tofu";
    private static final String _TOMATO = "veget_tomat";
    private static final String _CELERY = "veget_celer";
    private static final String _ONION = "veget_onion";
    private static final String _GARLIC = "veget_garli";
    private static final String _LEEK = "veget_leek";
    private static final String _CUCUMBER = "veget_cucum";
    private static final String _SWEETPEPPER_Y = "veget_belpy";
    private static final String _SWEETPEPPER_R = "veget_belpr";
    private static final String _SWEETPEPPER_O = "veget_belpo";
    private static final String _EGGPLANT = "veget_eggpl";
    private static final String _BROCCOLI = "veget_brocc";
    private static final String _CAULIFLOWER = "veget_cauli";
    private static final String _GREENBEANS = "veget_grnbe";
    private static final String _LENTILS = "seedf_lenti";
    private static final String _SPINACH = "veget_spina";
    private static final String _WATERCRESS = "veget_watcr";
    private static final String _BRUSSELSPROUTS = "veget_bruss";
    private static final String _SQUASH = "veget_squas";
    private static final String _SWISS_CHARD = "veget_swcha";
    private static final String _GRAPES = "fruit_purgr";
    private static final String _STRAWBERRY = "berry_straw";
    private static final String _BLUEBERRY = "berry_blue";
    private static final String _KIWI = "fruit_kiwi";
    private static final String _PEANUTS = "seedf_peanu";
    private static final String _MANGO = "fruit_mango";
    private static final String _ORANGE = "fruit_orang";
    private static final String _TANGERINE = "fruit_tange";
    private static final String _GRAPEFRUIT = "fruit_grapf";
    private static final String _BANANA = "fruit_banan";
    private static final String _AVOCADO = "fruit_avoca";
    private static final String _COCONUT = "fruit_cocon";
    private static final String _PLUM = "fruit_plum";
    private static final String _PEAR = "fruit_pear";
    private static final String _CHERRIES = "fruit_cherr";
    private static final String _LEMON = "fruit_lemon";
    private static final String _LIME = "fruit_lime";
    private static final String _PINEAPPLE = "fruit_pinea";
    private static final String _LETTUCE = "veget_lettu";
    private static final String _APPLE_G = "fruit_grnap";
    private static final String _APPLE_Y = "fruit_yelap";
    private static final String _PBJ_SANDWICH = "food_sandp";
    private static final String _COOKED_RICE = "food_ricec";
    private static final String _QUINOA = "seedf_quino";
    private static final String _CORN_MEAL = "food_corfl";
    private static final String _CORN_BREAD = "food_corbr";
    private static final String _T = "_T";
    private static final String _F = "_F";

    ImplPMP() {
    }

    private static String[] SEEDS() {
        return new String[]{"eggpl", "tomat", "corn", "cucum", "spina", "aspar", "bruss", "onion", "garli", "brocc", "celer", "leek", "cauli", "radis", "turni", "grnbe", "chard", "squas", "cassa", "pinea", "belpy", "belpr", "belpo", "lettu", "horse", "landc", "peanu", "lenti", "rice", "soybe", "quino"};
    }

    private static String[] BERRIES() {
        return new String[]{"black", "blue", "elder", "straw", "orang"};
    }

    static final void inferFoodDictionary(VfpConfig config, Collection<String> mappings) {
        if (config.isModLoaded(Integrations.PMP)) {
            mappings.add("foodApple");
            mappings.add("foodBanana");
            mappings.add("foodStrawberry");
            mappings.add("foodBlueberry");
            mappings.add("foodPeanuts");
            mappings.add("foodMango");
            mappings.add("foodPineapple");
            mappings.add("foodLime");
            mappings.add("foodLemon");
            mappings.add("foodOrange");
            mappings.add("foodGrapefruit");
            mappings.add("foodTangerine");
            mappings.add("foodGrapes");
            mappings.add("foodCoconut");
            mappings.add("foodKiwi");
            mappings.add("foodCherry");
            mappings.add("foodTofu");
            mappings.add("foodCorn");
            mappings.add("foodRice");
            mappings.add("foodOnion");
            mappings.add("foodTomato");
            mappings.add("foodCelery");
            mappings.add("foodGarlic");
            mappings.add("foodEggplant");
            mappings.add("foodLeek");
            mappings.add("foodCucumber");
            mappings.add("foodBroccoli");
            mappings.add("foodLettuce");
            mappings.add("foodSpinach");
            mappings.add("foodLentils");
            mappings.add("foodAvocado");
        }
    }

    static final void fixFoodDictionary(VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP) && config.fixPMPFoodDictionary()) {
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodCorn", _CORN);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodRice", _RICE);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodTaro", _TARO);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodCassava", _CASSAVA);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodSoybean", _SOYBEAN);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodAvocado", _AVOCADO);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodTofu", _TOFU);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodTomato", _TOMATO);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodCelery", _CELERY);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodOnion", _ONION);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodGarlic", _GARLIC);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodLeek", _LEEK);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodCucumber", _CUCUMBER);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBellPepper", _SWEETPEPPER_Y);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBellPepper", _SWEETPEPPER_R);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBellPepper", _SWEETPEPPER_O);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodEggplant", _EGGPLANT);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodSquash", _SQUASH);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBroccoli", _BROCCOLI);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodCauliflower", _CAULIFLOWER);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodChard", _SWISS_CHARD);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodMustardGreens", _SWISS_CHARD);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodGreenBeans", _GREENBEANS);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodSpinach", _SPINACH);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBrusselSprouts", _BRUSSELSPROUTS);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodLentils", _LENTILS);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodGrapes", _GRAPES);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodStrawberry", _STRAWBERRY);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBlueberry", _BLUEBERRY);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodKiwi", _KIWI);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodPeanuts", _PEANUTS);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodMango", _MANGO);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodLime", _LIME);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodLemon", _LEMON);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodOrange", _ORANGE);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodTangerine", _TANGERINE);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodCoconut", _COCONUT);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodPlums", _PLUM);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBanana", _BANANA);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodPineapple", _PINEAPPLE);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodGrapefruit", _GRAPEFRUIT);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodPear", _PEAR);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodCherry", _CHERRIES);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodWatercress", _WATERCRESS);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodLettuce", _LETTUCE);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodApple", _APPLE_G);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodApple", _APPLE_Y);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBread", _CORN_BREAD);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBreadSandwich", _CORN_BREAD);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodPBJ", _PBJ_SANDWICH);
        }
    }

    static final void registerKebabItems(VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP)) {
            if (!config.fixPMPFoodDictionary()) {
                String[] primary = new String[]{_TOFU, _BROCCOLI, _EGGPLANT, _CASSAVA, _CAULIFLOWER, _TARO};
                IntegrationsImpl._registerFoodItems(Integrations.PMP, "ingredientKebabMain", primary);
                String[] fillers = new String[]{_TOMATO, _ONION, _LEEK, _CORN, _BRUSSELSPROUTS, _PINEAPPLE, _SWEETPEPPER_Y, _SWEETPEPPER_R, _SWEETPEPPER_O};
                IntegrationsImpl._registerFoodItems(Integrations.PMP, "ingredientKebabFill", fillers);
                String[] fruit = new String[]{_MANGO, _APPLE_G, _APPLE_Y, _BANANA, _KIWI, _PLUM, _PEAR, _ORANGE, _TANGERINE};
                IntegrationsImpl._registerFoodItems(Integrations.PMP, "ingredientKebabFruit", fruit);
                String[] nuggets = new String[]{_BROCCOLI, _EGGPLANT, _CAULIFLOWER};
                IntegrationsImpl._registerFoodItems(Integrations.PMP, "ingredientVegNugget", nuggets);
            }
            String[] nuggets = new String[]{_BRUSSELSPROUTS, _SQUASH};
            IntegrationsImpl._registerFoodItems(Integrations.PMP, "ingredientVegNugget", nuggets);
        }
    }

    static final void registerMushrooms(VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP)) {
            String[] fungi;
            boolean generalize = config.fixPMPFoodDictionary();
            for (String fungus : fungi = new String[]{"fungu_chant", "fungu_gclub", "fungu_wemic", "fungu_stnkh", "fungu_woodb", "fungu_blpow", "fungu_paras"}) {
                Block item = Block.func_149684_b((String)Integrations.PMP.itemid(fungus));
                if (item == null) continue;
                if (generalize) {
                    OreDictionary.registerOre((String)"foodMushroom", (Block)item);
                }
                OreDictionary.registerOre((String)"ingredientMushroom", (Block)item);
                OreDictionary.registerOre((String)"ingredientKebabFill", (Block)item);
                OreDictionary.registerOre((String)"greenLitterFungi", (Block)item);
            }
        }
    }

    static final void registerPackagedFoods(VfpConfig config) {
        if (!config.isModLoaded(Integrations.PMP)) {
            return;
        }
        VfpCapacity BULK = VfpCapacity.BULK_STACK;
        String[] baggables = new String[]{"fruit", _STRAWBERRY, "strawberries", _F, "fruit", _BLUEBERRY, "blueberries", _F, "fruit", _PEANUTS, "peanuts", _F, "fruit", _GRAPES, "grapes", _T, "vegetable", _CORN, "corn", _F, "vegetable", _BROCCOLI, "broccoli", _F, "vegetable", _SPINACH, "spinach", _F, "vegetable", _TOMATO, "tomatoes", _F, "vegetable", _EGGPLANT, "eggplant", _F, "vegetable", _CASSAVA, "cassava", _F, "bakery", _PBJ_SANDWICH, "sandwich_pbj", _F, "general", _COOKED_RICE, "precooked_rice", _T};
        for (int i = 0; i < baggables.length; i += 4) {
            PackagedFood.Type type = PackagedFood.Type.valueOf(baggables[i]);
            PackagedFood pf = new PackagedFood(type.name(), baggables[i + 2], new LikeFood(Integrations.PMP.itemid(baggables[i + 1])), null, null, BULK);
            if (baggables[i + 3] != _T) continue;
            CartonsBuildHelper.exclude(type, pf);
        }
    }

    static final void registerCompatibleForgeIds(VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP)) {
            String[] berries;
            String[] crops = ImplPMP.SEEDS();
            Item corn = null;
            for (String cropname : crops) {
                boolean dryable;
                Item seed = Item.func_111206_d((String)Integrations.PMP.itemid("seed_" + cropname));
                boolean bl = dryable = seed != null;
                if (!dryable) {
                    seed = Item.func_111206_d((String)Integrations.PMP.itemid("seedf_" + cropname));
                }
                if (seed == null) continue;
                OreDictionary.registerOre((String)"greenLitterSeeds", (Item)seed);
                if (dryable) {
                    OreDictionary.registerOre((String)"itemDryableSeed", (Item)seed);
                }
                if (!"corn".equals(cropname)) continue;
                corn = seed;
            }
            if (corn != null) {
                OreDictionary.registerOre((String)"additiveScaffold", corn);
            }
            IntegrationsImpl._registerMiscItem(Integrations.PMP, "ingredientLemonFlavor", _LEMON);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodLightGreens", _LETTUCE);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodLightGreens", _WATERCRESS);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodLightGreens", _SPINACH);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodSandwich", "food_sandf");
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodSandwich", "food_sandm");
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodSandwich", _PBJ_SANDWICH);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "ingredientCereal", _COOKED_RICE);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "ingredientCereal", _QUINOA);
            IntegrationsImpl._registerMiscItem(Integrations.PMP, "foodFlourCorn", _CORN_MEAL);
            if (!config.isPresent("cornmeal")) {
                config.setPresentAs("cornmeal", "foodFlourCorn");
            }
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "portionBread", "food_corto");
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBerry", _STRAWBERRY);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBerry", _BLUEBERRY);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBerry", _CHERRIES);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBerry", "berry_black");
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodCitrusFruit", _TANGERINE);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodCitrusFruit", _LIME);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodCitrusFruit", _LEMON);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodCitrusFruit", _ORANGE);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodCitrusFruit", _GRAPEFRUIT);
            boolean fixTreeDict = config.fixPMPTreeDictionary();
            for (String berryname : berries = ImplPMP.BERRIES()) {
                Block plant = Block.func_149684_b((String)Integrations.PMP.itemid("bbush_" + berryname));
                if (!(plant instanceof IPlantable)) continue;
                OreDictionary.registerOre((String)"greenLitterOther", (Block)plant);
                if (!fixTreeDict) continue;
                OreDictionary.registerOre((String)"plantBerry", (Block)plant);
            }
            if (fixTreeDict) {
                String[] planks;
                String[] logs;
                String[] leaves;
                String[] saplings;
                for (String sapling : saplings = new String[]{"sapli_acaci_baobo", "sapli_acaci_cucum", "sapli_acaci_rivbu", "sapli_acaci_whist", "sapli_birch_chdwa", "sapli_birch_silve", "sapli_birch_water", "sapli_birch_whtgr", "sapli_birch_whtye", "sapli_birch_whtor", "sapli_birch_whtre", "sapli_dkoak_bur", "sapli_dkoak_everg", "sapli_dkoak_itali", "sapli_dkoak_sessi", "sapli_jungl_acai", "sapli_jungl_banan", "sapli_jungl_bombo", "sapli_jungl_cocon", "sapli_oak_blue", "sapli_oak_engli", "sapli_oak_gray", "sapli_oak_japem", "sapli_spruc_black", "sapli_spruc_marti", "sapli_spruc_norwa", "sapli_spruc_red", "sapli_fruit_apric", "sapli_fruit_avoca", "sapli_fruit_cherr", "sapli_fruit_grapf", "sapli_fruit_grnap", "sapli_fruit_lemon", "sapli_fruit_lime", "sapli_fruit_mango", "sapli_fruit_mulbe", "sapli_fruit_olive", "sapli_fruit_orang", "sapli_fruit_peach", "sapli_fruit_pear", "sapli_fruit_plum", "sapli_fruit_tange", "sapli_fruit_yelap", "sapli_nut_almon", "sapli_nut_brazi", "sapli_nut_butte", "sapli_nut_candl", "sapli_nut_cashe", "sapli_nut_gabon", "sapli_nut_hazel", "sapli_nut_macad", "sapli_nut_maya", "sapli_nut_pecan", "sapli_nut_pista", "sapli_nut_walnu"}) {
                    Block block = Block.func_149684_b((String)Integrations.PMP.itemid(sapling));
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack(block, 1));
                }
                for (String leaf : leaves = new String[]{"leave_acaci_baobo", "leave_acaci_cucum", "leave_acaci_rivbu", "leave_acaci_whist", "leave_birch_chdwa", "leave_birch_silve", "leave_birch_water", "leave_birch_whtgr", "leave_birch_whtye", "leave_birch_whtor", "leave_birch_whtre", "leave_dkoak_bur", "leave_dkoak_everg", "leave_dkoak_itali", "leave_dkoak_sessi", "leave_jungl_acai", "leave_jungl_banan", "leave_jungl_bombo", "leave_jungl_cocon", "leave_oak_blue", "leave_oak_engli", "leave_oak_gray", "leave_oak_japem", "leave_spruc_black", "leave_spruc_marti", "leave_spruc_norwa", "leave_spruc_red", "leave_fruit_apric", "leave_fruit_avoca", "leave_fruit_cherr", "leave_fruit_grapf", "leave_fruit_grnap", "leave_fruit_lemon", "leave_fruit_lime", "leave_fruit_mango", "leave_fruit_mulbe", "leave_fruit_olive", "leave_fruit_orang", "leave_fruit_peach", "leave_fruit_pear", "leave_fruit_plum", "leave_fruit_tange", "leave_fruit_yelap", "leave_nut_almon", "leave_nut_brazi", "leave_nut_butte", "leave_nut_candl", "leave_nut_cashe", "leave_nut_gabon", "leave_nut_hazel", "leave_nut_macad", "leave_nut_maya", "leave_nut_pecan", "leave_nut_pista", "leave_nut_walnu"}) {
                    Block block = Block.func_149684_b((String)Integrations.PMP.itemid(leaf));
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack(block, 1));
                }
                for (String log : logs = new String[]{"log_frtwd"}) {
                    Block block = Block.func_149684_b((String)Integrations.PMP.itemid(log));
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(block, 1));
                }
                for (String plank : planks = new String[]{"plank_frtwd"}) {
                    Block block = Block.func_149684_b((String)Integrations.PMP.itemid(plank));
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack(block, 1));
                }
            }
        }
    }

    static final void autorecipeMisc(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        if (config.isModLoaded(Integrations.PMP)) {
            Item eggplant;
            int yes = 0;
            Item corn_on_cob = Item.func_111206_d((String)Integrations.PMP.itemid(_CORN));
            if (corn_on_cob instanceof ItemFood) {
                ++yes;
                GameRegistry.addSmelting((ItemStack)new ItemStack(corn_on_cob), (ItemStack)new ItemStack(VfpObj.Roast_Corn_obj), (float)LikeFood.uncooked_potato.smeltExperience());
            }
            if ((eggplant = Item.func_111206_d((String)Integrations.PMP.itemid(_EGGPLANT))) instanceof ItemFood) {
                ++yes;
                GameRegistry.addSmelting((ItemStack)new ItemStack(eggplant), (ItemStack)new ItemStack(VfpObj.Roasted_Eggplant_obj), (float)LikeFood.uncooked_potato.smeltExperience());
            }
            if (yes == 2 && config.allowSeedDrying() && config.includePMPCropSeedRecipes()) {
                String[] crops;
                for (String cropname : crops = ImplPMP.SEEDS()) {
                    Item seed = Item.func_111206_d((String)Integrations.PMP.itemid("seed_" + cropname));
                    Item food = Item.func_111206_d((String)Integrations.PMP.itemid("veget_" + cropname));
                    if (food == null) {
                        food = Item.func_111206_d((String)Integrations.PMP.itemid("fruit_" + cropname));
                    }
                    if (seed == null || food == null) continue;
                    recipes.register(new ShapelessOreRecipe(null, new ItemStack(seed, 2), new Object[]{food, "itemDryingPaper"}).setRegistryName(ModInfo.r("seeds_from_pmp_" + cropname)));
                }
            }
        }
    }
}

