/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.core;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.RenderingHelper;

public final class VfpRenderHelper
implements RenderingHelper {
    @Override
    public final void doRenderSetupOrFail(VfpProfile oid, Item singleton) {
        Validate.validState((singleton != null && singleton != MinecraftGlue.Items_air ? 1 : 0) != 0, (String)"VFP item '%s' not valid", (Object[])new Object[]{oid});
        ModelResourceLocation model = new ModelResourceLocation("vanillafoodpantry:" + oid.fmlid(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)singleton, (int)0, (ModelResourceLocation)model);
    }

    @Override
    public final void doRenderSetupOrFail(VfpProfile oid, Block singleton) {
        Validate.validState((singleton != null ? 1 : 0) != 0, (String)"VFP block '%s' not built SUCCESSFULLY", (Object[])new Object[]{oid});
        Item registered = Item.func_150898_a((Block)singleton);
        Validate.validState((registered != null && registered != MinecraftGlue.Items_air ? 1 : 0) != 0, (String)"VFP item '%s' not valid", (Object[])new Object[]{oid});
        ModelResourceLocation model = new ModelResourceLocation("vanillafoodpantry:" + oid.fmlid(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)registered, (int)0, (ModelResourceLocation)model);
    }

    @Override
    public final void doRenderSetupOrFail(VfpProfile oid, Item singleton, VfpVariantSet variants) {
        Validate.validState((singleton != null && singleton != MinecraftGlue.Items_air ? 1 : 0) != 0, (String)"VFP multi-x item '%s' not valid", (Object[])new Object[]{oid});
        String[] fmlids = variants.renderNames();
        VfpVariant[] metas = variants.variants();
        if (fmlids.length > 1) {
            for (int index = 0; index < metas.length; ++index) {
                ModelResourceLocation model = new ModelResourceLocation(fmlids[index], "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)singleton, (int)metas[index].metadata(), (ModelResourceLocation)model);
            }
        } else {
            ModelResourceLocation model = new ModelResourceLocation("vanillafoodpantry:" + oid.fmlid(), "inventory");
            for (int index = 0; index < metas.length; ++index) {
                ModelLoader.setCustomModelResourceLocation((Item)singleton, (int)metas[index].metadata(), (ModelResourceLocation)model);
            }
        }
    }

    @Override
    public final void doRenderSetupOrFail(VfpProfile oid, Block singleton, VfpVariantSet variants) {
        Validate.validState((singleton != null ? 1 : 0) != 0, (String)"VFP multi-x block '%s' not valid", (Object[])new Object[]{oid});
        Item blockitem = Item.func_150898_a((Block)singleton);
        Validate.validState((blockitem != null && blockitem != MinecraftGlue.Items_air ? 1 : 0) != 0, (String)"VFP item '%s' not valid", (Object[])new Object[]{oid});
        String[] fmlids = variants.renderNames();
        VfpVariant[] metas = variants.variants();
        for (int index = 0; index < metas.length; ++index) {
            ModelResourceLocation model = new ModelResourceLocation(fmlids[index], "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)blockitem, (int)metas[index].metadata(), (ModelResourceLocation)model);
        }
    }

    @Override
    public final void doRenderSetupOrFail(VfpProfile oid, Item singleton, String[] fmlids, int[] metas) {
        Validate.validState((singleton != null && singleton != MinecraftGlue.Items_air ? 1 : 0) != 0, (String)"VFP multi-x item '%s' not valid", (Object[])new Object[]{oid});
        Validate.validState((fmlids != null && metas != null ? 1 : 0) != 0, (String)"A valid set of meta information is required", (Object[])new Object[0]);
        if (fmlids.length > 1) {
            for (int index = 0; index < metas.length; ++index) {
                ModelResourceLocation model = new ModelResourceLocation(fmlids[index], "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)singleton, (int)metas[index], (ModelResourceLocation)model);
            }
        } else {
            ModelResourceLocation model = new ModelResourceLocation("vanillafoodpantry:" + fmlids[0], "inventory");
            for (int index = 0; index < metas.length; ++index) {
                ModelLoader.setCustomModelResourceLocation((Item)singleton, (int)metas[index], (ModelResourceLocation)model);
            }
        }
    }

    @Override
    public final void doRenderWaterBottlesOrFail(int fizzy_index, int end_index) {
        VfpOid oid = VfpOid.Water_Bottle;
        Item singleton = VfpObj.Our_Water_Bottle_obj;
        Validate.validState((singleton != null && singleton != MinecraftGlue.Items_air ? 1 : 0) != 0, (String)"VFP item '%s' not valid", (Object[])new Object[]{oid});
        String[] fmlids = new String[]{"vanillafoodpantry:" + oid.fmlid(), "vanillafoodpantry:" + oid.fmlid() + "_fizzy"};
        ModelResourceLocation model = new ModelResourceLocation(fmlids[0], "inventory");
        for (int i = 0; i < end_index; ++i) {
            if (i == fizzy_index) continue;
            ModelLoader.setCustomModelResourceLocation((Item)singleton, (int)i, (ModelResourceLocation)model);
        }
        model = new ModelResourceLocation(fmlids[1], "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)singleton, (int)fizzy_index, (ModelResourceLocation)model);
    }
}

