/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.core;

import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.VanillaFoodPantry;
import org.jwaresoftware.mcmods.vfp.agents.AgentsBuildHelper;
import org.jwaresoftware.mcmods.vfp.carton.CartonsBuildHelper;
import org.jwaresoftware.mcmods.vfp.carton.VfpPantryJar;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.TANHelper;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpBrewingItem;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpCraftOnlyItem;
import org.jwaresoftware.mcmods.vfp.common.VfpExtendedPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPotionTypes;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpSimpleBowlFood;
import org.jwaresoftware.mcmods.vfp.common.VfpSoakableSimpleFood;
import org.jwaresoftware.mcmods.vfp.common.VfpStew;
import org.jwaresoftware.mcmods.vfp.common.VfpStorageItem;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.configui.VfpConfigChangedListener;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelper;
import org.jwaresoftware.mcmods.vfp.core.VfpIconItem;
import org.jwaresoftware.mcmods.vfp.core.VfpLootMerger;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.eggs.EggExtrasBuildHelper;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;
import org.jwaresoftware.mcmods.vfp.meats.MeatExtrasBuildHelper;
import org.jwaresoftware.mcmods.vfp.milk.MilkExtrasBuildHelper;
import org.jwaresoftware.mcmods.vfp.misc.MiscBuildHelper;
import org.jwaresoftware.mcmods.vfp.sugar.SugarExtrasBuildHelper;
import org.jwaresoftware.mcmods.vfp.wheat.WheatExtrasBuildHelper;

public class VfpBuilder {
    private static final Class[] MULTI_ITEM_CTOR_SIG = new Class[]{VfpOid.class, CreativeTabs.class};
    private static final Class[] MULTI_BLOCK_CTOR_SIG = new Class[]{VfpOid.class, VfpVariantSet.class, CreativeTabs.class};
    private final VfpBuildHelper _additivesBuilder;
    private final VfpBuildHelper _milkExtrasBuilder;
    private final VfpBuildHelper _wheatExtrasBuilder;
    private final VfpBuildHelper _eggExtrasBuilder;
    private final VfpBuildHelper _meatExtrasBuilder;
    private final VfpBuildHelper _sugarExtrasBuilder;
    private final VfpBuildHelper _cartonsBuilder;
    private final VfpBuildHelper _alwaysLastBuilder;
    private final VfpBuildHelper[] _subBuilders;
    private int _other_mod_count = 0;

    public static VfpPantryItem newPortion(VfpProfile oid) {
        CreativeTabs tab = oid.isEdible() ? null : MinecraftGlue.CreativeTabs_materials;
        return new VfpPantryItem(oid, LikeFood.air, tab).autoregister();
    }

    public static Item newAdditive(VfpProfile oid, CreativeTabs tab) {
        return oid.isEdible() ? new VfpPantryItem(oid, LikeFood.air, tab).autoregister() : (oid.capacity() == VfpCapacity.NONE ? new VfpPlainItem(oid, tab).autoregister() : new VfpStorageItem(oid, tab).autoregister());
    }

    public static Item newAdditive(VfpProfile oid) {
        return VfpBuilder.newAdditive(oid, null);
    }

    public static VfpPantryItem newFood(VfpProfile oid, LikeFood food) {
        return new VfpPantryItem(oid, food, oid.isEdible() ? null : MinecraftGlue.CreativeTabs_materials).autoregister();
    }

    public static VfpPantryItem newOptionalFood(VfpProfile oid, LikeFood food, VfpAware.IdDomain domain, String ingredient) {
        return new VfpExtendedPantryItem(oid, food, new VfpExtendedPantryItem.IsIngredientPresent(domain, ingredient), oid.isEdible() ? null : MinecraftGlue.CreativeTabs_materials).autoregister();
    }

    public static VfpPantryItem newBowlFood(VfpProfile oid, LikeFood food) {
        return VfpSimpleBowlFood.newBowl(oid, food);
    }

    public static VfpStew newStew(VfpProfile oid, LikeFood food) {
        return VfpStew.newStew(oid, food);
    }

    public static VfpPantryItem newWolfFood(VfpProfile oid, LikeFood food) {
        return new VfpPantryItem(oid, food, true, oid.isEdible() ? null : MinecraftGlue.CreativeTabs_materials).autoregister();
    }

    public static VfpPantryItem newSoakableFood(VfpProfile oid, LikeFood food) {
        return new VfpSoakableSimpleFood(oid, food, null).autoregister();
    }

    public static VfpPlainItem newMisc(VfpProfile oid) {
        return oid.capacity() == VfpCapacity.NONE ? new VfpPlainItem(oid, MinecraftGlue.CreativeTabs_misc).autoregister() : new VfpStorageItem(oid, MinecraftGlue.CreativeTabs_misc).autoregister();
    }

    public static VfpPlainItem newItem(VfpProfile oid) {
        return new VfpPlainItem(oid).autoregister();
    }

    public static VfpPlainItem newOptionalItem(VfpProfile oid, boolean hide) {
        return new VfpPlainItem(oid, hide).autoregister();
    }

    public static VfpCraftOnlyItem newCraftOnlyItem(VfpProfile oid) {
        return new VfpCraftOnlyItem(oid).autoregister(VfpCraftOnlyItem.class);
    }

    public static VfpPantryBlock newStorageBlock(VfpProfile oid, Block likeBlock, Item constituent, CreativeTabs tab) {
        return new VfpPantryBlock(oid, null, likeBlock, new MinecraftGlue.ItemStackDef(constituent), tab).autoregister(VfpPantryBlock.class);
    }

    public static VfpPantryBlock newStorageBlock(VfpProfile oid, Item constituent) {
        VfpPantryBlock block = new VfpPantryBlock(oid, MinecraftGlue.Blocks_wool, constituent).autoregister(VfpPantryBlock.class);
        block.func_149672_a(MinecraftGlue.Block_soundType_Cloth);
        return block;
    }

    public static VfpPlainItem newStorageItem(VfpProfile oid) {
        return new VfpStorageItem(oid).autoregister();
    }

    public static VfpPlainItem newStorageJar(VfpProfile oid) {
        return new VfpPantryJar(oid).autoregister();
    }

    public static VfpBrewingItem newBrewingItem(VfpProfile oid, MinecraftGlue.BrewEffect effect, boolean uncommon) {
        return (VfpBrewingItem)new VfpBrewingItem(oid, effect).autoregister(VfpBrewingItem.class).setUncommon(uncommon);
    }

    public static VfpBrewingItem newBrewingItem(VfpProfile oid, boolean uncommon) {
        return (VfpBrewingItem)new VfpBrewingItem(oid, null).autoregister(VfpBrewingItem.class).setUncommon(uncommon);
    }

    public static <T extends VfpPantryMultiItem> T newMultiItem(VfpProfile oid, Class<T> ofType) {
        VfpPantryMultiItem item = null;
        CreativeTabs tab = oid.isEdible() ? null : MinecraftGlue.CreativeTabs_materials;
        Object[] args = new Object[]{oid, tab};
        try {
            item = (VfpPantryMultiItem)ConstructorUtils.invokeExactConstructor(ofType, (Object[])args, (Class[])MULTI_ITEM_CTOR_SIG);
        }
        catch (Throwable ctorX) {
            throw new IllegalArgumentException("Unable to create dynamic VFP multi-item " + oid, ctorX);
        }
        return (T)((VfpPantryMultiItem)item.autoregister(ofType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends VfpPantryMultiBlock> T newMultiBlock(VfpOid oid, VfpVariantSet set, Class<T> ofType) {
        VfpPantryMultiBlock block = null;
        Object[] args = new Object[]{oid, set, null};
        Class<VfpPantryMultiBlock> clazz = VfpPantryMultiBlock.class;
        synchronized (VfpPantryMultiBlock.class) {
            try {
                VfpPantryMultiBlock.set_under_construction(set);
                block = (VfpPantryMultiBlock)ConstructorUtils.invokeExactConstructor(ofType, (Object[])args, (Class[])MULTI_BLOCK_CTOR_SIG);
            }
            catch (Throwable ctorX) {
                throw new IllegalArgumentException("Unable to create dynamic VFP multi-block " + oid, ctorX);
            }
            finally {
                VfpPantryMultiBlock.set_under_construction(null);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return (T)((VfpPantryMultiBlock)block.autoregister(ofType));
        }
    }

    public static final ItemStack newItemInstance(Item item, int amount, int meta) {
        return item instanceof VfpPantryItem ? ((VfpPantryItem)item).createInstance(item, amount, meta) : new ItemStack(item, amount, meta);
    }

    public static final ItemStack newItemInstance(Item item, int amount) {
        return VfpBuilder.newItemInstance(item, amount, 0);
    }

    public static final ItemStack newItemInstance(Item item) {
        return VfpBuilder.newItemInstance(item, 1, 0);
    }

    public static final void autorecipe(IForgeRegistry<IRecipe> recipes, String category, String name, VfpCapacity capacity, Object constituent, ItemStack pantryobject, Item agent, ItemStack vfpconstituent) {
        VfpBuilder.autorecipe(recipes, category, name, capacity, constituent, pantryobject, new ItemStack(agent), vfpconstituent);
    }

    public static final void autorecipe(IForgeRegistry<IRecipe> recipes, String category, String name, VfpCapacity capacity, Object constituent, ItemStack pantryobject, ItemStack agent, ItemStack vfpconstituent) {
        category = StringUtils.defaultString((String)category, (String)"pantry");
        Validate.notBlank((CharSequence)name, (String)"recipe name is required", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)capacity), (String)"A non-null composite capacity is required", (Object[])new Object[0]);
        Validate.notNull((Object)constituent, (String)"A non-null constituent item(stack) is required", (Object[])new Object[0]);
        boolean regular = constituent instanceof Item;
        switch (capacity) {
            case TRAY: {
                if (regular) {
                    recipes.register(new ShapedOreRecipe(null, pantryobject, new Object[]{"XXX", "XaX", "XXX", Character.valueOf('X'), constituent, Character.valueOf('a'), agent}).setRegistryName(ModInfo.r(name)));
                    if (vfpconstituent == null) break;
                    recipes.register(new ShapelessOreRecipe(null, new ItemStack((Item)constituent, capacity.count()), new Object[]{pantryobject}).setRegistryName(ModInfo.r(name + "_unpack")));
                    break;
                }
                recipes.register(new ShapedOreRecipe(null, pantryobject.func_77946_l(), new Object[]{"XXX", "XaX", "XXX", Character.valueOf('X'), constituent, Character.valueOf('a'), agent}).setRegistryName(ModInfo.r(name)));
                if (vfpconstituent == null) break;
                ItemStack output = vfpconstituent.func_77946_l();
                MinecraftGlue.ItemStacks_setSize(output, capacity.count());
                recipes.register(new ShapelessOreRecipe(null, output, new Object[]{pantryobject}).setRegistryName(ModInfo.r(name + "_unpack")));
                break;
            }
            case HALF_TRAY: {
                if (regular) {
                    recipes.register(new ShapedOreRecipe(null, pantryobject, new Object[]{"XX ", "XX ", "a  ", Character.valueOf('X'), constituent, Character.valueOf('a'), agent}).setRegistryName(ModInfo.r(name)));
                    if (vfpconstituent == null) break;
                    recipes.register(new ShapelessOreRecipe(null, new ItemStack((Item)constituent, capacity.count()), new Object[]{pantryobject}).setRegistryName(ModInfo.r(name + "_unpack")));
                    break;
                }
                recipes.register(new ShapedOreRecipe(null, pantryobject, new Object[]{"XX ", "XX ", "a  ", Character.valueOf('X'), constituent, Character.valueOf('a'), agent}).setRegistryName(ModInfo.r(name)));
                if (vfpconstituent == null) break;
                ItemStack output = vfpconstituent.func_77946_l();
                MinecraftGlue.ItemStacks_setSize(output, capacity.count());
                recipes.register(new ShapelessOreRecipe(null, output, new Object[]{pantryobject}).setRegistryName(ModInfo.r(name + "_unpack")));
            }
        }
    }

    static final void validAutorecipeArgs(String category, VfpCapacity capacity, Object constituent, Object pantryobject) {
        category = StringUtils.defaultString((String)category, (String)"pantry");
        Validate.validState((pantryobject != null ? 1 : 0) != 0, (String)"VFP mod's %s object builders must complete SUCCESSFULLY (pantry object is null)", (Object[])new Object[]{category});
        Validate.notNull((Object)constituent, (String)"A non-null recipe constituent item is required", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)capacity), (String)"A non-null composite capacity is required", (Object[])new Object[0]);
    }

    public static final void autorecipe(IForgeRegistry<IRecipe> recipes, String category, String name, VfpCapacity capacity, Object constituent, Block pantryblock, Item vfpconstituent) {
        VfpBuilder.validAutorecipeArgs(category, capacity, constituent, pantryblock);
        VfpBuilder._autorecipe(recipes, category, name, capacity, constituent, new ItemStack(pantryblock), vfpconstituent != null ? new ItemStack(vfpconstituent, capacity.count()) : null);
    }

    public static final void autorecipe(IForgeRegistry<IRecipe> recipes, String category, String name, VfpCapacity capacity, Object constituent, Block pantryblock, Block vfpconstituent) {
        VfpBuilder.validAutorecipeArgs(category, capacity, constituent, pantryblock);
        VfpBuilder._autorecipe(recipes, category, name, capacity, constituent, new ItemStack(pantryblock), vfpconstituent != null ? new ItemStack(vfpconstituent, capacity.count()) : null);
    }

    public static final void autorecipe(IForgeRegistry<IRecipe> recipes, String category, String name, VfpCapacity capacity, Object constituent, Item pantryitem, Item vfpconstituent) {
        VfpBuilder.validAutorecipeArgs(category, capacity, constituent, pantryitem);
        VfpBuilder._autorecipe(recipes, category, name, capacity, constituent, new ItemStack(pantryitem), vfpconstituent != null ? new ItemStack(vfpconstituent, capacity.count()) : null);
    }

    public static final void autorecipe(IForgeRegistry<IRecipe> recipes, String category, String name, VfpCapacity capacity, Object constituent, ItemStack pantryitem, ItemStack vfpconstituent) {
        VfpBuilder.validAutorecipeArgs(category, capacity, constituent, pantryitem);
        if (vfpconstituent != null) {
            vfpconstituent = vfpconstituent.func_77946_l();
            MinecraftGlue.ItemStacks_setSize(vfpconstituent, capacity.count());
        }
        VfpBuilder._autorecipe(recipes, category, name, capacity, constituent, pantryitem, vfpconstituent);
    }

    static final void _autorecipe(IForgeRegistry<IRecipe> recipes, String category, String name, VfpCapacity capacity, Object constituent, ItemStack pantryobject, ItemStack vfpconstituent) {
        category = StringUtils.defaultString((String)category, (String)"pantry");
        boolean regular = constituent instanceof Item;
        switch (capacity) {
            case PORTABLE: {
                if (regular) {
                    recipes.register(new ShapedOreRecipe(null, pantryobject, new Object[]{"xx", "xx", Character.valueOf('x'), constituent}).setRegistryName(ModInfo.r(name)));
                    if (vfpconstituent == null) break;
                    recipes.register(new ShapelessOreRecipe(null, new ItemStack((Item)constituent, capacity.count()), new Object[]{pantryobject}).setRegistryName(ModInfo.r(name + "_unpack")));
                    break;
                }
                recipes.register(new ShapedOreRecipe(null, pantryobject, new Object[]{"xx", "xx", Character.valueOf('x'), constituent}).setRegistryName(ModInfo.r(name)));
                if (vfpconstituent == null) break;
                recipes.register(new ShapelessOreRecipe(null, vfpconstituent, new Object[]{pantryobject}).setRegistryName(ModInfo.r(name + "_unpack")));
                break;
            }
            case STANDARD_BLOCK: {
                if (regular) {
                    recipes.register(new ShapedOreRecipe(null, pantryobject, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), constituent}).setRegistryName(ModInfo.r(name)));
                    if (vfpconstituent == null) break;
                    recipes.register(new ShapelessOreRecipe(null, new ItemStack((Item)constituent, capacity.count()), new Object[]{pantryobject}).setRegistryName(ModInfo.r(name + "_unpack")));
                    break;
                }
                recipes.register(new ShapedOreRecipe(null, pantryobject, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), constituent}).setRegistryName(ModInfo.r(name)));
                if (vfpconstituent == null) break;
                recipes.register(new ShapelessOreRecipe(null, vfpconstituent, new Object[]{pantryobject}).setRegistryName(ModInfo.r(name + "_unpack")));
            }
        }
    }

    public static final void autosmelt4Pack(String pack, Item cookedItem, float smeltExperience) {
        if (VfpUtils.ingredientDefined(pack)) {
            GameRegistry.addSmelting((ItemStack)((ItemStack)OreDictionary.getOres((String)pack).get(0)), (ItemStack)new ItemStack(cookedItem, VfpCapacity.PORTABLE.count()), (float)(smeltExperience * (float)VfpCapacity.PORTABLE.count()));
        }
    }

    public static final NBTTagCompound addEnchantmentToStack(Enchantment enchantment, int level, NBTTagCompound stackNbt) {
        NBTTagList ench = new NBTTagList();
        NBTTagCompound info = new NBTTagCompound();
        if (level <= 0) {
            level = enchantment.func_77319_d();
        }
        info.func_74777_a("id", (short)Enchantment.func_185258_b((Enchantment)enchantment));
        info.func_74777_a("lvl", (short)level);
        ench.func_74742_a((NBTBase)info);
        stackNbt.func_74782_a("ench", (NBTBase)ench);
        return stackNbt;
    }

    public VfpBuilder(VfpRuntime runtime) {
        Validate.isTrue((runtime != null && runtime.getConfig() != null ? 1 : 0) != 0, (String)"sided runtime MUST be initialized", (Object[])new Object[0]);
        VfpConfig config = runtime.getConfig();
        VfpPotionTypes.init(config);
        this._subBuilders = new VfpBuildHelper[8];
        int i = 0;
        this._subBuilders[i++] = this._additivesBuilder = new AgentsBuildHelper();
        this._subBuilders[i++] = this._milkExtrasBuilder = new MilkExtrasBuildHelper();
        this._subBuilders[i++] = this._sugarExtrasBuilder = new SugarExtrasBuildHelper();
        this._subBuilders[i++] = this._wheatExtrasBuilder = new WheatExtrasBuildHelper();
        this._subBuilders[i++] = this._eggExtrasBuilder = new EggExtrasBuildHelper();
        this._subBuilders[i++] = this._meatExtrasBuilder = new MeatExtrasBuildHelper();
        this._subBuilders[i++] = this._cartonsBuilder = new CartonsBuildHelper();
        this._subBuilders[i++] = this._alwaysLastBuilder = new MiscBuildHelper();
        for (Integrations ii : Integrations.values()) {
            boolean other_present = config.isModLoaded(ii);
            if (other_present) {
                ++this._other_mod_count;
            }
            runtime.getLog().trace("[pre] {} mod loaded before me: {}", (Object)ii.modid(), (Object)other_present);
        }
    }

    public final void begin(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        MinecraftForge.EVENT_BUS.register((Object)new RegisterModObjectsHandler(this));
        this.registerLootTables();
        for (int i = 0; i < this._subBuilders.length; ++i) {
            this._subBuilders[i].installEventBusHandlers(runtime);
        }
        if (config.includeCraftXpAndAchievements()) {
            VfpRewards.init(config);
            MinecraftForge.EVENT_BUS.register((Object)VfpRewards.ForgeEventHandler.init(config));
        }
        if (config.includePotionBrewing()) {
            MinecraftForge.EVENT_BUS.register((Object)VfpPotionTypes.ForgeEventHandler.init(config));
        }
        MinecraftForge.EVENT_BUS.register((Object)new VfpConfigChangedListener(runtime));
    }

    private void registerLootTables() {
        LootTableList.func_186375_a((ResourceLocation)ModInfo.r("gameplay/rewards/basic"));
        LootTableList.func_186375_a((ResourceLocation)ModInfo.r("gameplay/rewards/challenge"));
        LootTableList.func_186375_a((ResourceLocation)ModInfo.r("gameplay/rewards/bigsalad"));
        LootTableList.func_186375_a((ResourceLocation)ModInfo.r("gameplay/rewards/ironstomach"));
    }

    public final void prepareObjects(VfpRuntime runtime) {
        this.doBuildObjects1(runtime);
        this.doBuildObjects2(runtime);
    }

    private void doBuildObjects1(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        MinecraftGlue.GameBlocks.init();
        VfpIconItem modicon = new VfpIconItem();
        config.builderContext().put(VfpOid.Vfp_Icon.fmlid(), (Object)modicon);
        VfpObj.Eek_obj = VfpBuilder.newOptionalItem(VfpOid.Eek_Vfp, true);
        if (runtime.hasUI()) {
            this.setupVfpTab(runtime, modicon);
        }
        IntegrationsImpl.inferGeneralFeatureSupport(config);
        this._additivesBuilder.makeObjects(runtime);
        this._milkExtrasBuilder.makeObjects(runtime);
        this._sugarExtrasBuilder.makeObjects(runtime);
        this._wheatExtrasBuilder.makeObjects(runtime);
        this._eggExtrasBuilder.makeObjects(runtime);
        this._meatExtrasBuilder.makeObjects(runtime);
        this.lockdownPackagedFoodReservedMetaIds();
        this._cartonsBuilder.makeObjects(runtime);
        this._alwaysLastBuilder.makeObjects(runtime);
    }

    private void doBuildObjects2(VfpRuntime runtime) {
        for (int i = 0; i < this._subBuilders.length; ++i) {
            this._subBuilders[i].makeObjectsFinalPass(runtime);
        }
    }

    final void linkRenderModels() {
        VfpRuntime runtime = VanillaFoodPantry.runtime;
        if (runtime.hasUI()) {
            Item modicon = (Item)runtime.getConfig().builderContext().get(VfpOid.Vfp_Icon.fmlid());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Vfp_Icon, modicon);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Eek_Vfp, VfpObj.Eek_obj);
            for (int i = 0; i < this._subBuilders.length; ++i) {
                this._subBuilders[i].linkRenderModels(runtime);
            }
        }
    }

    final void doRegistryDependentLinks1() {
        VfpRuntime runtime = VanillaFoodPantry.runtime;
        for (int i = 0; i < this._subBuilders.length; ++i) {
            this._subBuilders[i].linkObjects(runtime);
        }
    }

    private void doInitLikeFoods(VfpRuntime runtime) {
        for (int i = 0; i < this._subBuilders.length; ++i) {
            this._subBuilders[i].linkLikeFoods(runtime);
        }
    }

    private void doDefineFoodDictionary(VfpRuntime runtime) {
        MinecraftGlue.Potions.registerForgeDictIds();
        for (int i = 0; i < this._subBuilders.length; ++i) {
            this._subBuilders[i].addDictionaryEntries(runtime);
        }
    }

    private void doDefineLoot(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        if (config.allowLootTableEnrichment()) {
            for (int i = 0; i < this._subBuilders.length; ++i) {
                this._subBuilders[i].addLootEntries(runtime);
            }
            IntegrationsImpl.defineModdedLoot(config);
            if (MinecraftGlue.Loot.isEnabled("vanillafoodpantry")) {
                MinecraftForge.EVENT_BUS.register((Object)new VfpLootMerger(runtime));
            }
        }
    }

    final void doRegistryDependentLinks2() {
        VfpRuntime runtime = VanillaFoodPantry.runtime;
        VfpConfig config = runtime.getConfig();
        VfpBuilder.captureDictionary(runtime, "Befor VFP Links");
        IntegrationsImpl.detectActualFeatureSupport(config);
        if (MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded()) {
            TANHelper.initFinal(config);
        }
        this.doInitLikeFoods(runtime);
        this.doDefineFoodDictionary(runtime);
        IntegrationsImpl.finishFoodDictionary(config);
        VfpBuilder.captureDictionary(runtime, "After VFP Links");
        this.doDefineLoot(runtime);
    }

    public final void buildRecipes(VfpRuntime runtime) {
        for (int i = 0; i < this._subBuilders.length; ++i) {
            this._subBuilders[i].buildRecipes(runtime, (IForgeRegistry<IRecipe>)ForgeRegistries.RECIPES);
        }
        IntegrationsImpl.registerCookedGoodMeat(runtime.getConfig());
    }

    public final void sendApiMessages(FMLStateEvent event, VfpRuntime runtime) {
        IntegrationsImpl.registerAutocraftingRecipes(runtime.getConfig());
    }

    private final void buildAdvancements(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        if (config.includeCraftXpAndAchievements()) {
            // empty if block
        }
    }

    public void finish(VfpRuntime runtime) {
        this.buildAdvancements(runtime);
        for (int i = 0; i < this._subBuilders.length; ++i) {
            this._subBuilders[i].finish(runtime);
        }
    }

    private void setupVfpTab(VfpRuntime runtime, final Item tabIcon) {
        if (runtime.getConfig().useOwnTab()) {
            CreativeTabs tabVfp = new CreativeTabs("VFP"){

                @SideOnly(value=Side.CLIENT)
                public ItemStack func_78016_d() {
                    return new ItemStack(tabIcon);
                }
            };
            runtime.setVfpTab(tabVfp);
        }
    }

    private void lockdownPackagedFoodReservedMetaIds() {
        boolean locked_ok = PackagedFood.lockdown();
        Validate.validState((this._other_mod_count == 0 || locked_ok ? 1 : 0) != 0, (String)"Detected packaged food cannot assure fixed starting metas for thirdparty mod additions", (Object[])new Object[0]);
    }

    private static void captureDictionary(VfpRuntime runtime, String when) {
        VfpConfig config = runtime.getConfig();
        if (config.isDebugMode()) {
            config.captureContextOres();
            runtime.getLog().info("Dictionary captured at '" + when + "': {}", config.capturedContextOres());
        }
    }

    static final class RegisterModObjectsHandler {
        private VfpBuilder _owner;

        RegisterModObjectsHandler(VfpBuilder owner) {
            this._owner = owner;
        }

        @SubscribeEvent
        public void doBlocksRegister(RegistryEvent.Register<Block> event) {
            if (this._owner != null) {
                VfpUtils.autoregisterBlocks((IForgeRegistry<Block>)event.getRegistry());
            }
        }

        @SubscribeEvent
        public void doItemsRegister(RegistryEvent.Register<Item> event) {
            if (this._owner != null) {
                VfpUtils.autoregisterItems((IForgeRegistry<Item>)event.getRegistry());
                this._owner.doRegistryDependentLinks1();
            }
        }

        @SubscribeEvent
        public void doInventoryRenderModelsRegister(ModelRegistryEvent event) {
            if (this._owner != null) {
                this._owner.linkRenderModels();
            }
        }

        @SubscribeEvent
        public void doRecipesRegister(RegistryEvent.Register<IRecipe> event) {
            if (this._owner != null) {
                this._owner.doRegistryDependentLinks2();
                this._owner = null;
            }
        }
    }
}

