/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.Soakable;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public class VfpSoakableFood
extends VfpPantryMultiItem
implements Soakable {
    protected VfpSoakableFood(VfpProfile oid, VfpVariant[] variants, CreativeTabs tab, boolean delayed) {
        super(oid, false, variants, tab, delayed);
    }

    protected VfpSoakableFood(VfpProfile oid, VfpVariant[] variants, CreativeTabs tab) {
        super(oid, false, variants, tab);
    }

    @Override
    public boolean isSoaked(ItemStack stack) {
        return MinecraftGlue.Potions.isa(stack, true);
    }

    @Override
    public int func_77626_a(ItemStack stack) {
        return this.isSoaked(stack) ? MinecraftGlue.SHORT_FOOD_CONSUME_DURATION() : super.func_77626_a(stack);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ActionResult result;
        ItemStack stack = player.func_184586_b(hand);
        if (this.isSoaked(stack) && (stack.func_190916_E() == 1 || !this.isMultiuse(stack))) {
            player.func_184598_c(hand);
            result = ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        } else {
            result = super.func_77659_a(world, player, hand);
        }
        return result;
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        if (this.isSoaked(original)) {
            MinecraftGlue.Potions.addPotionEffects((EntityLivingBase)player, original);
        }
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
    }

    public String func_77653_i(ItemStack stack) {
        String displayName = super.func_77653_i(stack);
        if (this.isSoaked(stack)) {
            displayName = MinecraftGlue.Strings.translateFormatted("tooltip.itemsuffix.footnoted", displayName, "*");
        }
        return displayName;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List tooltip, ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltip, flags);
        if (this.isSoaked(stack)) {
            if (this.isMultiuse(stack) || this._debugFlag) {
                tooltip.add("");
            }
            MinecraftGlue.Potions.addPotionInformation(MinecraftGlue.Potions.getEffects(stack, false), tooltip, flags.func_194127_a());
        }
    }
}

