/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;

public enum VfpCapacity {
    NONE(1),
    MAX_STACK_LCD(8),
    MAX_STACK(MinecraftGlue.MAX_STACK_SIZE()),
    PORTABLE(MinecraftGlue.PLAYER_CRAFT_GRID_SIZE()),
    STANDARD_BLOCK(MinecraftGlue.TABLE_CRAFT_GRID_SIZE()),
    TABLE_GRID_MINUS_1(MinecraftGlue.TABLE_CRAFT_GRID_SIZE() - 1),
    DRIED_BLOCK(TABLE_GRID_MINUS_1.count()),
    COMPRESSIBLE_BLOCK(TABLE_GRID_MINUS_1.count()),
    BOTTLE(TABLE_GRID_MINUS_1.count()),
    TRAY(TABLE_GRID_MINUS_1.count()),
    HALF_TRAY(TRAY.count() / 2),
    BAKERS_TRAY(6),
    SMALL_STACK(4),
    MEDIUM_STACK(16),
    LIQUID_STACK(24),
    FULL_BUCKET_STACK(16),
    LARGE_STACK(32),
    BULK_STACK(MinecraftGlue.MAX_STACK_SIZE()),
    BUCKET(32),
    CRYSTAL_BATCH(6),
    DENSE_CRYSTAL_BATCH(24),
    ADDITIVE_BATCH(8),
    COOKIE_BATCH(8),
    TAFFY_BATCH(16),
    SANDWICH_BATCH(3),
    MUFFIN_BATCH(6),
    PINCHES_BATCH(4),
    DENSE_BLOCK(32),
    SOLID_BLOCK(MinecraftGlue.MAX_STACK_SIZE());

    private static final VfpCapacity[] _ALLOWED_CONFIG_CAPACITIES;
    private final int _count;

    private VfpCapacity(int count) {
        this._count = count;
    }

    public int count() {
        return this._count;
    }

    public static final VfpCapacity fromConfig(int n, VfpCapacity dflt) {
        for (VfpCapacity capacity : _ALLOWED_CONFIG_CAPACITIES) {
            if (n != capacity.count()) continue;
            return capacity;
        }
        return dflt;
    }

    static {
        _ALLOWED_CONFIG_CAPACITIES = new VfpCapacity[]{NONE, SMALL_STACK, TRAY, MEDIUM_STACK, LIQUID_STACK, LARGE_STACK, BULK_STACK};
    }
}

