/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.carton;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.carton.BagsOf;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryCarton;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;

public final class VegetableCarton
extends VfpPantryCarton {
    private static final VfpVariantSet VARIANT_SET = new VfpPantryCarton.VariantSet(VfpOid.Vegetable_Carton, VegetableCarton.class);
    private static VegetableCarton INSTANCE;
    private static ArrayList<PackagedFood> EXCLUSIONS;

    public VegetableCarton() {
        super((VfpProfile)VfpOid.Vegetable_Carton, MinecraftGlue.Blocks_sponge, VfpObj.Eek_obj, VARIANT_SET, null);
    }

    static final synchronized boolean exclude(PackagedFood bagof) {
        boolean added = false;
        if (INSTANCE == null && !EXCLUSIONS.contains(bagof)) {
            added = EXCLUSIONS.add(bagof);
        }
        return added;
    }

    static final VegetableCarton makeObjects() {
        if (INSTANCE == null) {
            PackagedFood.Type veggies = PackagedFood.Type.vegetable;
            VfpVariant[] variants = PackagedFood.init(veggies, VARIANT_SET, VfpObj.Bag_of_obj, BagsOf.variantsFor(veggies.name()), EXCLUSIONS, true);
            Validate.validState((variants != null && variants.length > 0 ? 1 : 0) != 0, (String)"Unable to create VFP vegetable carton variants", (Object[])new Object[0]);
            INSTANCE = VfpPantryMultiBlock.create(VARIANT_SET, VegetableCarton.class, true);
        }
        return INSTANCE;
    }

    static final ItemStack[] buildRecipes(IForgeRegistry<IRecipe> recipes) {
        Validate.validState((INSTANCE != null ? 1 : 0) != 0, (String)"VegetableCarton must be initialized before being used", (Object[])new Object[0]);
        return VfpPantryCarton.autorecipe(recipes, INSTANCE);
    }

    static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    static {
        EXCLUSIONS = new ArrayList();
        EXCLUSIONS.add(PackagedFood.MUSHROOM);
        EXCLUSIONS.add(PackagedFood.RED_MUSHROOM);
        EXCLUSIONS.add(PackagedFood.BEETROOT);
    }
}

