/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.carton;

import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.vfp.carton.BagsOf;
import org.jwaresoftware.mcmods.vfp.carton.BakeryCarton;
import org.jwaresoftware.mcmods.vfp.carton.FruitCarton;
import org.jwaresoftware.mcmods.vfp.carton.JarsCarton;
import org.jwaresoftware.mcmods.vfp.carton.MeatsCarton;
import org.jwaresoftware.mcmods.vfp.carton.VegetableCarton;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryBag;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;

public final class CartonsBuildHelper
extends VfpBuildHelperSupport {
    @Override
    protected String categoryName() {
        return "Containers";
    }

    @Override
    public void makeObjects(VfpRuntime runtime) {
        VfpObj.Ink_Jar_obj = VfpBuilder.newStorageJar(VfpOid.Ink_Jar);
        VfpObj.Luminesce_Jar_obj = VfpBuilder.newStorageJar(VfpOid.Luminesce_Jar);
    }

    @Override
    public void makeObjectsFinalPass(VfpRuntime runtime) {
        IntegrationsImpl.registerPackagedFoods(runtime.getConfig());
        VfpObj.Bag_of_obj = BagsOf.makeObjects();
        VfpObj.Bakery_Carton_obj = BakeryCarton.makeObjects();
        VfpObj.Meat_Carton_obj = MeatsCarton.makeObjects();
        VfpObj.Vegetable_Carton_obj = VegetableCarton.makeObjects();
        VfpObj.Fruit_Carton_obj = FruitCarton.makeObjects();
        VfpObj.Jars_Carton_obj = JarsCarton.makeObjects();
    }

    @Override
    public void buildRecipes(VfpRuntime runtime, IForgeRegistry<IRecipe> recipes) {
        BagsOf.buildRecipes(recipes, (VfpPantryBag)VfpObj.Bag_of_obj);
        BakeryCarton.buildRecipes(recipes);
        MeatsCarton.buildRecipes(recipes);
        VegetableCarton.buildRecipes(recipes);
        FruitCarton.buildRecipes(recipes);
        JarsCarton.buildRecipes(recipes);
        ItemStack xpworthy = new ItemStack(VfpObj.Ink_Jar_obj);
        VfpBuilder.autorecipe(recipes, this.categoryName(), VfpOid.Ink_Jar.fmlid(), VfpCapacity.TRAY, (Object)VfpObj.Ink_Sac_obj, xpworthy, VfpObj.Empty_Jar_obj, VfpObj.Ink_Sac_obj);
        VfpRewards.addRewardingCraftItem(xpworthy, VfpOid.Ink_Jar.craftingXp());
        if (VfpUtils.ingredientDefined("itemLuminesceSac")) {
            ItemStack luminesce = (ItemStack)OreDictionary.getOres((String)"itemLuminesceSac").get(0);
            xpworthy = new ItemStack(VfpObj.Luminesce_Jar_obj);
            VfpBuilder.autorecipe(recipes, this.categoryName(), VfpOid.Luminesce_Jar.fmlid(), VfpCapacity.TRAY, (Object)"itemLuminesceSac", xpworthy, VfpObj.Empty_Jar_obj, luminesce);
            VfpRewards.addRewardingCraftItem(xpworthy, VfpOid.Luminesce_Jar.craftingXp());
        }
    }

    @Override
    public void linkRenderModels(VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Ink_Jar, VfpObj.Ink_Jar_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Luminesce_Jar, VfpObj.Luminesce_Jar_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bag_of, VfpObj.Bag_of_obj, BagsOf.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bakery_Carton, VfpObj.Bakery_Carton_obj, BakeryCarton.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Meat_Carton, VfpObj.Meat_Carton_obj, MeatsCarton.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Vegetable_Carton, VfpObj.Vegetable_Carton_obj, VegetableCarton.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fruit_Carton, VfpObj.Fruit_Carton_obj, FruitCarton.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Jars_Carton, VfpObj.Jars_Carton_obj, JarsCarton.variants());
        }
    }

    public static boolean exclude(PackagedFood.Type type, PackagedFood bagof) {
        boolean done = false;
        switch (type) {
            case fruit: {
                done = FruitCarton.exclude(bagof);
                break;
            }
            case vegetable: {
                done = VegetableCarton.exclude(bagof);
                break;
            }
        }
        return done;
    }
}

