/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.DictionaryNameItemAdaptor;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.LiquidType;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPotionTypes;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;

public final class Water
extends VfpLiquidMultiItem
implements IReheatable {
    private static final int _3MINS = 180;
    public static final int GENERIC_COLOR = 3694022;
    public static final int SWEET_COLOR = 9411776;
    public static final int ROSE_COLOR = 15059658;
    public static final int TONICS_COLOR = 15708682;
    public static final int TULIP_COLOR = 0xFFCACA;
    public static final int FIZZY_COLOR = 33731;
    public static final int SWAMP_COLOR = 4354870;
    public static final int BIRCH_COLOR = 12503149;
    private static final int _PLAIN = 0;
    private static final int _SWEET = 1;
    private static final int _ROSE = 2;
    private static final int _TULIP = 3;
    static final int _FIZZY = 4;
    private static final int _SWAMP = 5;
    private static final int _BIRCH = 6;
    static final int _IDS_END = 7;
    public static final int FIRST_CUSTOM_ID = 33;
    private static final MinecraftGlue.ItemStackDef _PLACEHOLDER = MinecraftGlue.ItemStackDef.UNUSED;
    private static final List<Ingredient> VARIANT_FLAVORS = new ArrayList<Ingredient>();
    private static final VfpVariantSet VARIANT_SET;
    private static Water INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;
    private static boolean _INCLUDE_BIRCH;

    public static final synchronized boolean register(Flavor flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null flavor is required for a flavored water drink", (Object[])new Object[0]);
        if (flavor.id() >= 0 && flavor.id() < 7) {
            return false;
        }
        return Water.register(flavor, VARIANT_FLAVORS, "water");
    }

    public Water(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, VARIANT_SET, LiquidType.WATER, tab);
        this.func_185043_a(new ResourceLocation("temperature"), new IReheatable.TemperaturePropertyGetter(false));
        this.func_77848_i();
    }

    @Override
    protected ItemStack getNewEmptyContainer() {
        return new ItemStack(VfpObj.Our_Empty_Bottle_obj);
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpCapacity.MAX_STACK;
    }

    @Nullable
    private Ingredient ingredientFrom(ItemStack drink) {
        return VfpVariant.byItemStack(drink, this._variant_default).datadata(Ingredient.class);
    }

    @Override
    public int func_77626_a(ItemStack drink) {
        Ingredient ingredient = this.ingredientFrom(drink);
        return ingredient != null && ingredient.id() == 3 ? MinecraftGlue.SHORT_FOOD_CONSUME_DURATION() : MinecraftGlue.DEFAULT_LIQUID_USE_DURATION();
    }

    @Override
    protected Integer getVariantColorFromMeta(VfpVariant type, Ingredient ingredient, int renderPass) {
        Integer colorValue = super.getVariantColorFromMeta(type, ingredient, renderPass);
        if (colorValue == null) {
            colorValue = 3694022;
        }
        return colorValue;
    }

    @Override
    protected boolean showSubItem(VfpVariant variant, CreativeTabs forTab, CreativeTabs pickedTab) {
        boolean show = true;
        if (variant.metadata() == 6) {
            show = _INCLUDE_BIRCH;
        }
        return show;
    }

    @Override
    protected void onFoodEaten(ItemStack drink, ItemStack remaining, World world, EntityPlayer player) {
        Ingredient ingredient = this.ingredientFrom(drink);
        if (ingredient != null) {
            if (ingredient.id() == 3) {
                MinecraftGlue.Potions.cureFireBurningEffects(player, true);
            }
            if (MinecraftGlue.isaServerWorld((IBlockAccess)world)) {
                if (ingredient.id() == 6) {
                    MinecraftGlue.Potions.removePotionEffect((EntityLivingBase)player, MinecraftGlue.Potion_hunger);
                }
                if (ingredient.id() == 3) {
                    MinecraftGlue.Potions.removePotionEffect((EntityLivingBase)player, MinecraftGlue.Potion_poison);
                    boolean badJuJu = player.func_70644_a(MinecraftGlue.Potion_badLuck);
                    if (badJuJu) {
                        MinecraftGlue.Potions.removePotionEffect((EntityLivingBase)player, MinecraftGlue.Potion_badLuck);
                    } else if (world.field_73012_v.nextInt(8) == 0) {
                        MinecraftGlue.Potions.addStubbornPotionEffect((EntityLivingBase)player, MinecraftGlue.Potion_luck, 180, 0, false, true);
                    }
                }
                if (ingredient.id() == 5 && world.field_73012_v.nextInt(4) == 0) {
                    MinecraftGlue.Potions.addPotionEffect((EntityLivingBase)player, MinecraftGlue.Potion_levitation, 180, 0, false, true);
                    MinecraftGlue.Potions.addPotionEffect((EntityLivingBase)player, MinecraftGlue.Potion_glowing, 180, 0, false, true);
                }
            }
        }
        super.onFoodEaten(drink, remaining, world, player);
    }

    @Override
    public int getThirstQuenched(ItemStack drink) {
        Ingredient ingredient;
        int amount = super.getThirstQuenched(drink);
        if (!(drink.func_190926_b() || (ingredient = this.ingredientFrom(drink)) == null || ingredient.id() != 1 && ingredient.id() != 5)) {
            amount = LiquidType.TRACE.getThirst();
        }
        return amount;
    }

    @Override
    public float getHydrationAdded(ItemStack drink) {
        Ingredient ingredient;
        float amount = super.getHydrationAdded(drink);
        if (!(drink.func_190926_b() || (ingredient = this.ingredientFrom(drink)) == null || ingredient.id() != 1 && ingredient.id() != 5)) {
            amount = LiquidType.TRACE.getHydration();
        }
        return amount;
    }

    @Override
    public int getTemperatureModifier(ItemStack drink) {
        Ingredient ingredient = this.ingredientFrom(drink);
        int chill = 0;
        if (ingredient != null) {
            int id = ingredient.id();
            if (id == 0) {
                chill = 3;
            } else if (id == 4) {
                chill = 2;
            } else if (id == 2) {
                chill = 1;
            }
        }
        return chill;
    }

    @Override
    public int getCoolDuration(ItemStack drink) {
        return 480;
    }

    @Override
    public int getBonusTemperatureTimeLeftForApply(ItemStack drink, int min) {
        if (this.getTemperatureModifier(drink) < 1) {
            return 0;
        }
        if (min <= 0) {
            min = 90;
        }
        return Math.max(min, this.getBonusTemperatureTimeLeft(drink));
    }

    public void func_77622_d(ItemStack drink, World world, EntityPlayer player) {
        IReheatable.ConsumedEffect e = IReheatable.ConsumedEffect.UNCHANGED;
        if (this.getTemperatureModifier(drink) > 0) {
            e = this.onCreateCheckBonusTemperature(drink);
        }
        super.func_77622_d(drink, world, player);
        if (IReheatable.ConsumedEffect.COOLED.equals((Object)e)) {
            this.setCooled(drink);
        }
    }

    public void func_77663_a(ItemStack drink, World world, Entity holder, int slotindex, boolean selected) {
        this.onUpdateTickBonusTemperature(drink, world, holder, slotindex, selected);
    }

    static final synchronized Water makeObjects() {
        if (INSTANCE == null) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(23);
            String typeName = VARIANT_SET.typeName();
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                LikeFood like;
                LikeFood likeFood = like = ingredient.isPlaceholder() ? LikeFood.water : LikeFood.flavored_water;
                if (ingredient.id() == 6 || ingredient.id() == 3) {
                    like = LikeFood.birch_sap;
                }
                variants.add(new VfpTransientVariant(ingredient.id(), typeName, like, ingredient, null, VARIANT_SET));
            }
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Water_Bottle, Water.class);
        }
        return INSTANCE;
    }

    static final void addDictionaryEntries() {
        if (INSTANCE != null) {
            ItemStack plain_water = new ItemStack((Item)INSTANCE, 1, 0);
            OreDictionary.registerOre((String)"portionWater", (ItemStack)plain_water);
            OreDictionary.registerOre((String)"itemWaterBottle", (ItemStack)plain_water);
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                if (!ingredient.isEnabled()) continue;
                ItemStack a_water_drink = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                OreDictionary.registerOre((String)"foodDrink", (ItemStack)a_water_drink);
                if (ingredient.id() != 6 && ingredient.id() != 3) continue;
                OreDictionary.registerOre((String)"foodCurative", (ItemStack)a_water_drink);
            }
        }
    }

    public static final void registerAllUnderDictEntry(String forgeid) {
        if (INSTANCE != null) {
            OreDictionary.registerOre((String)forgeid, (ItemStack)Water.plain(1));
            OreDictionary.registerOre((String)forgeid, (ItemStack)Water.fizzy(1));
        }
    }

    static final void buildRecipes(VfpRuntime runtime, IForgeRegistry<IRecipe> recipes) {
        if (runtime.getConfig().includePotionBrewing()) {
            MinecraftGlue.BrewEffect.addRecipeFor((Item)INSTANCE, 5, VfpPotionTypes.SWAMP_ESSENCE);
            MinecraftGlue.BrewEffect.addStrengthConversionFor(VfpPotionTypes.SWAMP_ESSENCE, VfpPotionTypes.STRONG_SWAMP_ESSENCE);
        }
        if (TYPED_INSTANCES == null && Water.makeObjects() != null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(23);
            ItemStack plain_water = new ItemStack((Item)INSTANCE, 1, 0);
            instances.add(plain_water.func_77946_l());
            recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Our_Empty_Bottle_obj, 6), new Object[]{"bbb", "bbb", "p  ", Character.valueOf('p'), "portionWaterSmall", Character.valueOf('b'), VfpObj.Empty_Bottle_obj}).setRegistryName(ModInfo.r(VfpOid.Empty_Bottle.fmlid() + "_from_potion_bottle")));
            instances.add(new ItemStack((Item)INSTANCE, 1, 1));
            recipes.register(new ShapedOreRecipe(null, new ItemStack((Item)INSTANCE, 2, 1), new Object[]{"ssa", "Wh ", "bb ", Character.valueOf('s'), VfpObj.Hardened_Sugar_obj, Character.valueOf('a'), FoodPowders.get(FoodPowders.Type.APPLE, 1), Character.valueOf('W'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall", Character.valueOf('b'), "itemEmptyBottle"}).setRegistryName(ModInfo.r("drink_syrup_base")));
            instances.add(new ItemStack((Item)INSTANCE, 1, 2));
            recipes.register(new ShapedOreRecipe(null, new ItemStack((Item)INSTANCE, 2, 2), new Object[]{"rr", "Wh", "bb", Character.valueOf('r'), VfpObj.Rose_plant_obj, Character.valueOf('W'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall", Character.valueOf('b'), "itemEmptyBottle"}).setRegistryName(ModInfo.r("bottle_rose_water")));
            recipes.register(new ShapelessOreRecipe(null, new ItemStack((Item)INSTANCE, 1, 2), new Object[]{FoodPowders.get(FoodPowders.Type.ROSE, 1), "portionHeatSmall", "itemWaterBottle"}).setRegistryName(ModInfo.r("bottle_rose_water_from_foodpowder")));
            instances.add(new ItemStack((Item)INSTANCE, 1, 3));
            recipes.register(new ShapedOreRecipe(null, new ItemStack((Item)INSTANCE, 1, 3), new Object[]{"ttt", "twt", "ttt", Character.valueOf('t'), "foodFlower", Character.valueOf('w'), new ItemStack((Item)INSTANCE, 1, 2)}).setRegistryName(ModInfo.r("bottle_tulip_tonic")));
            recipes.register(new ShapelessOreRecipe(null, new ItemStack((Item)INSTANCE, 1, 3), new Object[]{new ItemStack((Item)INSTANCE, 1, 2), "additiveFlowerPower", "additiveFlowerPower"}).setRegistryName(ModInfo.r("bottle_tulip_tonic_from_foodpowder")));
            instances.add(new ItemStack((Item)INSTANCE, 1, 4));
            instances.add(new ItemStack((Item)INSTANCE, 1, 5));
            recipes.register(new ShapedOreRecipe(null, new ItemStack((Item)INSTANCE, 2, 5), new Object[]{"llf", "Wh ", "bb ", Character.valueOf('l'), MinecraftGlue.Blocks_waterlily, Character.valueOf('f'), FoodPowders.get(FoodPowders.Type.FEATHER, 1), Character.valueOf('W'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall", Character.valueOf('b'), "itemEmptyBottle"}).setRegistryName(ModInfo.r("bottle_swamp_essense")));
            instances.add(new ItemStack((Item)INSTANCE, 1, 6));
            _INCLUDE_BIRCH = VfpUtils.ingredientDefined("itemBirchSapBucket");
            if (_INCLUDE_BIRCH) {
                recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(null, new ItemStack((Item)INSTANCE, 2, 6), new Object[]{"B ", "bb", Character.valueOf('B'), "itemBirchSapBucket", Character.valueOf('b'), "itemEmptyBottle"}).setRegistryName(ModInfo.r("bottle_birch_sap_tonic")), LikeFood.birch_sap.craftExperience()));
            }
            for (int i = 7; i < VARIANT_FLAVORS.size(); ++i) {
                instances.add(new ItemStack((Item)INSTANCE, 1, VARIANT_FLAVORS.get(i).id()));
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final ItemStack any() {
        return new ItemStack((Item)INSTANCE, 1, Short.MAX_VALUE);
    }

    public static final ItemStack plain(int amount) {
        return new ItemStack((Item)INSTANCE, amount, 0);
    }

    public static final ItemStack sweet(int amount) {
        return new ItemStack((Item)INSTANCE, amount, 1);
    }

    public static final ItemStack fizzy(int amount) {
        return new ItemStack((Item)INSTANCE, amount, 4);
    }

    public static final ItemStack swamp(int amount) {
        return new ItemStack((Item)INSTANCE, amount, 5);
    }

    public static final ItemStack birch(int amount) {
        return new ItemStack((Item)INSTANCE, amount, 6);
    }

    public static final ItemStack other(int id, int amount) {
        for (int i = 0; i < VARIANT_FLAVORS.size(); ++i) {
            Ingredient ingredient = VARIANT_FLAVORS.get(i);
            if (ingredient.id() != id) continue;
            return new ItemStack((Item)INSTANCE, amount, id);
        }
        return MinecraftGlue.ItemStacks_NULLSTACK();
    }

    static {
        Flavor plain_water = new Flavor(0, "plain", _PLACEHOLDER, -1);
        VARIANT_FLAVORS.add(plain_water);
        Flavor sweet_water = new Flavor(1, "sweet", "ingredientSweetener", 9411776);
        VARIANT_FLAVORS.add(sweet_water);
        Flavor rose_water = new Flavor(2, "rose", _PLACEHOLDER, 15059658);
        VARIANT_FLAVORS.add(rose_water);
        Flavor tulip_water = new Flavor(3, "tulip", _PLACEHOLDER, 0xFFCACA);
        VARIANT_FLAVORS.add(tulip_water);
        Flavor fizzy_water = new Flavor(4, "fizzy", _PLACEHOLDER, 33731);
        VARIANT_FLAVORS.add(fizzy_water);
        Flavor swamp_water = new Flavor(5, "swamp", _PLACEHOLDER, 4354870);
        VARIANT_FLAVORS.add(swamp_water);
        Flavor birch_sap = new Flavor(6, "birch_sap", "itemBirchSapBucket", 12503149);
        VARIANT_FLAVORS.add(birch_sap);
        VARIANT_SET = new VfpLiquidMultiItem.VariantSet((VfpProfile)VfpOid.Water_Bottle, (Class)Water.class){

            @Override
            protected VfpVariant[] declaredVariants() {
                return this.values().toArray(VfpVariant.EMPTY_ARRAY);
            }
        };
        _INCLUDE_BIRCH = false;
    }

    public static final class Flavor
    extends Ingredient
    implements FoodColor {
        private final int _colorValue;

        public Flavor(int id, String name, MinecraftGlue.ItemStackDef primary, int colorValue) {
            super(name, id, primary, 1);
            this._colorValue = colorValue >= 0 ? colorValue : 3694022;
        }

        public Flavor(int id, String name, String primary, int colorValue) {
            this(id, name, DictionaryNameItemAdaptor.newi(primary), colorValue);
        }

        @Override
        public int color(ItemStack stack) {
            return this._colorValue;
        }
    }
}

