/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.proxy;

import betterwithmods.api.client.IColorable;
import betterwithmods.client.BWStateMapper;
import betterwithmods.client.ClientEventHandler;
import betterwithmods.client.ColorHandlers;
import betterwithmods.client.ResourceProxy;
import betterwithmods.client.model.ModelKiln;
import betterwithmods.client.model.render.RenderUtils;
import betterwithmods.client.render.RenderBroadheadArrow;
import betterwithmods.client.render.RenderExtendingRope;
import betterwithmods.client.render.RenderJungleSpider;
import betterwithmods.client.render.RenderMiningCharge;
import betterwithmods.client.render.RenderShearedCreeper;
import betterwithmods.client.render.RenderTentacle;
import betterwithmods.client.render.RenderUrn;
import betterwithmods.client.tesr.TESRBeacon;
import betterwithmods.client.tesr.TESRBucket;
import betterwithmods.client.tesr.TESRCookingPot;
import betterwithmods.client.tesr.TESRFilteredHopper;
import betterwithmods.client.tesr.TESRFurnaceContent;
import betterwithmods.client.tesr.TESRSteelSaw;
import betterwithmods.client.tesr.TESRTurntable;
import betterwithmods.client.tesr.TESRVerticalWindmill;
import betterwithmods.client.tesr.TESRWaterwheel;
import betterwithmods.client.tesr.TESRWindmill;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.blocks.mechanical.tile.TileEntityCauldron;
import betterwithmods.common.blocks.mechanical.tile.TileEntityCrucible;
import betterwithmods.common.blocks.mechanical.tile.TileEntityFilteredHopper;
import betterwithmods.common.blocks.mechanical.tile.TileEntityTurntable;
import betterwithmods.common.blocks.mechanical.tile.TileEntityWaterwheel;
import betterwithmods.common.blocks.mechanical.tile.TileEntityWindmillHorizontal;
import betterwithmods.common.blocks.mechanical.tile.TileEntityWindmillVertical;
import betterwithmods.common.blocks.mechanical.tile.TileSteelSaw;
import betterwithmods.common.blocks.tile.TileEntityBeacon;
import betterwithmods.common.blocks.tile.TileEntityBucket;
import betterwithmods.common.entity.EntityBroadheadArrow;
import betterwithmods.common.entity.EntityDynamite;
import betterwithmods.common.entity.EntityExtendingRope;
import betterwithmods.common.entity.EntityJungleSpider;
import betterwithmods.common.entity.EntityMiningCharge;
import betterwithmods.common.entity.EntityShearedCreeper;
import betterwithmods.common.entity.EntitySpiderWeb;
import betterwithmods.common.entity.EntityUrn;
import betterwithmods.manual.api.ManualAPI;
import betterwithmods.manual.api.prefab.manual.TextureTabIconRenderer;
import betterwithmods.manual.common.DirectoryDefaultProvider;
import betterwithmods.manual.common.api.ManualDefinitionImpl;
import betterwithmods.manual.custom.StatePathProvider;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.gameplay.breeding_harness.BreedingHarness;
import betterwithmods.module.gameplay.breeding_harness.CapabilityHarness;
import betterwithmods.module.hardcore.crafting.HCFurnace;
import betterwithmods.module.hardcore.creatures.EntityTentacle;
import betterwithmods.module.hardcore.needs.HCGloom;
import betterwithmods.module.hardcore.world.stumping.HCStumping;
import betterwithmods.module.hardcore.world.stumping.PlacedCapability;
import betterwithmods.proxy.IProxy;
import betterwithmods.util.ReflectionLib;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="betterwithmods", value={Side.CLIENT})
public class ClientProxy
implements IProxy {
    private static ResourceProxy resourceProxy;

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        BWMItems.getItems().forEach(BWMItems::setInventoryModel);
        ModelLoader.setCustomStateMapper((Block)BWMBlocks.STOKED_FLAME, (IStateMapper)new BWStateMapper(BWMBlocks.STOKED_FLAME.getRegistryName().toString()));
        ModelLoader.setCustomStateMapper((Block)BWMBlocks.WINDMILL, (IStateMapper)new BWStateMapper(BWMBlocks.WINDMILL.getRegistryName().toString()));
        ModelLoader.setCustomStateMapper((Block)BWMBlocks.WATERWHEEL, (IStateMapper)new BWStateMapper(BWMBlocks.WATERWHEEL.getRegistryName().toString()));
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelKiln.Loader());
        ModuleLoader.registerModels(event);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        ModuleLoader.preInitClient(event);
        this.registerRenderInformation();
        this.initRenderers();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        List packs = (List)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])ReflectionLib.DEFAULT_RESOURCE_PACKS);
        ModuleLoader.initClient(event);
        this.registerColors();
        ManualAPI.addProvider(new DirectoryDefaultProvider(new ResourceLocation("betterwithmods", "documentation/docs/")));
        ManualDefinitionImpl.INSTANCE.addDefaultProviders();
        ManualAPI.addProvider(new StatePathProvider());
        ManualAPI.addTab(new TextureTabIconRenderer(new ResourceLocation("betterwithmods", "textures/gui/manual_home.png")), "bwm.manual.home", "%LANGUAGE%/index.md");
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ModuleLoader.postInitClient(event);
        RenderUtils.registerFilters();
    }

    private void registerRenderInformation() {
        OBJLoader.INSTANCE.addDomain("betterwithmods");
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWindmillHorizontal.class, (TileEntitySpecialRenderer)new TESRWindmill());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWindmillVertical.class, (TileEntitySpecialRenderer)new TESRVerticalWindmill());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWaterwheel.class, (TileEntitySpecialRenderer)new TESRWaterwheel());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFilteredHopper.class, (TileEntitySpecialRenderer)new TESRFilteredHopper());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTurntable.class, (TileEntitySpecialRenderer)new TESRTurntable());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCauldron.class, (TileEntitySpecialRenderer)new TESRCookingPot());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCrucible.class, (TileEntitySpecialRenderer)new TESRCookingPot());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBeacon.class, (TileEntitySpecialRenderer)new TESRBeacon());
        ClientRegistry.bindTileEntitySpecialRenderer(TileSteelSaw.class, (TileEntitySpecialRenderer)new TESRSteelSaw());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBucket.class, (TileEntitySpecialRenderer)new TESRBucket());
        if (ModuleLoader.isFeatureEnabled(HCFurnace.class)) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFurnace.class, (TileEntitySpecialRenderer)new TESRFurnaceContent());
        }
    }

    private void registerColor(ItemColors registry, Item item) {
        if (item instanceof IColorable) {
            registry.func_186730_a(((IColorable)item).getColorHandler(), new Item[]{item});
        }
    }

    private void registerColors() {
        BlockColors col = Minecraft.func_71410_x().func_184125_al();
        col.func_186722_a(ColorHandlers.BlockPlanterColor, new Block[]{BWMBlocks.PLANTER});
        col.func_186722_a(ColorHandlers.BlockFoliageColor, new Block[]{BWMBlocks.VINE_TRAP});
        col.func_186722_a(ColorHandlers.BlockBloodLeafColor, new Block[]{BWMBlocks.BLOOD_LEAVES});
        ItemColors itCol = Minecraft.func_71410_x().getItemColors();
        itCol.func_186731_a(ColorHandlers.ItemPlanterColor, new Block[]{BWMBlocks.PLANTER});
        itCol.func_186731_a(ColorHandlers.ItemFoliageColor, new Block[]{BWMBlocks.VINE_TRAP});
        itCol.func_186731_a(ColorHandlers.ItemBloodLeafColor, new Block[]{BWMBlocks.BLOOD_LEAVES});
        BWMItems.getItems().forEach(item -> this.registerColor(itCol, (Item)item));
        col.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0), new Block[]{BWMBlocks.DIRT_SLAB});
        itCol.func_186731_a((stack, tintIndex) -> {
            IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return col.func_186724_a(iblockstate, null, null, tintIndex);
        }, new Block[]{BWMBlocks.DIRT_SLAB});
    }

    private void initRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamite.class, manager -> new RenderSnowball(manager, BWMItems.DYNAMITE, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityUrn.class, RenderUrn::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityMiningCharge.class, RenderMiningCharge::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityExtendingRope.class, RenderExtendingRope::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityShearedCreeper.class, RenderShearedCreeper::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBroadheadArrow.class, RenderBroadheadArrow::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpiderWeb.class, manager -> new RenderSnowball(manager, Item.func_150898_a((Block)Blocks.field_150321_G), Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityJungleSpider.class, RenderJungleSpider::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTentacle.class, RenderTentacle::new);
    }

    @Override
    public void addResourceOverride(String space, String dir, String file, String ext) {
        resourceProxy.addResource(space, dir, file, ext);
    }

    @Override
    public void addResourceOverride(String space, String domain, String dir, String file, String ext) {
        resourceProxy.addResource(space, domain, dir, file, ext);
    }

    @Override
    public void syncHarness(int entityId, ItemStack harness) {
        CapabilityHarness cap;
        Entity entity = this.getEntityByID(entityId);
        if (entity != null && (cap = BreedingHarness.getCapability(entity)) != null) {
            cap.setHarness(harness);
        }
    }

    private Entity getEntityByID(int id) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return null;
        }
        return world.func_73045_a(id);
    }

    private EntityPlayer getPlayerById(String id) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return null;
        }
        return world.func_152378_a(UUID.fromString(id));
    }

    @Override
    public void syncGloom(String entityId, int gloom) {
        HCGloom.Gloom g;
        EntityPlayer e = this.getPlayerById(entityId);
        if (e != null && (g = HCGloom.getGloom((Entity)e)) != null) {
            g.setGloom(gloom);
        }
    }

    @Override
    public void syncPlaced(BlockPos[] pos) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        PlacedCapability capability = HCStumping.getCapability((World)world);
        if (capability != null) {
            capability.addAll(pos);
        }
    }

    static {
        List packs = (List)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])ReflectionLib.DEFAULT_RESOURCE_PACKS);
        resourceProxy = new ResourceProxy();
        packs.add(resourceProxy);
    }

    public static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final Fluid fluid;
        public final ModelResourceLocation location;

        public FluidStateMapper(Fluid fluid) {
            this.fluid = fluid;
            this.location = new ModelResourceLocation(new ResourceLocation("betterwithmods", "fluid_block"), fluid.getName());
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            return this.location;
        }

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            return this.location;
        }
    }
}

