/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.world;

import betterwithmods.BWMod;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockIce;
import betterwithmods.common.blocks.behaviors.BehaviorFluidContainer;
import betterwithmods.module.ConfigHelper;
import betterwithmods.module.Feature;
import betterwithmods.module.GlobalConfig;
import betterwithmods.util.FluidUtils;
import betterwithmods.util.ReflectionLib;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCBuckets
extends Feature {
    private static List<String> fluidWhitelist;
    private static List<ResourceLocation> fluidcontainerBacklist;
    private static List<Integer> dimensionBlacklist;
    private static boolean fixIce;
    private static Block ICE;
    public static boolean modifyDispenserBehavior;
    public static boolean stopDispenserFillBehavior;

    @Override
    public String getFeatureDescription() {
        return "Makes it so water buckets cannot move an entire source block, making water a more valuable resource";
    }

    @Override
    public void setupConfig() {
        dimensionBlacklist = Ints.asList((int[])this.loadPropIntList("Dimension Black List", "A List of dimension ids in which water buckets will work normally. This is done in the End by default to make Enderman Farms actually reasonable to create.", new int[]{DimensionType.THE_END.func_186068_a()}));
        fluidWhitelist = Lists.newArrayList((Object[])this.loadPropStringList("Fluid Whitelist", "List of fluids that will be handled by HCBuckets.", new String[]{FluidRegistry.WATER.getName(), FluidRegistry.LAVA.getName(), "swamp_water", "milk", "stagnant_water", "acid", "sludge", "ale", "alewort", "applejuice", "cider", "grapejuice", "honey", "ironberryjuice", "ironwine", "mead", "oliveoil", "wildberryjuice", "wildberrywine", "wine", "blood", "purpleslime"}));
        fixIce = this.loadPropBool("Fix ice", "Replace ice block so that it does not place water sources when it melts or is broken.", true);
        modifyDispenserBehavior = this.loadPropBool("Modify dispenser behavior", "Change how the Dispenser handles buckets when activated.", true);
        stopDispenserFillBehavior = this.loadPropBool("Stop Dispenser Fill Behavior", "Disallow the dispenser from using an empty bucket for anything.", false);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (fixIce) {
            BWMBlocks.registerBlock(ICE);
            ReflectionLib.reflectSubalias(ICE, "field_150432_aD", "ICE");
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        fluidcontainerBacklist = ConfigHelper.loadPropRLList("Fluid container blacklist", this.configCategory, "Blacklist itemstacks from being effected by HCBuckets", new String[]{"thermalcultivation:watering_can"});
        if (modifyDispenserBehavior) {
            BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151133_ar, (Object)BehaviorFluidContainer.getInstance());
            BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151129_at, (Object)BehaviorFluidContainer.getInstance());
            BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151131_as, (Object)BehaviorFluidContainer.getInstance());
            BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151117_aB, (Object)BehaviorFluidContainer.getInstance());
            if (FluidRegistry.isUniversalBucketEnabled()) {
                UniversalBucket item = ForgeModContainer.getInstance().universalBucket;
                BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)BehaviorFluidContainer.getInstance());
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SubscribeEvent
    public void onInteractFluidHandlerItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        IFluidHandlerItem handlerItem = FluidUtil.getFluidHandler((ItemStack)stack);
        if (handlerItem != null) {
            if (stack.func_77973_b() instanceof ItemBucket) {
                return;
            }
            if (fluidcontainerBacklist.contains(stack.func_77973_b().getRegistryName())) {
                return;
            }
            FluidStack contained = FluidUtil.getFluidContained((ItemStack)stack);
            RayTraceResult raytraceresult = stack.func_77973_b().func_77621_a(event.getWorld(), event.getEntityPlayer(), contained == null);
            ActionResult actionResult = ForgeEventFactory.onBucketUse((EntityPlayer)event.getEntityPlayer(), (World)event.getWorld(), (ItemStack)stack, (RayTraceResult)raytraceresult);
            if (actionResult != null && actionResult.func_188397_a() == EnumActionResult.SUCCESS && stack != actionResult.func_188398_b()) {
                event.getEntityPlayer().func_184611_a(event.getHand(), (ItemStack)actionResult.func_188398_b());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onUseFluidContainer(FillBucketEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getTarget() != null) {
            ItemStack container = event.getEmptyBucket();
            RayTraceResult raytraceresult = event.getTarget();
            BlockPos pos = raytraceresult.func_178782_a();
            World world = event.getWorld();
            EntityPlayer player = event.getEntityPlayer();
            if (!PlayerHelper.isSurvival(player)) {
                return;
            }
            if (fluidcontainerBacklist.contains(container.func_77973_b().getRegistryName())) {
                return;
            }
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)container);
            if (dimensionBlacklist.contains(world.field_73011_w.getDimension())) {
                return;
            }
            if (fluidStack != null && !fluidWhitelist.contains(fluidStack.getFluid().getName())) {
                return;
            }
            FluidActionResult result = FluidUtils.tryPickUpFluid(container, player, world, pos, raytraceresult.field_178784_b);
            if (result.isSuccess()) {
                if (player.func_184811_cZ().func_185141_a(container.func_77973_b())) {
                    event.setCanceled(true);
                    return;
                }
                ItemStack filledContainer = result.getResult();
                FluidStack filledFluidStack = FluidUtil.getFluidContained((ItemStack)filledContainer);
                if (filledFluidStack != null && !fluidWhitelist.contains(filledFluidStack.getFluid().getName())) {
                    event.setResult(Event.Result.DEFAULT);
                    return;
                }
                event.setResult(Event.Result.ALLOW);
                event.setFilledBucket(result.getResult());
                player.func_184811_cZ().func_185145_a(container.func_77973_b(), 20);
            } else {
                BlockPos offset = pos.func_177972_a(raytraceresult.field_178784_b);
                IBlockState state = world.func_180495_p(offset);
                if (state.func_185904_a().func_76222_j()) {
                    FluidActionResult placeResult;
                    if (fluidStack != null && fluidStack.amount == 1000 && (placeResult = FluidUtils.tryPlaceFluid(player, world, offset, container, fluidStack)).isSuccess()) {
                        event.setResult(Event.Result.ALLOW);
                        event.setFilledBucket(placeResult.getResult());
                    }
                } else if (!state.func_185904_a().func_76218_k()) {
                    event.setCanceled(true);
                }
            }
            if (GlobalConfig.debug) {
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("FillBucketEvent: %s,%s,%s,%s", new Object[]{event.getTarget().func_178782_a(), event.getTarget().field_72313_a, event.getEmptyBucket() != null ? event.getEmptyBucket().func_82833_r() : null, event.getFilledBucket() != null ? event.getFilledBucket().func_82833_r() : null}));
                BWMod.getLog().info("FillBucketEvent: {}, {}, {}", (Object)event.getTarget(), (Object)event.getEmptyBucket(), (Object)event.getFilledBucket());
            }
        }
    }

    static {
        ICE = (Block)new BlockIce().setRegistryName("minecraft:ice");
    }
}

