/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.crafting.brewing;

import betterwithmods.common.BWMItems;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.module.Feature;
import betterwithmods.module.hardcore.crafting.brewing.MixPredicateHelper;
import betterwithmods.util.ReflectionLib;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.AbstractBrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class HCBrewing
extends Feature {
    private static boolean removeMovementPotions;
    private static boolean waterBreathingAnyFish;
    private static boolean removeWitchPotionDrops;
    private static boolean modPotionCompat;
    private static int potionStackSize;
    private boolean tryChangePotions;

    @Override
    public void setupConfig() {
        removeMovementPotions = this.loadPropBool("Remove Movement Potions", "Removes recipes for Speed and Leaping potions.", true);
        waterBreathingAnyFish = this.loadPropBool("Water Breathing Any Fish", "Any fish works for brewing Water Breathing potions.", true);
        removeWitchPotionDrops = this.loadPropBool("Remove Witch Ingredient Drops", "Removes redstone and glowstone from witch drops", true);
        modPotionCompat = this.loadPropBool("Modded Potion Compatibility", "Similarly modifies non-vanilla potions.", true);
        potionStackSize = this.loadPropInt("Potion Stacksize", "Maximum stacksize of potion items.", 8);
    }

    @Override
    public String getFeatureDescription() {
        return "Modifies and rebalances vanilla brewing recipes and makes potions stack up to 8.";
    }

    private boolean isWitchDropBlacklisted(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == Items.field_151114_aO || item == Items.field_151102_aT || item == Items.field_151070_bp || item == Items.field_151016_H;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void mobDrops(LivingDropsEvent evt) {
        EntityLivingBase entity = evt.getEntityLiving();
        List drops = evt.getDrops();
        if (entity instanceof EntityWitch) {
            Iterator iterator = drops.iterator();
            while (iterator.hasNext()) {
                EntityItem item = (EntityItem)iterator.next();
                ItemStack stack = item.func_92059_d();
                if (removeWitchPotionDrops && this.isWitchDropBlacklisted(stack)) {
                    iterator.remove();
                    continue;
                }
                if (stack.func_77973_b() != Items.field_151137_ax) continue;
                item.func_92058_a(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.WITCH_WART, stack.func_190916_E()));
            }
        }
        if (entity instanceof EntitySquid && entity.field_70170_p.field_73012_v.nextInt(100) < 10) {
            entity.func_70099_a(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.MYSTERY_GLAND), 0.0f);
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        List itemConversions = (List)ReflectionHelper.getPrivateValue(PotionHelper.class, null, (String[])ReflectionLib.POTIONHELPER_ITEM_CONVERSIONS);
        List typeConversions = (List)ReflectionHelper.getPrivateValue(PotionHelper.class, null, (String[])ReflectionLib.POTIONHELPER_TYPE_CONVERSIONS);
        List moddedPotions = typeConversions.stream().filter(this::isModdedPotion).collect(Collectors.toList());
        itemConversions.clear();
        typeConversions.clear();
        this.tryChangePotions = true;
        Items.field_151068_bn.func_77625_d(potionStackSize);
        Items.field_185155_bH.func_77625_d(potionStackSize);
        Items.field_185156_bI.func_77625_d(potionStackSize);
        Ingredient extender = ItemMaterial.getIngredient(ItemMaterial.EnumMaterial.WITCH_WART);
        Ingredient strengthener = ItemMaterial.getIngredient(ItemMaterial.EnumMaterial.BRIMSTONE);
        Ingredient inverter = ItemMaterial.getIngredient(ItemMaterial.EnumMaterial.POISON_SAC);
        Ingredient awkward = Ingredient.func_193367_a((Item)Items.field_151075_bm);
        Ingredient fireResistance = Ingredient.func_193367_a((Item)Items.field_151064_bs);
        Ingredient nightVision = Ingredient.func_193367_a((Item)Items.field_151070_bp);
        Ingredient poison = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)Blocks.field_150337_Q)});
        Ingredient regeneration = Ingredient.func_193367_a((Item)Items.field_151073_bk);
        Ingredient strength = Ingredient.func_193367_a((Item)Items.field_151065_br);
        Ingredient swiftness = Ingredient.func_193367_a((Item)Items.field_151102_aT);
        Ingredient leaping = Ingredient.func_193367_a((Item)Items.field_179556_br);
        Ingredient waterBreathing = waterBreathingAnyFish ? Ingredient.func_193367_a((Item)Items.field_151115_aP) : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151115_aP, ItemFishFood.FishType.PUFFERFISH.func_150976_a())});
        Ingredient healing = ItemMaterial.getIngredient(ItemMaterial.EnumMaterial.MYSTERY_GLAND);
        if (this.tryChangePotions) {
            PotionHelper.func_193355_a((ItemPotion)Items.field_151068_bn, (Item)BWMItems.CREEPER_OYSTER, (ItemPotion)Items.field_185155_bH);
            PotionHelper.func_193355_a((ItemPotion)Items.field_185155_bH, (Item)Items.field_185157_bK, (ItemPotion)Items.field_185156_bI);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)awkward, (PotionType)PotionTypes.field_185233_e);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)extender, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)strengthener, (PotionType)PotionTypes.field_185232_d);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)fireResistance, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)nightVision, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)poison, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)regeneration, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)strength, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)swiftness, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)leaping, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)waterBreathing, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)healing, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)inverter, (PotionType)PotionTypes.field_185231_c);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)fireResistance, (PotionType)PotionTypes.field_185241_m);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185241_m, (Ingredient)extender, (PotionType)PotionTypes.field_185242_n);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)nightVision, (PotionType)PotionTypes.field_185234_f);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185234_f, (Ingredient)extender, (PotionType)PotionTypes.field_185235_g);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)poison, (PotionType)PotionTypes.field_185254_z);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185254_z, (Ingredient)strengthener, (PotionType)PotionTypes.field_185219_B);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185254_z, (Ingredient)extender, (PotionType)PotionTypes.field_185218_A);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)regeneration, (PotionType)PotionTypes.field_185220_C);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185220_C, (Ingredient)extender, (PotionType)PotionTypes.field_185221_D);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185220_C, (Ingredient)strengthener, (PotionType)PotionTypes.field_185222_E);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)strength, (PotionType)PotionTypes.field_185223_F);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185223_F, (Ingredient)strengthener, (PotionType)PotionTypes.field_185225_H);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185223_F, (Ingredient)extender, (PotionType)PotionTypes.field_185224_G);
            if (!removeMovementPotions) {
                PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)swiftness, (PotionType)PotionTypes.field_185243_o);
                PotionHelper.func_193356_a((PotionType)PotionTypes.field_185243_o, (Ingredient)strengthener, (PotionType)PotionTypes.field_185245_q);
                PotionHelper.func_193356_a((PotionType)PotionTypes.field_185243_o, (Ingredient)extender, (PotionType)PotionTypes.field_185244_p);
                PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)leaping, (PotionType)PotionTypes.field_185238_j);
                PotionHelper.func_193356_a((PotionType)PotionTypes.field_185238_j, (Ingredient)extender, (PotionType)PotionTypes.field_185239_k);
                PotionHelper.func_193356_a((PotionType)PotionTypes.field_185238_j, (Ingredient)strengthener, (PotionType)PotionTypes.field_185240_l);
                PotionHelper.func_193356_a((PotionType)PotionTypes.field_185243_o, (Ingredient)inverter, (PotionType)PotionTypes.field_185246_r);
                PotionHelper.func_193356_a((PotionType)PotionTypes.field_185245_q, (Ingredient)inverter, (PotionType)PotionTypes.field_185246_r);
                PotionHelper.func_193356_a((PotionType)PotionTypes.field_185244_p, (Ingredient)inverter, (PotionType)PotionTypes.field_185247_s);
                PotionHelper.func_193356_a((PotionType)PotionTypes.field_185238_j, (Ingredient)inverter, (PotionType)PotionTypes.field_185246_r);
                PotionHelper.func_193356_a((PotionType)PotionTypes.field_185240_l, (Ingredient)inverter, (PotionType)PotionTypes.field_185246_r);
                PotionHelper.func_193356_a((PotionType)PotionTypes.field_185239_k, (Ingredient)inverter, (PotionType)PotionTypes.field_185247_s);
                PotionHelper.func_193356_a((PotionType)PotionTypes.field_185246_r, (Ingredient)extender, (PotionType)PotionTypes.field_185247_s);
            }
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)waterBreathing, (PotionType)PotionTypes.field_185248_t);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185248_t, (Ingredient)extender, (PotionType)PotionTypes.field_185249_u);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)healing, (PotionType)PotionTypes.field_185250_v);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185250_v, (Ingredient)strengthener, (PotionType)PotionTypes.field_185251_w);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185250_v, (Ingredient)inverter, (PotionType)PotionTypes.field_185252_x);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185251_w, (Ingredient)inverter, (PotionType)PotionTypes.field_185253_y);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185254_z, (Ingredient)inverter, (PotionType)PotionTypes.field_185252_x);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185218_A, (Ingredient)inverter, (PotionType)PotionTypes.field_185252_x);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185219_B, (Ingredient)inverter, (PotionType)PotionTypes.field_185253_y);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185252_x, (Ingredient)strengthener, (PotionType)PotionTypes.field_185253_y);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185223_F, (Ingredient)inverter, (PotionType)PotionTypes.field_185226_I);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185225_H, (Ingredient)inverter, (PotionType)PotionTypes.field_185226_I);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185224_G, (Ingredient)inverter, (PotionType)PotionTypes.field_185227_J);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185226_I, (Ingredient)extender, (PotionType)PotionTypes.field_185227_J);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185234_f, (Ingredient)inverter, (PotionType)PotionTypes.field_185236_h);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185235_g, (Ingredient)inverter, (PotionType)PotionTypes.field_185237_i);
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185236_h, (Ingredient)extender, (PotionType)PotionTypes.field_185237_i);
        }
        if (modPotionCompat) {
            ItemStack extenderToReplace = new ItemStack(Items.field_151137_ax);
            ItemStack strengthenerToReplace = new ItemStack(Items.field_151114_aO);
            ItemStack inverterToReplace = new ItemStack(Items.field_151071_bq);
            ItemStack splashToReplace = new ItemStack(Items.field_151016_H);
            for (Object moddedPotion : moddedPotions) {
                Ingredient reagent = MixPredicateHelper.getReagent(moddedPotion);
                PotionType input = MixPredicateHelper.getInputPotionType(moddedPotion);
                PotionType output = MixPredicateHelper.getOutputPotionType(moddedPotion);
                if (reagent.apply(extenderToReplace) && this.isExtended(input.func_185170_a(), output.func_185170_a())) {
                    MixPredicateHelper.setReagent(moddedPotion, extender);
                }
                if (reagent.apply(strengthenerToReplace) && this.isStrong(input.func_185170_a(), output.func_185170_a())) {
                    MixPredicateHelper.setReagent(moddedPotion, strengthener);
                }
                if (reagent.apply(inverterToReplace) && this.isInverted(input.func_185170_a(), output.func_185170_a())) {
                    MixPredicateHelper.setReagent(moddedPotion, inverter);
                }
                typeConversions.add(moddedPotion);
            }
            List recipes = (List)ReflectionHelper.getPrivateValue(BrewingRecipeRegistry.class, null, (String[])new String[]{"recipes"});
            ListIterator<BrewingRecipe> iterator = recipes.listIterator();
            while (iterator.hasNext()) {
                IBrewingRecipe recipe = (IBrewingRecipe)iterator.next();
                if (!(recipe instanceof AbstractBrewingRecipe)) continue;
                AbstractBrewingRecipe abstractRecipe = (AbstractBrewingRecipe)recipe;
                if (abstractRecipe.isIngredient(extenderToReplace) && this.isExtended(abstractRecipe.getInput(), abstractRecipe.getOutput())) {
                    iterator.remove();
                    iterator.add(new BrewingRecipe(abstractRecipe.getInput(), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.WITCH_WART), abstractRecipe.getOutput()));
                    continue;
                }
                if (abstractRecipe.isIngredient(strengthenerToReplace) && this.isStrong(abstractRecipe.getInput(), abstractRecipe.getOutput())) {
                    iterator.remove();
                    iterator.add(new BrewingRecipe(abstractRecipe.getInput(), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BRIMSTONE), abstractRecipe.getOutput()));
                    continue;
                }
                if (abstractRecipe.isIngredient(inverterToReplace) && this.isInverted(abstractRecipe.getInput(), abstractRecipe.getOutput())) {
                    iterator.remove();
                    iterator.add(new BrewingRecipe(abstractRecipe.getInput(), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.POISON_SAC), abstractRecipe.getOutput()));
                    continue;
                }
                if (!abstractRecipe.isIngredient(splashToReplace) || !this.isSplash(abstractRecipe.getInput(), abstractRecipe.getOutput())) continue;
                iterator.remove();
                iterator.add(new BrewingRecipe(abstractRecipe.getInput(), new ItemStack(BWMItems.CREEPER_OYSTER), abstractRecipe.getOutput()));
            }
        }
    }

    private boolean isModdedPotion(Object predicate) {
        ResourceLocation registryName = MixPredicateHelper.getOutputPotionType(predicate).getRegistryName();
        return registryName == null || !registryName.func_110624_b().toLowerCase().equals("minecraft") && !registryName.func_110624_b().toLowerCase().equals("betterwithmods");
    }

    public boolean isExtended(ItemStack potionA, ItemStack potionB) {
        List effectsA = PotionUtils.func_185189_a((ItemStack)potionA);
        List effectsB = PotionUtils.func_185189_a((ItemStack)potionB);
        return this.isExtended(effectsA, effectsB);
    }

    private boolean isExtended(List<PotionEffect> effectsA, List<PotionEffect> effectsB) {
        if (effectsA.size() != 1 || effectsB.size() != 1) {
            return false;
        }
        PotionEffect effectA = effectsA.get(0);
        PotionEffect effectB = effectsB.get(0);
        return this.isExtended(effectA, effectB);
    }

    private boolean isExtended(PotionEffect effectA, PotionEffect effectB) {
        return effectA.func_188419_a().equals(effectB.func_188419_a()) && effectA.func_76459_b() != effectB.func_76459_b();
    }

    public boolean isStrong(ItemStack potionA, ItemStack potionB) {
        List effectsA = PotionUtils.func_185189_a((ItemStack)potionA);
        List effectsB = PotionUtils.func_185189_a((ItemStack)potionB);
        return this.isStrong(effectsA, effectsB);
    }

    private boolean isStrong(List<PotionEffect> effectsA, List<PotionEffect> effectsB) {
        if (effectsA.size() != 1 || effectsB.size() != 1) {
            return false;
        }
        PotionEffect effectA = effectsA.get(0);
        PotionEffect effectB = effectsB.get(0);
        return this.isStrong(effectA, effectB);
    }

    private boolean isStrong(PotionEffect effectA, PotionEffect effectB) {
        return effectA.func_188419_a().equals(effectB.func_188419_a()) && effectA.func_76458_c() < effectB.func_76458_c();
    }

    public boolean isInverted(ItemStack potionA, ItemStack potionB) {
        List effectsA = PotionUtils.func_185189_a((ItemStack)potionA);
        List effectsB = PotionUtils.func_185189_a((ItemStack)potionB);
        return this.isInverted(effectsA, effectsB);
    }

    private boolean isInverted(List<PotionEffect> effectsA, List<PotionEffect> effectsB) {
        if (effectsA.size() != 1 || effectsB.size() != 1) {
            return false;
        }
        PotionEffect effectA = effectsA.get(0);
        PotionEffect effectB = effectsB.get(0);
        return this.isInverted(effectA, effectB);
    }

    private boolean isInverted(PotionEffect effectA, PotionEffect effectB) {
        return !effectA.func_188419_a().equals(effectB.func_188419_a());
    }

    public boolean isSplash(ItemStack potionA, ItemStack potionB) {
        List effectsA = PotionUtils.func_185189_a((ItemStack)potionA);
        List effectsB = PotionUtils.func_185189_a((ItemStack)potionB);
        if (effectsA.size() != 1 || effectsB.size() != 1) {
            return false;
        }
        PotionEffect effectA = (PotionEffect)effectsA.get(0);
        PotionEffect effectB = (PotionEffect)effectsB.get(0);
        return effectA.func_188419_a().equals(effectB.func_188419_a()) && potionB.func_77973_b() instanceof ItemSplashPotion;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

