/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay.breeding_harness;

import betterwithmods.client.model.render.RenderUtils;
import betterwithmods.common.BWMItems;
import betterwithmods.common.items.ItemBreedingHarness;
import betterwithmods.module.Feature;
import betterwithmods.module.gameplay.breeding_harness.CapabilityHarness;
import betterwithmods.module.gameplay.breeding_harness.LayerHarness;
import betterwithmods.module.gameplay.breeding_harness.models.ModelCowHarness;
import betterwithmods.module.gameplay.breeding_harness.models.ModelSheepHarness;
import betterwithmods.network.BWNetwork;
import betterwithmods.network.messages.MessageHarness;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Set;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelPig;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class BreedingHarness
extends Feature {
    private static final ResourceLocation CAPABILITY = new ResourceLocation("betterwithmods", "harness");
    public static final Set<Class<? extends EntityAnimal>> HARNESS_ANIMALS = Sets.newHashSet();
    private static Object2BooleanMap<Class<? extends Entity>> HARNESS_CACHE = new Object2BooleanOpenHashMap();

    @Override
    public String getFeatureDescription() {
        return "Add the Breeding Harness, which can be put on most domesticated animals and making their legs immobile, they are still able to eat food and breed while restrained.";
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        BWMItems.registerItem(BWMItems.BREEDING_HARNESS);
        CapabilityManager.INSTANCE.register(CapabilityHarness.class, (Capability.IStorage)new CapabilityHarness.Storage(), CapabilityHarness::new);
    }

    @SideOnly(value=Side.CLIENT)
    private static <T extends EntityLiving> void addLayer(Class<T> entity, ModelBase model, ResourceLocation texture) {
        RenderLiving<T> render = RenderUtils.getRender(entity);
        LayerHarness<T> layer = new LayerHarness<T>(model, render, texture);
        render.func_177094_a(layer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postInitClient(FMLPostInitializationEvent event) {
        BreedingHarness.addLayer(EntityCow.class, (ModelBase)new ModelCowHarness(0.5f), new ResourceLocation("betterwithmods", "textures/entity/cow_harness.png"));
        BreedingHarness.addLayer(EntityPig.class, (ModelBase)new ModelPig(0.5f), new ResourceLocation("betterwithmods", "textures/entity/pig_harness.png"));
        BreedingHarness.addLayer(EntitySheep.class, (ModelBase)new ModelSheepHarness(0.5f), new ResourceLocation("betterwithmods", "textures/entity/sheep_harness.png"));
    }

    private static void sendPacket(Entity entity) {
        CapabilityHarness cap = BreedingHarness.getCapability(entity);
        if (cap != null) {
            BWNetwork.sendToAllAround(new MessageHarness(entity.func_145782_y(), cap.getHarness()), entity.func_130014_f_(), entity.func_180425_c());
        }
    }

    @SubscribeEvent
    public void onAttach(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (BreedingHarness.harnessEntity(entity)) {
            event.addCapability(CAPABILITY, (ICapabilityProvider)new CapabilityHarness());
        }
    }

    @SubscribeEvent
    public void onTrack(PlayerEvent.StartTracking event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        Entity entity = event.getTarget();
        BreedingHarness.sendPacket(entity);
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getTarget();
        CapabilityHarness cap = BreedingHarness.getCapability(entity);
        if (cap != null) {
            ItemStack hand = event.getItemStack();
            ItemStack harness = cap.getHarness();
            if (harness.func_190926_b() && !event.getEntityPlayer().func_70093_af()) {
                if (hand.func_77973_b() instanceof ItemBreedingHarness) {
                    cap.setHarness(InvUtils.setCount(hand.func_77946_l(), 1));
                    if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                        hand.func_190918_g(1);
                    }
                    event.getWorld().func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187728_s, SoundCategory.NEUTRAL, 0.5f, 1.3f);
                    event.getWorld().func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187713_n, SoundCategory.NEUTRAL, 0.5f, 1.3f);
                    event.getEntityPlayer().func_184609_a(EnumHand.MAIN_HAND);
                    if (entity instanceof EntitySheep) {
                        ((EntitySheep)entity).func_70893_e(true);
                    }
                    BreedingHarness.sendPacket(entity);
                }
            } else if (!harness.func_190926_b() && event.getEntityPlayer().func_70093_af() && hand.func_190926_b()) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.getEntityPlayer(), (ItemStack)harness.func_77946_l());
                harness.func_190918_g(1);
                event.getWorld().func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187728_s, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                event.getWorld().func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187713_n, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                event.getEntityPlayer().func_184609_a(EnumHand.MAIN_HAND);
                BreedingHarness.sendPacket(entity);
            }
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent e) {
        EntityLivingBase entity = e.getEntityLiving();
        if (BreedingHarness.harnessEntity((Entity)entity)) {
            if (BreedingHarness.hasHarness((Entity)entity)) {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(-1.0);
                if (entity instanceof EntitySheep && !((EntitySheep)entity).func_70892_o()) {
                    ((EntitySheep)entity).func_70893_e(true);
                }
            } else {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
            }
        }
    }

    public static CapabilityHarness getCapability(Entity entity) {
        return (CapabilityHarness)entity.getCapability(CapabilityHarness.HARNESS_CAPABILITY, null);
    }

    public static boolean hasHarness(Entity entity) {
        CapabilityHarness cap = BreedingHarness.getCapability(entity);
        return cap != null && cap.getHarness().func_77973_b() instanceof ItemBreedingHarness;
    }

    public static boolean harnessEntity(Entity entity) {
        if (!(entity instanceof EntityAnimal)) {
            return false;
        }
        Class<?> c = entity.getClass();
        Boolean harness = (Boolean)HARNESS_CACHE.get(c);
        if (harness != null) {
            return harness;
        }
        boolean canHarness = false;
        for (Class<? extends EntityAnimal> cTest : HARNESS_ANIMALS) {
            if (!cTest.isAssignableFrom(c)) continue;
            canHarness = true;
            break;
        }
        return HARNESS_CACHE.put(c, canHarness);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        HARNESS_ANIMALS.add(EntityCow.class);
        HARNESS_ANIMALS.add(EntitySheep.class);
        HARNESS_ANIMALS.add(EntityPig.class);
        for (Class<? extends EntityAnimal> c : HARNESS_ANIMALS) {
            HARNESS_CACHE.put(c, true);
        }
    }
}

