/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.trait;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import logictechcorp.libraryex.LibraryEx;
import logictechcorp.libraryex.api.world.generation.trait.IBiomeTrait;
import logictechcorp.libraryex.api.world.generation.trait.IBiomeTraitBuilder;
import logictechcorp.libraryex.api.world.generation.trait.IBiomeTraitRegistry;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitBasicTree;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitBigMushroom;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitBoulder;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitCluster;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitDenseTree;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitFluid;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitOre;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitPatch;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitPool;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitScatter;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitSparseTree;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitStructure;
import net.minecraft.util.ResourceLocation;

public final class BiomeTraitRegistry
implements IBiomeTraitRegistry {
    public static final IBiomeTraitRegistry INSTANCE = new BiomeTraitRegistry();
    private final Map<Class<? extends IBiomeTrait>, ResourceLocation> biomeTraitNames = new HashMap<Class<? extends IBiomeTrait>, ResourceLocation>();
    private final Map<ResourceLocation, IBiomeTraitBuilder> biomeTraitBuilders = new HashMap<ResourceLocation, IBiomeTraitBuilder>();

    private BiomeTraitRegistry() {
        this.registerBiomeTrait(LibraryEx.getResource("scatter"), new BiomeTraitScatter.Builder(), BiomeTraitScatter.class);
        this.registerBiomeTrait(LibraryEx.getResource("cluster"), new BiomeTraitCluster.Builder(), BiomeTraitCluster.class);
        this.registerBiomeTrait(LibraryEx.getResource("patch"), new BiomeTraitPatch.Builder(), BiomeTraitPatch.class);
        this.registerBiomeTrait(LibraryEx.getResource("boulder"), new BiomeTraitBoulder.Builder(), BiomeTraitBoulder.class);
        this.registerBiomeTrait(LibraryEx.getResource("ore"), new BiomeTraitOre.Builder(), BiomeTraitOre.class);
        this.registerBiomeTrait(LibraryEx.getResource("fluid"), new BiomeTraitFluid.Builder(), BiomeTraitFluid.class);
        this.registerBiomeTrait(LibraryEx.getResource("pool"), new BiomeTraitPool.Builder(), BiomeTraitPool.class);
        this.registerBiomeTrait(LibraryEx.getResource("basic_tree"), new BiomeTraitBasicTree.Builder(), BiomeTraitBasicTree.class);
        this.registerBiomeTrait(LibraryEx.getResource("dense_tree"), new BiomeTraitDenseTree.Builder(), BiomeTraitDenseTree.class);
        this.registerBiomeTrait(LibraryEx.getResource("sparse_tree"), new BiomeTraitSparseTree.Builder(), BiomeTraitSparseTree.class);
        this.registerBiomeTrait(LibraryEx.getResource("big_mushroom"), new BiomeTraitBigMushroom.Builder(), BiomeTraitBigMushroom.class);
        this.registerBiomeTrait(LibraryEx.getResource("structure"), new BiomeTraitStructure.Builder(), BiomeTraitStructure.class);
    }

    @Override
    public void registerBiomeTrait(ResourceLocation registryName, IBiomeTraitBuilder biomeTraitBuilder, Class<? extends IBiomeTrait> cls) {
        if (registryName == null || biomeTraitBuilder == null || cls == null) {
            return;
        }
        if (!this.biomeTraitNames.containsKey(cls)) {
            this.biomeTraitNames.put(cls, registryName);
        }
        if (!this.biomeTraitBuilders.containsKey(registryName)) {
            this.biomeTraitBuilders.put(registryName, biomeTraitBuilder);
        }
    }

    @Override
    public void unregisterBiomeTrait(ResourceLocation registryName) {
        this.biomeTraitBuilders.remove(registryName);
    }

    @Override
    public boolean hasBiomeTrait(ResourceLocation registryName) {
        return this.biomeTraitBuilders.containsKey(registryName);
    }

    @Override
    public ResourceLocation getBiomeTraitName(Class<? extends IBiomeTrait> cls) {
        return this.biomeTraitNames.get(cls);
    }

    @Override
    public IBiomeTraitBuilder getBiomeTraitBuilder(ResourceLocation registryName) {
        return this.biomeTraitBuilders.get(registryName);
    }

    @Override
    public Map<Class<? extends IBiomeTrait>, ResourceLocation> getBiomeTraitNames() {
        return Collections.unmodifiableMap(this.biomeTraitNames);
    }

    @Override
    public Map<ResourceLocation, IBiomeTraitBuilder> getBiomeTraitBuilders() {
        return Collections.unmodifiableMap(this.biomeTraitBuilders);
    }
}

