/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.trait;

import com.electronwill.nightconfig.core.Config;
import java.util.Random;
import java.util.function.Consumer;
import logictechcorp.libraryex.utility.ConfigHelper;
import logictechcorp.libraryex.world.generation.trait.BiomeTrait;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BiomeTraitBigMushroom
extends BiomeTrait {
    protected IBlockState mushroomCap;
    protected IBlockState mushroomStem;
    protected IBlockState blockToPlaceOn;
    protected Shape shape;

    protected BiomeTraitBigMushroom(Builder builder) {
        super(builder);
        this.mushroomCap = builder.mushroomCap;
        this.mushroomStem = builder.mushroomStem;
        this.blockToPlaceOn = builder.blockToPlaceOn;
        this.shape = builder.shape;
    }

    public static BiomeTraitBigMushroom create(Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        return builder.create();
    }

    @Override
    public void readFromConfig(Config config) {
        super.readFromConfig(config);
        this.mushroomCap = ConfigHelper.getBlockState(config, "mushroomCap");
        this.mushroomStem = ConfigHelper.getBlockState(config, "mushroomStem");
        this.blockToPlaceOn = ConfigHelper.getBlockState(config, "blockToPlaceOn");
        this.shape = (Shape)config.getEnumOrElse("shape", (Enum)Shape.BULB);
    }

    @Override
    public void writeToConfig(Config config) {
        super.writeToConfig(config);
        config.add("shape", this.shape == null ? null : this.shape.toString().toLowerCase());
        ConfigHelper.setBlockState(config, "blockToPlaceOn", this.blockToPlaceOn);
        ConfigHelper.setBlockState(config, "mushroomStem", this.mushroomStem);
        ConfigHelper.setBlockState(config, "mushroomCap", this.mushroomCap);
    }

    @Override
    public boolean generate(World world, BlockPos pos, Random random) {
        if (this.mushroomCap == null || this.mushroomStem == null || this.blockToPlaceOn == null || this.shape == null) {
            return false;
        }
        int stemHeight = random.nextInt(3) + 4;
        if (random.nextInt(12) == 0) {
            stemHeight *= 2;
        }
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + stemHeight + 1 < 256) {
            for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 1 + stemHeight; ++y) {
                int k = 3;
                if (y <= pos.func_177956_o() + 3) {
                    k = 0;
                }
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (int x = pos.func_177958_n() - k; x <= pos.func_177958_n() + k && flag; ++x) {
                    for (int z = pos.func_177952_p() - k; z <= pos.func_177952_p() + k && flag; ++z) {
                        if (y >= 0 && y < 256) {
                            IBlockState state = world.func_180495_p((BlockPos)mutablePos.func_181079_c(x, y, z));
                            if (state.func_177230_c().isAir(state, (IBlockAccess)world, (BlockPos)mutablePos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, (BlockPos)mutablePos)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (world.func_180495_p(pos.func_177977_b()) != this.blockToPlaceOn) {
                return false;
            }
            int k2 = pos.func_177956_o() + stemHeight;
            if (this.shape == Shape.BULB) {
                k2 = pos.func_177956_o() + stemHeight - 3;
            }
            for (int l2 = k2; l2 <= pos.func_177956_o() + stemHeight; ++l2) {
                int j3 = 1;
                if (l2 < pos.func_177956_o() + stemHeight) {
                    ++j3;
                }
                if (this.shape == Shape.FLAT) {
                    j3 = 3;
                }
                int k3 = pos.func_177958_n() - j3;
                int l3 = pos.func_177958_n() + j3;
                int j1 = pos.func_177952_p() - j3;
                int k1 = pos.func_177952_p() + j3;
                for (int l1 = k3; l1 <= l3; ++l1) {
                    for (int i2 = j1; i2 <= k1; ++i2) {
                        BlockPos blockpos;
                        IBlockState state;
                        int j2 = 5;
                        if (l1 == k3) {
                            --j2;
                        } else if (l1 == l3) {
                            ++j2;
                        }
                        if (i2 == j1) {
                            j2 -= 3;
                        } else if (i2 == k1) {
                            j2 += 3;
                        }
                        BlockHugeMushroom.EnumType mushroomType = BlockHugeMushroom.EnumType.func_176895_a((int)j2);
                        if (this.shape == Shape.FLAT || l2 < pos.func_177956_o() + stemHeight) {
                            if ((l1 == k3 || l1 == l3) && (i2 == j1 || i2 == k1)) continue;
                            if (l1 == pos.func_177958_n() - (j3 - 1) && i2 == j1) {
                                mushroomType = BlockHugeMushroom.EnumType.NORTH_WEST;
                            }
                            if (l1 == k3 && i2 == pos.func_177952_p() - (j3 - 1)) {
                                mushroomType = BlockHugeMushroom.EnumType.NORTH_WEST;
                            }
                            if (l1 == pos.func_177958_n() + (j3 - 1) && i2 == j1) {
                                mushroomType = BlockHugeMushroom.EnumType.NORTH_EAST;
                            }
                            if (l1 == l3 && i2 == pos.func_177952_p() - (j3 - 1)) {
                                mushroomType = BlockHugeMushroom.EnumType.NORTH_EAST;
                            }
                            if (l1 == pos.func_177958_n() - (j3 - 1) && i2 == k1) {
                                mushroomType = BlockHugeMushroom.EnumType.SOUTH_WEST;
                            }
                            if (l1 == k3 && i2 == pos.func_177952_p() + (j3 - 1)) {
                                mushroomType = BlockHugeMushroom.EnumType.SOUTH_WEST;
                            }
                            if (l1 == pos.func_177958_n() + (j3 - 1) && i2 == k1) {
                                mushroomType = BlockHugeMushroom.EnumType.SOUTH_EAST;
                            }
                            if (l1 == l3 && i2 == pos.func_177952_p() + (j3 - 1)) {
                                mushroomType = BlockHugeMushroom.EnumType.SOUTH_EAST;
                            }
                        }
                        if (mushroomType == BlockHugeMushroom.EnumType.CENTER && l2 < pos.func_177956_o() + stemHeight) {
                            mushroomType = BlockHugeMushroom.EnumType.ALL_INSIDE;
                        }
                        if (pos.func_177956_o() < pos.func_177956_o() + stemHeight - 1 && mushroomType == BlockHugeMushroom.EnumType.ALL_INSIDE || !(state = world.func_180495_p(blockpos = new BlockPos(l1, l2, i2))).func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, blockpos)) continue;
                        world.func_175656_a(blockpos, this.mushroomCap);
                    }
                }
            }
            for (int i3 = 0; i3 < stemHeight; ++i3) {
                IBlockState iblockstate = world.func_180495_p(pos.func_177981_b(i3));
                if (!iblockstate.func_177230_c().canBeReplacedByLeaves(iblockstate, (IBlockAccess)world, pos.func_177981_b(i3))) continue;
                world.func_175656_a(pos.func_177981_b(i3), this.mushroomStem);
            }
            return true;
        }
        return false;
    }

    public static enum Shape {
        FLAT,
        BULB;

    }

    public static class Builder
    extends BiomeTrait.Builder {
        private IBlockState mushroomCap = Blocks.field_150420_aW.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.ALL_OUTSIDE);
        private IBlockState mushroomStem = Blocks.field_150420_aW.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM);
        private IBlockState blockToPlaceOn = Blocks.field_150349_c.func_176223_P();
        private Shape shape = Shape.FLAT;

        public Builder mushroomCap(IBlockState mushroomCap) {
            this.mushroomCap = mushroomCap;
            return this;
        }

        public Builder mushroomStem(IBlockState mushroomStem) {
            this.mushroomStem = mushroomStem;
            return this;
        }

        public Builder blockToPlaceOn(IBlockState blockToPlaceOn) {
            this.blockToPlaceOn = blockToPlaceOn;
            return this;
        }

        public Builder shape(Shape shape) {
            this.shape = shape;
            return this;
        }

        @Override
        public BiomeTraitBigMushroom create() {
            return new BiomeTraitBigMushroom(this);
        }
    }
}

