/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.tileentity.carthopperbehaviour;

import com.minemaarten.signals.api.ICartHopperBehaviour;
import com.minemaarten.signals.api.Signals;
import com.minemaarten.signals.capabilities.CapabilityDestinationProvider;
import com.minemaarten.signals.capabilities.destinationproviders.DestinationProviderItems;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

@Signals
public class CartHopperBehaviourItems
implements ICartHopperBehaviour<IItemHandler> {
    @CapabilityInject(value=IItemHandler.class)
    private static final Capability<IItemHandler> ITEM_CAP = null;
    private static final int MAX_TRANSFER_RATE = 8;

    @Override
    public Capability<IItemHandler> getCapability() {
        return ITEM_CAP;
    }

    @Override
    public boolean tryTransfer(IItemHandler from, IItemHandler to, List<Pair<TileEntity, EnumFacing>> filters) {
        int totalExtracted = 0;
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack extracted = from.extractItem(i, 8 - totalExtracted, true);
            if (extracted.func_190926_b() || !CartHopperBehaviourItems.passesFilters(extracted, filters)) continue;
            ItemStack leftover = ItemHandlerHelper.insertItemStacked((IItemHandler)to, (ItemStack)extracted, (boolean)false);
            int leftoverCount = !leftover.func_190926_b() ? leftover.func_190916_E() : 0;
            int actuallyExtracted = extracted.func_190916_E() - leftoverCount;
            if (actuallyExtracted <= 0) continue;
            from.extractItem(i, actuallyExtracted, false);
            if ((totalExtracted += actuallyExtracted) >= 8) break;
        }
        return totalExtracted > 0;
    }

    @Override
    public boolean isCartFull(IItemHandler capability) {
        for (int i = 0; i < capability.getSlots(); ++i) {
            if (!capability.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCartEmpty(IItemHandler capability, List<Pair<TileEntity, EnumFacing>> filters) {
        for (int i = 0; i < capability.getSlots(); ++i) {
            ItemStack stack = capability.getStackInSlot(i);
            if (stack.func_190926_b() || !CartHopperBehaviourItems.passesFilters(stack, filters)) continue;
            return false;
        }
        return true;
    }

    private static boolean passesFilters(ItemStack stack, List<Pair<TileEntity, EnumFacing>> filters) {
        boolean allInventoriesEmpty = true;
        block0: for (Pair<TileEntity, EnumFacing> filter : filters) {
            CapabilityDestinationProvider cap;
            DestinationProviderItems itemProvider;
            if (!((TileEntity)filter.getLeft()).hasCapability(CapabilityDestinationProvider.INSTANCE, null) || (itemProvider = (cap = (CapabilityDestinationProvider)((TileEntity)filter.getLeft()).getCapability(CapabilityDestinationProvider.INSTANCE, null)).getProvider(DestinationProviderItems.class)) == null) continue;
            IInventory inv = (IInventory)filter.getLeft();
            if (itemProvider.isStackApplicable(stack, inv)) {
                return true;
            }
            if (!allInventoriesEmpty) continue;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i).func_190926_b()) continue;
                allInventoriesEmpty = false;
                continue block0;
            }
        }
        return allInventoriesEmpty;
    }

    @Override
    public int getComparatorInputOverride(IItemHandler capability) {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)capability);
    }
}

