/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.tileentity;

import com.minemaarten.signals.api.access.IStationMarker;
import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.network.GuiSynced;
import com.minemaarten.signals.rail.network.INetworkObject;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.PosAABB;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.MCTrain;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import com.minemaarten.signals.tileentity.IGUITextFieldSensitive;
import com.minemaarten.signals.tileentity.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import org.apache.commons.lang3.Validate;

public class TileEntityStationMarker
extends TileEntityBase
implements ITickable,
IGUITextFieldSensitive,
IStationMarker {
    private static int nextId;
    @GuiSynced
    private String stationName = "Station" + nextId++;
    private PosAABB<MCPos> neighborAABB;

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("stationName", this.stationName);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stationName = compound.func_74779_i("stationName");
    }

    @Override
    public String getStationName() {
        return this.stationName;
    }

    @Override
    public void setStationName(String stationName) {
        Validate.notNull((Object)stationName);
        this.stationName = stationName;
        if (!this.field_145850_b.field_72995_K) {
            RailNetworkManager.getInstance(this.field_145850_b.field_72995_K).markDirty(this.getMCPos());
            this.func_70296_d();
            this.sendUpdatePacket();
        }
    }

    public List<MCPos> getNeighborRails() {
        ArrayList<MCPos> neighbors = new ArrayList<MCPos>(1);
        for (EnumFacing d : EnumFacing.field_82609_l) {
            MCPos neighborPos = this.getMCPos().offset(d);
            INetworkObject<MCPos> rail = RailNetworkManager.getInstance((boolean)this.field_145850_b.field_72995_K).getNetwork().railObjects.get(neighborPos);
            if (!(rail instanceof NetworkRail)) continue;
            neighbors.add(rail.getPos());
        }
        return neighbors;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateNeighborMinecarts();
        }
    }

    public void updateNeighborMinecarts() {
        if (this.neighborAABB == null) {
            this.neighborAABB = new PosAABB<MCPos>(this.getNeighborRails());
        }
        RailNetworkManager.getInstance(this.field_145850_b.field_72995_K).getAllTrains().forEach(this::updateNeighborMinecarts);
    }

    private void updateNeighborMinecarts(MCTrain train) {
        if (train.isInAABB(this.neighborAABB)) {
            for (EntityMinecart cart : train.getCarts()) {
                CapabilityMinecartDestination cap = (CapabilityMinecartDestination)cart.getCapability(CapabilityMinecartDestination.INSTANCE, null);
                if (cap.getDestinationIndex() < 0) continue;
                Pattern destinationRegex = cap.getCurrentDestinationRegex();
                Set<MCPos> stations = RailNetworkManager.getInstance(this.field_145850_b.field_72995_K).getNetwork().getStations(train, destinationRegex);
                if (!stations.contains(this.getMCPos())) continue;
                cap.nextDestination();
            }
        }
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.setStationName(text);
    }

    @Override
    public String getText(int textFieldID) {
        return this.getStationName();
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74778_a("stationName", this.stationName);
        return tag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.stationName = pkt.func_148857_g().func_74779_i("stationName");
    }
}

