/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.tileentity;

import com.minemaarten.signals.api.access.ISignal;
import com.minemaarten.signals.block.BlockSignalBase;
import com.minemaarten.signals.rail.network.INetworkObject;
import com.minemaarten.signals.rail.network.NetworkSignal;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import com.minemaarten.signals.tileentity.TileEntityBase;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class TileEntitySignalBase
extends TileEntityBase
implements ITickable,
ISignal {
    private boolean firstTick = true;
    private ISignal.EnumForceMode forceMode = ISignal.EnumForceMode.NONE;
    private String text = "";
    private String arguments = "";

    public EnumFacing getFacing() {
        IBlockState state = this.getBlockState();
        return state != null && state.func_177230_c() instanceof BlockSignalBase ? (EnumFacing)state.func_177229_b(BlockSignalBase.FACING) : EnumFacing.NORTH;
    }

    public abstract NetworkSignal.EnumSignalType getSignalType();

    public void setLampStatus(ISignal.EnumLampStatus lampStatus) {
        IBlockState state = this.getBlockState();
        if (state.func_177227_a().contains(BlockSignalBase.LAMP_STATUS) && state.func_177229_b(BlockSignalBase.LAMP_STATUS) != lampStatus) {
            this.func_145831_w().func_175656_a(this.func_174877_v(), state.func_177226_a(BlockSignalBase.LAMP_STATUS, (Comparable)((Object)lampStatus)));
            if (lampStatus == ISignal.EnumLampStatus.GREEN) {
                List<EntityMinecart> neighborMinecarts = this.getNeighborMinecarts();
                for (EntityMinecart cart : neighborMinecarts) {
                    if (new Vec3d(cart.field_70159_w, cart.field_70181_x, cart.field_70179_y).func_72433_c() < 0.01 || EnumFacing.func_176737_a((float)((float)cart.field_70159_w), (float)0.0f, (float)((float)cart.field_70179_y)) == this.getFacing()) {
                        cart.field_70159_w += (double)this.getFacing().func_82601_c() * 0.1;
                        cart.field_70179_y += (double)this.getFacing().func_82599_e() * 0.1;
                        continue;
                    }
                    if (EnumFacing.func_176737_a((float)((float)cart.field_70159_w), (float)0.0f, (float)((float)cart.field_70179_y)) != this.getFacing().func_176734_d()) continue;
                    cart.field_70159_w *= -1.0;
                    cart.field_70181_x *= -1.0;
                    cart.field_70179_y *= -1.0;
                }
            }
        }
    }

    @Override
    public ISignal.EnumLampStatus getLampStatus() {
        IBlockState state;
        if (this.func_145831_w() != null && (state = this.func_145831_w().func_180495_p(this.func_174877_v())).func_177227_a().contains(BlockSignalBase.LAMP_STATUS)) {
            return (ISignal.EnumLampStatus)((Object)state.func_177229_b(BlockSignalBase.LAMP_STATUS));
        }
        return ISignal.EnumLampStatus.YELLOW_BLINKING;
    }

    private NetworkSignal<MCPos> getSignal() {
        INetworkObject<MCPos> obj = RailNetworkManager.getInstance((boolean)this.field_145850_b.field_72995_K).getNetwork().railObjects.get(this.getMCPos());
        return obj instanceof NetworkSignal ? (NetworkSignal)obj : null;
    }

    protected List<EntityMinecart> getNeighborMinecarts() {
        NetworkSignal<MCPos> signal = this.getSignal();
        if (signal == null) {
            return Collections.emptyList();
        }
        return TileEntitySignalBase.getNeighborMinecarts(RailNetworkManager.getInstance(this.field_145850_b.field_72995_K).getNetwork().getPositionsInFront(signal).stream());
    }

    public static List<EntityMinecart> getNeighborMinecarts(Stream<MCPos> positions) {
        return positions.flatMap(TileEntitySignalBase::getCartsAt).collect(Collectors.toList());
    }

    private static Stream<EntityMinecart> getCartsAt(MCPos pos) {
        World world = pos.getWorld();
        return world == null ? Stream.empty() : world.func_72872_a(EntityMinecart.class, new AxisAlignedBB(pos.getPos())).stream();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.firstTick) {
            this.firstTick = false;
            this.setLampStatus(RailNetworkManager.getInstance(this.field_145850_b.field_72995_K).getLampStatus(this.field_145850_b, this.field_174879_c));
            this.setForceMode(RailNetworkManager.getInstance(this.field_145850_b.field_72995_K).getState().getForceMode(this.getMCPos()));
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
    }

    protected void setMessage(String message, Object ... arguments) {
        this.text = message;
        this.arguments = "";
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                this.arguments = this.arguments + "\n";
            }
            this.arguments = this.arguments + arguments[i].toString();
        }
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.getBlockState(), this.getBlockState(), 3);
    }

    public String getMessage() {
        String[] localizedArguments = this.arguments.split("\n");
        for (int i = 0; i < localizedArguments.length; ++i) {
            localizedArguments[i] = I18n.func_135052_a((String)localizedArguments[i], (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)this.text, (Object[])localizedArguments);
    }

    @Override
    public void setForceMode(ISignal.EnumForceMode forceMode) {
        this.forceMode = forceMode;
        this.func_70296_d();
        if (forceMode == ISignal.EnumForceMode.FORCED_GREEN_ONCE) {
            this.setMessage("signals.signal_message.forced_green", new Object[0]);
        } else if (forceMode == ISignal.EnumForceMode.FORCED_RED) {
            this.setMessage("signals.signal_message.forced_red", new Object[0]);
        } else {
            this.setMessage("", new Object[0]);
        }
    }

    @Override
    public ISignal.EnumForceMode getForceMode() {
        return this.forceMode;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("text", this.text);
        tag.func_74778_a("arguments", this.arguments);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (pkt.func_148853_f() == 0) {
            this.text = pkt.func_148857_g().func_74779_i("text");
            this.arguments = pkt.func_148857_g().func_74779_i("arguments");
        }
    }
}

