/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.tileentity;

import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.tileentity.TileEntityBase;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public abstract class TileEntityRailLinkBase
extends TileEntityBase {
    private MCPos linkedPos;

    public MCPos getLinkedPosition() {
        return this.linkedPos;
    }

    public boolean setLinkedPos(MCPos railPos, EntityPlayer player) {
        if (!Objects.equals(railPos, this.linkedPos)) {
            if (this.isDestinationValid(railPos, player)) {
                this.linkedPos = railPos;
                this.onDestinationChanged(railPos);
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean isDestinationValid(MCPos destination, EntityPlayer player) {
        return true;
    }

    protected void onDestinationChanged(MCPos destination) {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        if (this.linkedPos != null) {
            tag.func_74768_a("linkedX", this.linkedPos.getX());
            tag.func_74768_a("linkedY", this.linkedPos.getY());
            tag.func_74768_a("linkedZ", this.linkedPos.getZ());
            tag.func_74768_a("linkedDim", this.linkedPos.getDimID());
        }
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        if (tag.func_74764_b("linkedX")) {
            BlockPos p = new BlockPos(tag.func_74762_e("linkedX"), tag.func_74762_e("linkedY"), tag.func_74762_e("linkedZ"));
            this.linkedPos = new MCPos(tag.func_74762_e("linkedDim"), p);
        } else {
            this.linkedPos = null;
        }
        super.func_145839_a(tag);
    }
}

