/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network.mc;

import com.minemaarten.signals.api.IRail;
import com.minemaarten.signals.init.ModBlocks;
import com.minemaarten.signals.lib.HeadingUtils;
import com.minemaarten.signals.rail.RailManager;
import com.minemaarten.signals.rail.network.INetworkObjectProvider;
import com.minemaarten.signals.rail.network.NetworkObject;
import com.minemaarten.signals.rail.network.mc.MCNetworkRail;
import com.minemaarten.signals.rail.network.mc.MCNetworkRailLink;
import com.minemaarten.signals.rail.network.mc.MCNetworkSignal;
import com.minemaarten.signals.rail.network.mc.MCNetworkStation;
import com.minemaarten.signals.rail.network.mc.MCNetworkTeleportRail;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.MCTrain;
import com.minemaarten.signals.rail.network.mc.NetworkRemovalMarker;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import com.minemaarten.signals.tileentity.TileEntityRailLink;
import com.minemaarten.signals.tileentity.TileEntitySignalBase;
import com.minemaarten.signals.tileentity.TileEntityStationMarker;
import com.minemaarten.signals.tileentity.TileEntityTeleportRail;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NetworkObjectProvider
implements INetworkObjectProvider<MCPos> {
    @Override
    public NetworkObject<MCPos> provide(MCPos pos) {
        World world = pos.getWorld();
        return world == null ? null : this.provide(world, pos.getPos());
    }

    public NetworkObject<MCPos> provide(World world, BlockPos pos) {
        TileEntityRailLink railLink;
        MCPos linkedPos;
        MCPos mcPos = new MCPos(world.field_73011_w.getDimension(), pos);
        if (!world.func_190526_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
            return null;
        }
        IBlockState state = world.func_180495_p(pos);
        IRail rail = RailManager.getInstance().getRail(world, pos, state);
        if (rail != null) {
            TileEntityTeleportRail teleportRail;
            MCPos linkedPos2;
            if (state.func_177230_c() == ModBlocks.TELEPORT_RAIL && (linkedPos2 = (teleportRail = (TileEntityTeleportRail)world.func_175625_s(pos)).getLinkedPosition()) != null) {
                return new MCNetworkTeleportRail(mcPos, state.func_177230_c(), rail.getDirection(world, pos, state), rail.getValidDirections(world, pos, state), linkedPos2);
            }
            return new MCNetworkRail(mcPos, state.func_177230_c(), rail.getDirection(world, pos, state), rail.getValidDirections(world, pos, state));
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityRailLink && (linkedPos = (railLink = (TileEntityRailLink)te).getLinkedPosition()) != null) {
            return new MCNetworkRailLink(mcPos, linkedPos, railLink.getHoldDelay());
        }
        if (te instanceof TileEntitySignalBase) {
            TileEntitySignalBase signal = (TileEntitySignalBase)te;
            return new MCNetworkSignal(mcPos, HeadingUtils.fromFacing(signal.getFacing()), signal.getSignalType());
        }
        if (te instanceof TileEntityStationMarker) {
            TileEntityStationMarker stationMarker = (TileEntityStationMarker)te;
            return new MCNetworkStation(mcPos, stationMarker.getStationName());
        }
        return null;
    }

    public Set<MCTrain> provideTrains(List<EntityMinecart> carts) {
        ArrayList<ArrayList<EntityMinecart>> cartGroups = new ArrayList<ArrayList<EntityMinecart>>();
        for (EntityMinecart cart : carts) {
            ArrayList<EntityMinecart> cartGroup2 = cartGroups.stream().filter(c -> RailManager.getInstance().areLinked((EntityMinecart)c.get(0), cart)).findFirst().orElse(null);
            if (cartGroup2 == null) {
                cartGroup2 = new ArrayList<EntityMinecart>();
                cartGroups.add(cartGroup2);
            }
            cartGroup2.add(cart);
        }
        if (cartGroups.isEmpty()) {
            return new HashSet<MCTrain>();
        }
        RailNetworkManager railNetworkManager = RailNetworkManager.getInstance(carts.get((int)0).field_70170_p.field_72995_K);
        return cartGroups.stream().map(cartGroup -> new MCTrain(railNetworkManager, (List<EntityMinecart>)cartGroup)).collect(Collectors.toSet());
    }

    @Override
    public NetworkObject<MCPos> provideRemovalMarker(MCPos pos) {
        return new NetworkRemovalMarker(pos);
    }
}

