/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network.mc;

import com.minemaarten.signals.rail.network.NetworkRailLink;
import com.minemaarten.signals.rail.network.mc.ISerializableNetworkObject;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.NetworkSerializer;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MCNetworkRailLink
extends NetworkRailLink<MCPos>
implements ISerializableNetworkObject {
    public MCNetworkRailLink(MCPos pos, MCPos destination, int holdDelay) {
        super(pos, destination, holdDelay);
    }

    public static MCNetworkRailLink fromTag(NBTTagCompound tag) {
        MCPos destination = null;
        if (tag.func_74764_b("dest")) {
            destination = new MCPos(tag.func_74775_l("dest"));
        }
        return new MCNetworkRailLink(new MCPos(tag), destination, tag.func_74762_e("holdDelay"));
    }

    public static MCNetworkRailLink fromByteBuf(ByteBuf buf) {
        MCPos pos = new MCPos(buf);
        MCPos destination = null;
        if (buf.readBoolean()) {
            destination = new MCPos(buf);
        }
        return new MCNetworkRailLink(pos, destination, buf.readInt());
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        ((MCPos)this.getPos()).writeToNBT(tag);
        if (this.getDestinationPos() != null) {
            NBTTagCompound destTag = new NBTTagCompound();
            ((MCPos)this.getDestinationPos()).writeToNBT(destTag);
            tag.func_74782_a("dest", (NBTBase)destTag);
        }
        tag.func_74768_a("holdDelay", this.getHoldDelay());
    }

    @Override
    public void writeToBuf(ByteBuf b) {
        ((MCPos)this.getPos()).writeToBuf(b);
        if (this.getDestinationPos() != null) {
            b.writeBoolean(true);
            ((MCPos)this.getDestinationPos()).writeToBuf(b);
        } else {
            b.writeBoolean(false);
        }
        b.writeInt(this.getHoldDelay());
    }

    @Override
    public NetworkSerializer.EnumNetworkObject getType() {
        return NetworkSerializer.EnumNetworkObject.RAIL_LINK;
    }
}

