/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.minemaarten.signals.rail.network.IAdjacentCheckable;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.NetworkObject;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.NetworkSignal;
import com.minemaarten.signals.rail.network.PosAABB;
import com.minemaarten.signals.rail.network.RailObjectHolder;
import com.minemaarten.signals.rail.network.Train;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class RailSection<TPos extends IPosition<TPos>>
implements Iterable<NetworkRail<TPos>>,
IAdjacentCheckable<RailSection<TPos>> {
    private final ImmutableMap<TPos, NetworkRail<TPos>> rails;
    public final RailObjectHolder<TPos> railObjects;
    private final PosAABB<TPos> aabb;
    private final PosAABB<TPos> neighborAABB;

    public RailSection(RailObjectHolder<TPos> railObjects, Collection<NetworkRail<TPos>> rails) {
        this.rails = ImmutableMap.copyOf(rails.stream().collect(Collectors.toMap(NetworkObject::getPos, n -> n)));
        this.railObjects = railObjects.subSelection(rails);
        this.aabb = new PosAABB(rails.stream().map(NetworkObject::getPos).collect(Collectors.toList()));
        ImmutableSet<TPos> allRailNeighbors = this.calculateRailNeighbors();
        this.neighborAABB = new PosAABB<TPos>(allRailNeighbors);
    }

    private ImmutableSet<TPos> calculateRailNeighbors() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (IPosition railPos : this.rails.keySet()) {
            for (IPosition neighbor : railPos.allHorizontalNeighbors()) {
                if (this.rails.containsKey((Object)neighbor)) continue;
                builder.add((Object)neighbor);
            }
        }
        return builder.build();
    }

    public Train<TPos> getTrain(Collection<? extends Train<TPos>> trains) {
        return trains.stream().filter(t -> t.isInAABB(this.aabb, true)).findFirst().orElse(null);
    }

    public Stream<TPos> getRailPositions() {
        return this.rails.keySet().stream();
    }

    public Stream<NetworkSignal<TPos>> getSignals() {
        return this.railObjects.getSignals().stream();
    }

    public boolean containsRail(TPos pos) {
        return this.rails.containsKey(pos);
    }

    @Override
    public boolean isAdjacent(RailSection<TPos> section) {
        return section.aabb.intersects(this.neighborAABB);
    }

    @Override
    public Iterator<NetworkRail<TPos>> iterator() {
        return this.rails.values().iterator();
    }

    public String toString() {
        return StringUtils.join((Iterable)this.getRailPositions().collect(Collectors.toList()), (String)", ");
    }

    public boolean equals(Object other) {
        if (other instanceof RailSection) {
            boolean eq = this.rails.keySet().equals((Object)((RailSection)other).rails.keySet());
            return eq;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.rails.keySet().hashCode();
        return hash;
    }
}

