/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.google.common.collect.ImmutableList;
import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.NetworkSignal;
import com.minemaarten.signals.rail.network.RailEdge;
import org.apache.commons.lang3.StringUtils;

public class RailRoute<TPos extends IPosition<TPos>> {
    public final ImmutableList<RailRouteNode<TPos>> routeNodes;
    public final ImmutableList<RailEdge<TPos>> routeEdges;
    public final ImmutableList<TPos> routeRails;
    public final ImmutableList<NetworkSignal<TPos>> routeSignals;

    public RailRoute(ImmutableList<RailRouteNode<TPos>> routeNodes, ImmutableList<TPos> routeRails, ImmutableList<RailEdge<TPos>> routeEdges, ImmutableList<NetworkSignal<TPos>> routeSignals) {
        this.routeNodes = routeNodes;
        this.routeRails = routeRails;
        this.routeEdges = routeEdges;
        this.routeSignals = routeSignals;
    }

    public String toString() {
        return StringUtils.join(this.routeNodes, (String)" -> ");
    }

    public static enum EnumRouteResult {
        NO_STATIONS,
        NO_PATH,
        SUCCESS;

    }

    public static class RailRouteResult<TPos extends IPosition<TPos>> {
        public final RailRoute<TPos> railRoute;
        public final EnumRouteResult routeResult;

        private RailRouteResult(RailRoute<TPos> railRoute, EnumRouteResult routeResult) {
            this.railRoute = railRoute;
            this.routeResult = routeResult;
        }

        public static <TPos extends IPosition<TPos>> RailRouteResult<TPos> success(RailRoute<TPos> railRoute) {
            return new RailRouteResult<TPos>(railRoute, EnumRouteResult.SUCCESS);
        }

        public static <TPos extends IPosition<TPos>> RailRouteResult<TPos> noStations() {
            return new RailRouteResult<TPos>(null, EnumRouteResult.NO_STATIONS);
        }

        public static <TPos extends IPosition<TPos>> RailRouteResult<TPos> noPath() {
            return new RailRouteResult<TPos>(null, EnumRouteResult.NO_PATH);
        }
    }

    public static class RailRouteNode<TPos> {
        public final TPos pos;
        public final EnumHeading dirIn;
        public final EnumHeading dirOut;

        public RailRouteNode(TPos pos, EnumHeading dirIn, EnumHeading dirOut) {
            this.pos = pos;
            this.dirIn = dirIn;
            this.dirOut = dirOut;
        }

        public RailRouteNode<TPos> reverse() {
            return new RailRouteNode<TPos>(this.pos, EnumHeading.getOpposite(this.dirOut), EnumHeading.getOpposite(this.dirIn));
        }

        public boolean isValid() {
            return this.dirIn != null && this.dirOut != null;
        }

        public String toString() {
            return this.dirIn.shortString() + "_(" + this.pos + ")_" + this.dirOut.shortString();
        }
    }
}

