/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.google.common.collect.ImmutableMap;
import com.minemaarten.signals.lib.IdentityHashSet;
import com.minemaarten.signals.rail.network.IAdjacentCheckable;
import com.minemaarten.signals.rail.network.INetworkObject;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.RailEdge;
import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.RailSection;
import java.util.Collection;
import java.util.IdentityHashMap;

public class RailNetworkClient<TPos extends IPosition<TPos>>
extends RailNetwork<TPos> {
    private IdentityHashMap<RailSection<TPos>, IdentityHashSet<RailSection<TPos>>> adjacentSectionCache;
    private IdentityHashMap<RailEdge<TPos>, IdentityHashSet<RailEdge<TPos>>> adjacentEdgeCache;

    public RailNetworkClient(Collection<INetworkObject<TPos>> allNetworkObjects) {
        super(allNetworkObjects);
    }

    public RailNetworkClient(ImmutableMap<TPos, INetworkObject<TPos>> allNetworkObjects) {
        super(allNetworkObjects);
    }

    public static <TPos extends IPosition<TPos>> RailNetworkClient<TPos> empty() {
        return new RailNetworkClient<TPos>(ImmutableMap.of());
    }

    @Override
    protected void onAfterBuild() {
        super.onAfterBuild();
        this.adjacentSectionCache = this.calculateAdjacentSections(this.getAllSections());
        this.adjacentEdgeCache = this.calculateAdjacentSections(this.getAllEdges());
    }

    private <T extends IAdjacentCheckable<T>> IdentityHashMap<T, IdentityHashSet<T>> calculateAdjacentSections(Collection<T> allSections) {
        IdentityHashMap map = new IdentityHashMap();
        for (IAdjacentCheckable s1 : allSections) {
            IdentityHashSet<IAdjacentCheckable> adjacentSections = new IdentityHashSet<IAdjacentCheckable>();
            boolean startChecking = false;
            for (IAdjacentCheckable s2 : allSections) {
                if (!startChecking) {
                    if (s1 != s2) continue;
                    startChecking = true;
                    continue;
                }
                if (s1 == s2 || !s1.isAdjacent(s2)) continue;
                adjacentSections.add(s2);
            }
            map.put(s1, adjacentSections);
        }
        return map;
    }

    public boolean areAdjacent(RailSection<TPos> s1, RailSection<TPos> s2) {
        this.build();
        return this.adjacentSectionCache.get(s1).contains(s2);
    }

    public boolean areAdjacent(RailEdge<TPos> e1, RailEdge<TPos> e2) {
        this.build();
        return this.adjacentEdgeCache.get(e1).contains(e2);
    }
}

