/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.NetworkObject;
import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.Train;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public abstract class NetworkStation<TPos extends IPosition<TPos>>
extends NetworkObject<TPos> {
    public final String stationName;

    public NetworkStation(TPos pos, String stationName) {
        super(pos);
        Validate.notNull((Object)stationName);
        this.stationName = stationName;
    }

    public boolean isTrainApplicable(Train<TPos> train, Pattern destinationRegex) {
        return destinationRegex.matcher(this.stationName).matches();
    }

    public abstract List<TPos> getConnectedRailPositions(RailNetwork<TPos> var1);

    @Override
    public int getColor() {
        return -2237184;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof NetworkStation && ((NetworkStation)obj).stationName.equals(this.stationName);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.stationName.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + "(Station: " + this.stationName + ")";
    }
}

