/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.minemaarten.signals.api.access.ISignal;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.NetworkSignal;
import com.minemaarten.signals.rail.network.PosAABB;
import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.RailRoute;
import com.minemaarten.signals.rail.network.RailSection;
import com.minemaarten.signals.rail.network.Train;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NetworkState<TPos extends IPosition<TPos>> {
    private TIntObjectMap<Train<TPos>> trains = new TIntObjectHashMap();
    protected Map<TPos, ISignal.EnumLampStatus> signalToLampStatusses = new HashMap<TPos, ISignal.EnumLampStatus>();
    protected Map<TPos, ISignal.EnumForceMode> signalForces = new HashMap<TPos, ISignal.EnumForceMode>();
    private Map<NetworkSignal<TPos>, Train<TPos>> trainsAtSignals = new HashMap<NetworkSignal<TPos>, Train<TPos>>();
    private Map<RailSection<TPos>, Train<TPos>> trainsOnSections = new HashMap<RailSection<TPos>, Train<TPos>>();

    public void setTrains(Collection<? extends Train<TPos>> trains) {
        this.trains = new TIntObjectHashMap(trains.size());
        for (Train<TPos> t : trains) {
            this.addTrain(t);
        }
    }

    public void addTrain(Train<TPos> train) {
        this.trains.put(train.id, train);
    }

    public Train<TPos> getTrain(int id) {
        return (Train)this.trains.get(id);
    }

    private Stream<Train<TPos>> getTrainsInAABB(PosAABB<TPos> aabb) {
        return this.trains.valueCollection().stream().filter(t -> t.isInAABB(aabb));
    }

    public Iterable<Train<TPos>> getTrains() {
        return this.trains.valueCollection();
    }

    public Stream<Train<TPos>> getTrainStream() {
        return this.trains.valueCollection().stream();
    }

    public void removeTrain(Train<TPos> train) {
        Train t = (Train)this.trains.remove(train.id);
        if (t != null) {
            t.invalidate(this);
        }
    }

    public void update(RailNetwork<TPos> network) {
        this.trains.valueCollection().forEach(train -> train.updatePositions(this));
        this.updateTrainsAtSignals(network);
        this.updateSignalStatusses(network);
        this.pathfindTrains(network);
        this.updateRailLinkHolds(network);
    }

    private void updateTrainsAtSignals(RailNetwork<TPos> network) {
        HashMap<NetworkSignal<TPos>, Train<TPos>> newTrainsAtSignals = new HashMap<NetworkSignal<TPos>, Train<TPos>>();
        network.railObjects.getSignals().forEach(s -> newTrainsAtSignals.put((NetworkSignal<TPos>)s, this.getTrainAtSignal(network, (NetworkSignal<TPos>)s)));
        for (Map.Entry entry : newTrainsAtSignals.entrySet()) {
            Train curTrain = (Train)entry.getValue();
            Train<TPos> prevTrain = this.trainsAtSignals.get(entry.getKey());
            if (prevTrain == null || curTrain == prevTrain) continue;
            this.setForceMode(network, (IPosition)((NetworkSignal)entry.getKey()).getPos(), ISignal.EnumForceMode.NONE);
        }
        this.trainsAtSignals = newTrainsAtSignals;
    }

    public void updateTrainAtSections(Train<TPos> train, Iterable<RailSection<TPos>> prevSections, Iterable<RailSection<TPos>> newSections) {
        for (RailSection<TPos> prevSection : prevSections) {
            this.trainsOnSections.remove(prevSection);
        }
        for (RailSection<TPos> newSection : newSections) {
            this.trainsOnSections.put(newSection, train);
        }
    }

    private void updateSignalStatusses(RailNetwork<TPos> network) {
        List allSignals = network.railObjects.getSignals();
        Map<TPos, ISignal.EnumLampStatus> prevLampStatusses = this.signalToLampStatusses;
        this.signalToLampStatusses = new HashMap<TPos, ISignal.EnumLampStatus>();
        for (NetworkSignal signal : allSignals) {
            if (signal.type != NetworkSignal.EnumSignalType.BLOCK) continue;
            ISignal.EnumLampStatus signalStatus = this.getForcedStatus((IPosition)signal.getPos());
            if (signalStatus == null) {
                signalStatus = this.getBlockSignalStatus(network, signal);
            }
            this.signalToLampStatusses.put(signal.getPos(), signalStatus);
        }
        Set<NetworkSignal<TPos>> toEvaluate = allSignals.stream().filter(s -> s.type == NetworkSignal.EnumSignalType.CHAIN).collect(Collectors.toSet());
        while (!toEvaluate.isEmpty()) {
            NetworkSignal chainSignal;
            boolean hasEvaluated = false;
            Iterator iterator = toEvaluate.iterator();
            while (iterator.hasNext()) {
                chainSignal = (NetworkSignal)iterator.next();
                ISignal.EnumLampStatus signalStatus = this.getForcedStatus((IPosition)chainSignal.getPos());
                if (signalStatus == null) {
                    signalStatus = this.getChainSignalStatus(network, toEvaluate, chainSignal);
                }
                if (signalStatus == ISignal.EnumLampStatus.YELLOW_BLINKING) continue;
                this.signalToLampStatusses.put(chainSignal.getPos(), signalStatus);
                iterator.remove();
                hasEvaluated = true;
            }
            if (hasEvaluated) continue;
            iterator = toEvaluate.iterator();
            chainSignal = (NetworkSignal)iterator.next();
            iterator.remove();
            this.signalToLampStatusses.put(chainSignal.getPos(), ISignal.EnumLampStatus.GREEN);
        }
        Map<TPos, ISignal.EnumLampStatus> changedSignals = this.getChangedSignals(prevLampStatusses, this.signalToLampStatusses);
        if (!changedSignals.isEmpty()) {
            this.onSignalsChanged(changedSignals);
        }
    }

    protected void onSignalsChanged(Map<TPos, ISignal.EnumLampStatus> changedSignals) {
    }

    public void onNetworkChanged(RailNetwork<TPos> network) {
        this.signalForces.keySet().removeIf(pos -> !(network.railObjects.get((IPosition)pos) instanceof NetworkSignal));
    }

    private Map<TPos, ISignal.EnumLampStatus> getChangedSignals(Map<TPos, ISignal.EnumLampStatus> prevStatusses, Map<TPos, ISignal.EnumLampStatus> newStatusses) {
        HashMap<TPos, ISignal.EnumLampStatus> changedSignals = new HashMap<TPos, ISignal.EnumLampStatus>();
        for (Map.Entry<TPos, ISignal.EnumLampStatus> status : newStatusses.entrySet()) {
            ISignal.EnumLampStatus prevStatus = prevStatusses.get(status.getKey());
            if (status.getValue() == prevStatus) continue;
            changedSignals.put(status.getKey(), status.getValue());
        }
        return changedSignals;
    }

    private ISignal.EnumLampStatus getChainSignalStatus(RailNetwork<TPos> network, Set<NetworkSignal<TPos>> toEvaluate, NetworkSignal<TPos> chainSignal) {
        ISignal.EnumLampStatus blockSignalStatus = this.getBlockSignalStatus(network, chainSignal);
        if (blockSignalStatus == ISignal.EnumLampStatus.RED || blockSignalStatus == ISignal.EnumLampStatus.YELLOW) {
            return blockSignalStatus;
        }
        Train<TPos> routedTrain = this.trainsAtSignals.get(chainSignal);
        if (routedTrain != null) {
            if (routedTrain.getCurRoute() != null) {
                return this.evaluateCurRoutedTrain(network, routedTrain, chainSignal);
            }
            return ISignal.EnumLampStatus.RED;
        }
        RailSection<TPos> nextRailSection = chainSignal.getNextRailSection(network);
        if (nextRailSection == null) {
            return ISignal.EnumLampStatus.GREEN;
        }
        Set nextSignalStatusses = nextRailSection.getSignals().map(s -> this.getLampStatus((IPosition)s.getPos())).collect(Collectors.toSet());
        if (nextSignalStatusses.size() == 1) {
            return (ISignal.EnumLampStatus)((Object)nextSignalStatusses.iterator().next());
        }
        return ISignal.EnumLampStatus.YELLOW;
    }

    private ISignal.EnumLampStatus evaluateCurRoutedTrain(RailNetwork<TPos> network, Train<TPos> train, NetworkSignal<TPos> curSignal) {
        RailRoute<TPos> route = train.getCurRoute();
        if (this.isTrainClaimingNextSection(network, curSignal, train)) {
            return ISignal.EnumLampStatus.RED;
        }
        for (NetworkSignal signalInRoute : route.routeSignals) {
            if (signalInRoute == curSignal) continue;
            ISignal.EnumLampStatus nextSignalStatus = this.getLampStatus((IPosition)signalInRoute.getPos());
            if (nextSignalStatus == ISignal.EnumLampStatus.YELLOW) {
                if (this.isTrainClaimingNextSection(network, signalInRoute, train)) {
                    return ISignal.EnumLampStatus.RED;
                }
                if (signalInRoute.type != NetworkSignal.EnumSignalType.BLOCK) continue;
                return ISignal.EnumLampStatus.GREEN;
            }
            return nextSignalStatus;
        }
        return ISignal.EnumLampStatus.GREEN;
    }

    private ISignal.EnumLampStatus getBlockSignalStatus(RailNetwork<TPos> network, NetworkSignal<TPos> signal) {
        RailSection<TPos> nextSection = signal.getNextRailSection(network);
        if (nextSection != null) {
            Train<TPos> trainOnSection = this.trainsOnSections.get(nextSection);
            if (trainOnSection != null && !trainOnSection.getPositions().contains(signal.getRailPos())) {
                return ISignal.EnumLampStatus.RED;
            }
            Train<TPos> trainClaimingSection = this.getClaimingTrain(nextSection);
            if (trainClaimingSection != null && !trainClaimingSection.equals(this.trainsAtSignals.get(signal))) {
                return ISignal.EnumLampStatus.YELLOW;
            }
            return ISignal.EnumLampStatus.GREEN;
        }
        return ISignal.EnumLampStatus.GREEN;
    }

    private boolean isTrainClaimingNextSection(RailNetwork<TPos> network, NetworkSignal<TPos> signal, Train<TPos> ignoredTrain) {
        RailSection<TPos> nextSection = signal.getNextRailSection(network);
        if (nextSection == null) {
            return false;
        }
        Train<TPos> trainClaimingSection = this.getClaimingTrain(nextSection);
        return trainClaimingSection != null && !trainClaimingSection.equals(ignoredTrain);
    }

    public ISignal.EnumForceMode getForceMode(TPos signalPos) {
        ISignal.EnumForceMode forceMode = this.signalForces.get(signalPos);
        return forceMode != null ? forceMode : ISignal.EnumForceMode.NONE;
    }

    private ISignal.EnumLampStatus getForcedStatus(TPos signalPos) {
        ISignal.EnumForceMode forceMode = this.getForceMode(signalPos);
        if (forceMode == ISignal.EnumForceMode.FORCED_GREEN_ONCE) {
            return ISignal.EnumLampStatus.GREEN;
        }
        if (forceMode == ISignal.EnumForceMode.FORCED_RED) {
            return ISignal.EnumLampStatus.RED;
        }
        return null;
    }

    public void setForceMode(RailNetwork<TPos> network, TPos signalPos, ISignal.EnumForceMode forceMode) {
        if (network.railObjects.get(signalPos) instanceof NetworkSignal) {
            if (forceMode != ISignal.EnumForceMode.NONE) {
                this.signalForces.put(signalPos, forceMode);
            } else {
                this.signalForces.remove(signalPos);
            }
            this.onForceModeChanged(signalPos, forceMode);
        }
    }

    protected void onForceModeChanged(TPos signalPos, ISignal.EnumForceMode forceMode) {
    }

    public Train<TPos> getTrainAtPositions(List<TPos> positions) {
        PosAABB<TPos> aabb = new PosAABB<TPos>(positions);
        return this.getTrainsInAABB(aabb).findFirst().orElse(null);
    }

    private Train<TPos> getTrainAtSignal(RailNetwork<TPos> network, NetworkSignal<TPos> signal) {
        return this.getTrainAtPositions(network.getPositionsInFront(signal));
    }

    protected void setLampStatus(TPos signalPos, ISignal.EnumLampStatus status) {
        this.signalToLampStatusses.put(signalPos, status);
    }

    public ISignal.EnumLampStatus getLampStatus(TPos signalPos) {
        return this.signalToLampStatusses.getOrDefault(signalPos, ISignal.EnumLampStatus.YELLOW_BLINKING);
    }

    public Train<TPos> getClaimingTrain(RailSection<TPos> section) {
        for (Train train : this.trains.valueCollection()) {
            if (!train.getClaimedSections().contains(section)) continue;
            return train;
        }
        return null;
    }

    private void pathfindTrains(RailNetwork<TPos> network) {
        for (NetworkSignal signal : network.railObjects.getSignals()) {
            if (signal.type != NetworkSignal.EnumSignalType.CHAIN && this.getLampStatus((IPosition)signal.getPos()) != ISignal.EnumLampStatus.GREEN) continue;
            this.pathfindTrains(network, signal);
        }
    }

    private void pathfindTrains(RailNetwork<TPos> network, NetworkSignal<TPos> signal) {
        Train trainAtSignal = this.trainsAtSignals.get(signal);
        if (trainAtSignal != null && trainAtSignal.shouldPathfind((IPosition)signal.getPos())) {
            ISignal.EnumLampStatus status;
            RailRoute<TPos> route = trainAtSignal.pathfind(signal.getRailPos(), signal.heading);
            if (trainAtSignal.tryUpdatePath(network, this, route) && signal.type == NetworkSignal.EnumSignalType.CHAIN && (status = this.getChainSignalStatus(network, new HashSet<NetworkSignal<TPos>>(), signal)) != ISignal.EnumLampStatus.GREEN) {
                trainAtSignal.setPath(null);
            }
            this.onCartRouted(trainAtSignal, trainAtSignal.getCurRoute());
        }
    }

    protected void onCartRouted(Train<TPos> train, RailRoute<TPos> route) {
    }

    private void updateRailLinkHolds(RailNetwork<TPos> network) {
        for (Train train : this.trains.valueCollection()) {
            if (!train.isActive()) continue;
            for (IPosition trainPos : train.getPositions()) {
                int holdDelay = network.getRailLinkDelayFor(trainPos);
                if (holdDelay <= 0) continue;
                train.addRailLinkHold(trainPos, holdDelay);
            }
        }
    }
}

