/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.IRailLink;
import com.minemaarten.signals.rail.network.NetworkObject;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.RailObjectHolder;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NetworkRailLink<TPos extends IPosition<TPos>>
extends NetworkObject<TPos>
implements IRailLink<TPos> {
    private final TPos destination;
    private final List<TPos> potentialNeighbors;
    private final int holdDelay;

    public NetworkRailLink(TPos pos, TPos destination, int holdDelay) {
        super(pos);
        this.destination = destination;
        this.potentialNeighbors = EnumHeading.valuesStream().map(arg_0 -> pos.offset(arg_0)).collect(Collectors.toList());
        this.holdDelay = holdDelay;
    }

    @Override
    public TPos getDestinationPos() {
        return this.destination;
    }

    @Override
    public int getHoldDelay() {
        return this.holdDelay;
    }

    @Override
    public List<TPos> getNetworkNeighbors() {
        return this.potentialNeighbors;
    }

    @Override
    public Stream<NetworkRail<TPos>> getNeighborRails(RailObjectHolder<TPos> railObjects) {
        return railObjects.getNeighborRails(this.potentialNeighbors);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NetworkRailLink && Objects.equals(((NetworkRailLink)obj).destination, this.destination);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + (this.destination == null ? 0 : this.destination.hashCode());
    }
}

