/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.item;

import com.minemaarten.signals.Signals;
import com.minemaarten.signals.api.IRail;
import com.minemaarten.signals.api.tileentity.IDestinationProvider;
import com.minemaarten.signals.capabilities.CapabilityDestinationProvider;
import com.minemaarten.signals.item.ItemSignals;
import com.minemaarten.signals.proxy.CommonProxy;
import com.minemaarten.signals.rail.RailManager;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.tileentity.TileEntityRailLinkBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemRailConfigurator
extends ItemSignals {
    public ItemRailConfigurator() {
        super("rail_configurator");
        this.func_77625_d(1);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        CapabilityDestinationProvider cap;
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) != null && (cap = (CapabilityDestinationProvider)te.getCapability(CapabilityDestinationProvider.INSTANCE, null)) != null) {
            List<IDestinationProvider> providers = cap.getApplicableDestinationProviders();
            ArrayList<IDestinationProvider> guiProviders = new ArrayList<IDestinationProvider>();
            for (IDestinationProvider provider : providers) {
                if (!provider.hasGui(te)) continue;
                guiProviders.add(provider);
            }
            if (guiProviders.size() > 1) {
                player.openGui((Object)Signals.instance, CommonProxy.EnumGuiId.SELECT_DESTINATION_PROVIDER.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return EnumActionResult.SUCCESS;
            }
            if (!guiProviders.isEmpty()) {
                ((IDestinationProvider)guiProviders.get(0)).openGui(te, player);
                return EnumActionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!worldIn.field_72995_K) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof TileEntityRailLinkBase && playerIn.func_70093_af()) {
                TileEntityRailLinkBase railLinkBase = (TileEntityRailLinkBase)te;
                MCPos railPos = this.getLinkedRail(stack);
                if (railPos != null && railLinkBase.setLinkedPos(railPos, playerIn)) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("Linked to " + railPos));
                }
            } else {
                IBlockState state = worldIn.func_180495_p(pos);
                IRail r = RailManager.getInstance().getRail(worldIn, pos, state);
                if (r != null) {
                    this.setLinkedRail(stack, new MCPos(worldIn, pos));
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("Pos: " + pos));
                }
            }
        }
        return super.func_180614_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void setLinkedRail(ItemStack stack, MCPos railPos) {
        if (railPos != null) {
            NBTTagCompound tag = stack.func_190925_c("linkingRail");
            railPos.writeToNBT(tag);
        } else if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o("linkingRail");
        }
    }

    public MCPos getLinkedRail(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("linkingRail");
        if (tag != null) {
            if (tag.func_74764_b("dim")) {
                tag.func_74768_a("d", tag.func_74762_e("dim"));
                tag.func_82580_o("dim");
            }
            return new MCPos(tag);
        }
        return null;
    }
}

