/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.client.render.signals;

import com.minemaarten.signals.client.RectRenderer;
import com.minemaarten.signals.lib.HeadingUtils;
import com.minemaarten.signals.lib.Vec3iUtils;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.RailObjectHolder;
import com.minemaarten.signals.rail.network.mc.MCNetworkRail;
import com.minemaarten.signals.rail.network.mc.MCPos;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.item.ItemDye;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public abstract class AbstractRailRenderer<TSection> {
    protected final Map<TSection, SectionRenderer> sectionsToRenderer = new ConcurrentHashMap<TSection, SectionRenderer>();

    private void addSectionRenderer(TSection section) {
        SectionRenderer renderer = new SectionRenderer(section);
        Set invalidColors = this.getAdjacentSections(section).map(x -> x.colorIndex).collect(Collectors.toSet());
        int availableColors = 16 - invalidColors.size();
        if (availableColors > 0) {
            int usedIndex = Math.abs(section.hashCode()) % availableColors;
            for (int i = 0; i < 16; ++i) {
                if (invalidColors.contains(i) || usedIndex-- > 0) continue;
                renderer.colorIndex = i;
                break;
            }
        }
        renderer.compileRender();
        this.sectionsToRenderer.put(section, renderer);
    }

    private Stream<SectionRenderer> getAdjacentSections(TSection edge) {
        return this.sectionsToRenderer.entrySet().stream().filter(e -> this.isAdjacent(e.getKey(), edge)).map(e -> (SectionRenderer)e.getValue());
    }

    public void updateSectionRenderers() {
        this.sectionsToRenderer.clear();
        for (TSection edge : this.getRenderableSections()) {
            this.addSectionRenderer(edge);
        }
    }

    public void updateSpecificSection(TSection section) {
        this.sectionsToRenderer.remove(section);
        if (this.canRender(section)) {
            this.addSectionRenderer(section);
        }
    }

    protected abstract boolean isAdjacent(TSection var1, TSection var2);

    protected abstract Iterable<TSection> getRenderableSections();

    protected boolean canRender(TSection section) {
        return true;
    }

    protected abstract NetworkRail<MCPos> getRootNode(TSection var1);

    protected abstract RailObjectHolder<MCPos> getNeighborProvider(TSection var1);

    protected abstract boolean shouldTraverse(TSection var1, NetworkRail<MCPos> var2);

    public void render(int dimensionID, BufferBuilder b) {
        for (SectionRenderer edgeRenderer : this.sectionsToRenderer.values()) {
            edgeRenderer.render(dimensionID, b);
        }
    }

    public static int getRailHeightOffset(NetworkRail<MCPos> rail, EnumFacing dir) {
        switch (((MCNetworkRail)rail).getCurDir()) {
            case ASCENDING_EAST: {
                return dir == EnumFacing.EAST ? 1 : (dir == EnumFacing.WEST ? -1 : 0);
            }
            case ASCENDING_NORTH: {
                return dir == EnumFacing.NORTH ? 1 : (dir == EnumFacing.SOUTH ? -1 : 0);
            }
            case ASCENDING_SOUTH: {
                return dir == EnumFacing.SOUTH ? 1 : (dir == EnumFacing.NORTH ? -1 : 0);
            }
            case ASCENDING_WEST: {
                return dir == EnumFacing.WEST ? 1 : (dir == EnumFacing.EAST ? -1 : 0);
            }
        }
        return 0;
    }

    public double getLineWidth() {
        return 0.075;
    }

    public double getHeightOffset() {
        return 0.0;
    }

    private class SectionRenderer {
        public int colorIndex;
        private TIntObjectHashMap<RectRenderer> rectRenderers = new TIntObjectHashMap();
        private final TSection section;

        public SectionRenderer(TSection section) {
            this.section = section;
        }

        public void render(int dimensionID, BufferBuilder b) {
            RectRenderer rectRenderer = (RectRenderer)this.rectRenderers.get(dimensionID);
            if (rectRenderer != null) {
                rectRenderer.render(b);
            }
        }

        public void compileRender() {
            int color = ItemDye.field_150922_c[this.colorIndex];
            float r = (float)(color >> 16) / 256.0f;
            float g = (float)(color >> 8 & 0xFF) / 256.0f;
            float b = (float)(color & 0xFF) / 256.0f;
            NetworkRail<MCPos> rootNode = AbstractRailRenderer.this.getRootNode(this.section);
            HashSet<NetworkRail> traversed = new HashSet<NetworkRail>();
            traversed.add(rootNode);
            Stack<NetworkRail> toTraverse = new Stack<NetworkRail>();
            toTraverse.push(rootNode);
            RailObjectHolder<MCPos> neighborProvider = AbstractRailRenderer.this.getNeighborProvider(this.section);
            while (!toTraverse.isEmpty()) {
                NetworkRail node = (NetworkRail)toTraverse.pop();
                BlockRailBase.EnumRailDirection railDir = ((MCNetworkRail)node).getCurDir();
                List neighbors = node.getSectionNeighborRails(neighborProvider).collect(Collectors.toList());
                for (NetworkRail neighbor : neighbors) {
                    if (AbstractRailRenderer.this.shouldTraverse(this.section, neighbor) && traversed.add(neighbor)) {
                        toTraverse.push(neighbor);
                    }
                    if (((MCPos)neighbor.getPos()).getDimID() != ((MCPos)node.getPos()).getDimID()) continue;
                    RectRenderer rectRenderer = (RectRenderer)this.rectRenderers.get(((MCPos)neighbor.getPos()).getDimID());
                    if (rectRenderer == null) {
                        rectRenderer = new RectRenderer();
                        rectRenderer.width = AbstractRailRenderer.this.getLineWidth();
                        rectRenderer.setColor(r, g, b);
                        this.rectRenderers.put(((MCPos)neighbor.getPos()).getDimID(), (Object)rectRenderer);
                    }
                    rectRenderer.pos((double)((MCPos)node.getPos()).getX() + 0.5, (double)((MCPos)node.getPos()).getY() + (railDir.func_177018_c() ? 0.6 : 0.1) + AbstractRailRenderer.this.getHeightOffset(), (double)((MCPos)node.getPos()).getZ() + 0.5);
                    EnumFacing dir = HeadingUtils.toFacing(((MCPos)neighbor.getPos()).getRelativeHeading((MCPos)node.getPos()));
                    int offset = AbstractRailRenderer.getRailHeightOffset(node, dir);
                    Vec3d interpolated = Vec3iUtils.interpolate((Vec3i)((MCPos)node.getPos()).getPos(), (Vec3i)((MCPos)neighbor.getPos()).getPos());
                    rectRenderer.pos(interpolated.field_72450_a + 0.5, (double)((MCPos)node.getPos()).getY() + (offset == 1 ? 1.1 : 0.1) + AbstractRailRenderer.this.getHeightOffset(), interpolated.field_72449_c + 0.5);
                }
            }
        }
    }
}

