/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.client.gui.widget;

import com.minemaarten.signals.client.gui.widget.WidgetTextField;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class WidgetTextFieldNumber
extends WidgetTextField {
    public int minValue = Integer.MIN_VALUE;
    public int maxValue = Integer.MAX_VALUE;
    private int decimals;

    public WidgetTextFieldNumber(FontRenderer fontRenderer, int x, int y, int width, int height) {
        super(fontRenderer, x, y, width, height);
        this.setValue(0.0);
        this.func_175205_a(input -> {
            if (input == null || input.isEmpty() || input.equals("-")) {
                return true;
            }
            try {
                double d = Double.parseDouble(input);
                return d >= (double)this.minValue && d <= (double)this.maxValue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
    }

    public WidgetTextFieldNumber setDecimals(int decimals) {
        this.decimals = decimals;
        return this;
    }

    @Override
    public void onMouseClicked(int mouseX, int mouseY, int button) {
        boolean wasFocused = this.func_146206_l();
        super.onMouseClicked(mouseX, mouseY, button);
        if (this.func_146206_l()) {
            if (!wasFocused) {
                this.func_146202_e();
                this.func_146199_i(0);
            }
        } else {
            this.setValue(this.getDoubleValue());
        }
    }

    public WidgetTextFieldNumber setValue(double value) {
        this.func_146180_a(WidgetTextFieldNumber.roundNumberTo(value, this.decimals));
        return this;
    }

    public int getValue() {
        return MathHelper.func_76125_a((int)NumberUtils.toInt((String)this.func_146179_b()), (int)this.minValue, (int)this.maxValue);
    }

    public double getDoubleValue() {
        return WidgetTextFieldNumber.roundNumberToDouble(MathHelper.func_151237_a((double)NumberUtils.toDouble((String)this.func_146179_b()), (double)this.minValue, (double)this.maxValue), this.decimals);
    }

    private static String roundNumberTo(double value, int decimals) {
        double ret = WidgetTextFieldNumber.roundNumberToDouble(value, decimals);
        if (decimals == 0) {
            return "" + (int)ret;
        }
        return "" + ret;
    }

    private static double roundNumberToDouble(double value, int decimals) {
        return (double)Math.round(value * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
    }
}

