/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.client.gui;

import com.minemaarten.signals.Signals;
import com.minemaarten.signals.client.gui.widget.IGuiWidget;
import com.minemaarten.signals.client.gui.widget.IWidgetListener;
import com.minemaarten.signals.client.gui.widget.WidgetLabel;
import com.minemaarten.signals.network.NetworkHandler;
import com.minemaarten.signals.network.PacketGuiButton;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiContainerBase<Tile extends TileEntity>
extends GuiContainer
implements IWidgetListener {
    public final Tile te;
    private final ResourceLocation guiTexture;
    protected final List<IGuiWidget> widgets = new ArrayList<IGuiWidget>();
    private boolean refreshScheduled;
    private boolean hasInit;

    public GuiContainerBase(Container par1Container, Tile te, String guiTexture) {
        super(par1Container);
        this.te = te;
        this.guiTexture = guiTexture != null ? new ResourceLocation(guiTexture) : null;
    }

    protected void addWidget(IGuiWidget widget) {
        this.widgets.add(widget);
        widget.setListener(this);
    }

    protected void addWidgets(Iterable<IGuiWidget> widgets) {
        for (IGuiWidget widget : widgets) {
            this.addWidget(widget);
        }
    }

    protected void addLabel(String text, int x, int y) {
        this.addWidget(new WidgetLabel(x, y, text));
    }

    protected void removeWidget(IGuiWidget widget) {
        this.widgets.remove(widget);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.hasInit = true;
    }

    protected void func_146976_a(float partialTicks, int i, int j) {
        if (this.shouldDrawBackground()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bindGuiTexture();
            int xStart = (this.field_146294_l - this.field_146999_f) / 2;
            int yStart = (this.field_146295_m - this.field_147000_g) / 2;
            this.func_73729_b(xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glDisable((int)2896);
        for (IGuiWidget widget : this.widgets) {
            widget.render(i, j, partialTicks);
        }
        for (IGuiWidget widget : this.widgets) {
            widget.postRender(i, j, partialTicks);
        }
    }

    protected void drawBackLayer() {
        GlStateManager.func_179090_x();
        int borderWidth = 1;
        GuiContainerBase.func_73734_a((int)(this.field_147003_i - borderWidth), (int)(this.field_147009_r - borderWidth), (int)(this.field_147003_i + this.field_146999_f + borderWidth), (int)(this.field_147009_r + this.field_147000_g + borderWidth), (int)-14540254);
        GuiContainerBase.func_73734_a((int)this.field_147003_i, (int)this.field_147009_r, (int)(this.field_147003_i + this.field_146999_f), (int)(this.field_147009_r + this.field_147000_g), (int)-13421773);
        for (Slot slot : this.field_147002_h.field_75151_b) {
            GuiContainerBase.func_73734_a((int)(this.field_147003_i + slot.field_75223_e), (int)(this.field_147009_r + slot.field_75221_f), (int)(this.field_147003_i + slot.field_75223_e + 16), (int)(this.field_147009_r + slot.field_75221_f + 16), (int)-14540254);
        }
        GlStateManager.func_179098_w();
    }

    protected void drawDarkGreyTextCentered(int x, int y, String localizationKey, Object ... args) {
        this.drawDarkGreyText(x -= this.field_146289_q.func_78256_a(I18n.func_135052_a((String)localizationKey, (Object[])args)) / 2 + 1, y, localizationKey, args);
    }

    protected void drawDarkGreyText(int x, int y, String localizationKey, Object ... args) {
        String text = I18n.func_135052_a((String)localizationKey, (Object[])args);
        GuiContainerBase.func_73734_a((int)x, (int)y, (int)(x + this.field_146289_q.func_78256_a(text) + 3), (int)(y + this.field_146289_q.field_78288_b + 3), (int)-14540254);
        this.field_146289_q.func_78276_b(text, x + 2, y + 2, -1);
    }

    protected boolean shouldDrawBackground() {
        return true;
    }

    protected void bindGuiTexture() {
        if (this.guiTexture != null) {
            this.field_146297_k.func_110434_K().func_110577_a(this.guiTexture);
            GL11.glEnable((int)3553);
        }
    }

    protected void func_146979_b(int x, int y) {
        if (this.getInvNameOffset() != null && this.te instanceof IInventory) {
            IInventory inv = (IInventory)this.te;
            String containerName = inv.func_145818_k_() ? inv.func_70005_c_() : I18n.func_135052_a((String)(inv.func_70005_c_() + ".name"), (Object[])new Object[0]);
            this.field_146289_q.func_78276_b(containerName, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(containerName) / 2 + this.getInvNameOffset().x, 6 + this.getInvNameOffset().y, 0x404040);
        }
        if (this.getInvTextOffset() != null) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8 + this.getInvTextOffset().x, this.field_147000_g - 94 + this.getInvTextOffset().y, 0x404040);
        }
    }

    protected Point getInvNameOffset() {
        return new Point(0, 0);
    }

    protected Point getInvTextOffset() {
        return new Point(0, 0);
    }

    public void func_73863_a(int x, int y, float partialTick) {
        if (!this.hasInit) {
            return;
        }
        super.func_73863_a(x, y, partialTick);
        ArrayList<String> tooltip = new ArrayList<String>();
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glDisable((int)2896);
        for (IGuiWidget widget : this.widgets) {
            if (!widget.getBounds().contains(x, y)) continue;
            widget.addTooltip(x, y, tooltip, Signals.proxy.isSneakingInGui());
        }
        if (!tooltip.isEmpty()) {
            ArrayList<String> localizedTooltip = new ArrayList<String>();
            for (String line : tooltip) {
                String[] lines;
                String localizedLine = I18n.func_135052_a((String)line, (Object[])new Object[0]);
                for (String locLine : lines = WordUtils.wrap((String)localizedLine, (int)50).split(System.getProperty("line.separator"))) {
                    localizedTooltip.add(locLine);
                }
            }
            this.drawHoveringText(localizedTooltip, x, y, this.field_146289_q);
        }
    }

    public void func_73876_c() {
        if (this.refreshScheduled) {
            this.refreshScheduled = false;
            this.refreshScreen();
        }
        super.func_73876_c();
        for (IGuiWidget widget : this.widgets) {
            widget.update();
        }
    }

    protected void func_146284_a(GuiButton button) {
        this.sendPacketToServer(button.field_146127_k);
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        super.func_73864_a(par1, par2, par3);
        for (IGuiWidget widget : this.widgets) {
            if (widget.getBounds().contains(par1, par2)) {
                widget.onMouseClicked(par1, par2, par3);
                continue;
            }
            widget.onMouseClickedOutsideBounds(par1, par2, par3);
        }
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        this.sendPacketToServer(widget.getID());
    }

    protected void sendPacketToServer(int id) {
        NetworkHandler.sendToServer(new PacketGuiButton(id));
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        for (IGuiWidget widget : this.widgets) {
            widget.handleMouseInput();
        }
    }

    protected void func_73869_a(char key, int keyCode) throws IOException {
        for (IGuiWidget widget : this.widgets) {
            if (!widget.onKey(key, keyCode)) continue;
            return;
        }
        super.func_73869_a(key, keyCode);
    }

    public void func_146280_a(Minecraft par1Minecraft, int par2, int par3) {
        this.widgets.clear();
        super.func_146280_a(par1Minecraft, par2, par3);
    }

    public void refreshScreen() {
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
        int i = scaledresolution.func_78326_a();
        int j = scaledresolution.func_78328_b();
        this.func_146280_a(this.field_146297_k, i, j);
    }

    public void scheduleRefresh() {
        this.refreshScheduled = true;
    }

    public void drawHoveringString(List<String> text, int x, int y, FontRenderer fontRenderer) {
        this.drawHoveringText(text, x, y, fontRenderer);
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    @Override
    public void onKeyTyped(IGuiWidget widget) {
    }

    public void onFieldSynced() {
    }
}

