/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.client;

import com.minemaarten.signals.block.BlockSignalBase;
import com.minemaarten.signals.client.render.signals.BlockSectionRenderer;
import com.minemaarten.signals.client.render.signals.ClaimedPosRenderer;
import com.minemaarten.signals.client.render.signals.DirectionalityRenderer;
import com.minemaarten.signals.client.render.signals.PathRenderer;
import com.minemaarten.signals.client.render.signals.RailEdgeRenderer;
import com.minemaarten.signals.config.SignalsConfig;
import com.minemaarten.signals.rail.network.NetworkStation;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class ClientEventHandler {
    public static final ClientEventHandler INSTANCE = new ClientEventHandler();
    public final BlockSectionRenderer blockSectionRenderer = new BlockSectionRenderer();
    public final RailEdgeRenderer edgeRenderer = new RailEdgeRenderer();
    public final PathRenderer pathRenderer = new PathRenderer();
    public final ClaimedPosRenderer claimRenderer = new ClaimedPosRenderer();
    public final DirectionalityRenderer directionalityRenderer = new DirectionalityRenderer();

    private ClientEventHandler() {
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder b = t.func_178180_c();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!this.shouldRender()) {
            return;
        }
        double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.getPartialTicks();
        double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.getPartialTicks();
        double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.getPartialTicks();
        int dimensionID = player.field_70170_p.field_73011_w.getDimension();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-playerX), (double)(-playerY), (double)(-playerZ));
        GL11.glPointSize((float)10.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        b.func_178969_c(0.0, 0.0, 0.0);
        SignalsConfig.NetworkVisualizationSettings visualizationSettings = player.func_70093_af() ? SignalsConfig.client.networkVisualization.sneaking : SignalsConfig.client.networkVisualization.notSneaking;
        switch (visualizationSettings.renderType) {
            case EDGES: {
                this.edgeRenderer.render(dimensionID, b);
                break;
            }
            case PATHS: {
                this.pathRenderer.render(dimensionID, b);
                break;
            }
            case SECTION: {
                this.blockSectionRenderer.render(dimensionID, b);
            }
        }
        if (visualizationSettings.renderDirectionality) {
            this.directionalityRenderer.render(dimensionID, b);
        }
        b.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        List stations = RailNetworkManager.getClientInstance().getNetwork().railObjects.getStations();
        for (int i = 0; i < stations.size(); ++i) {
            NetworkStation station1 = stations.get(i);
            if (((MCPos)station1.getPos()).getDimID() != dimensionID) continue;
            for (int j = 0; j < i; ++j) {
                NetworkStation station2 = stations.get(j);
                if (((MCPos)station2.getPos()).getDimID() != dimensionID || !station1.stationName.equals(station2.stationName) || ((MCPos)station1.getPos()).getDimID() != ((MCPos)station2.getPos()).getDimID()) continue;
                this.drawBetween(b, ((MCPos)station1.getPos()).getPos(), ((MCPos)station2.getPos()).getPos(), 1.0, 0.0f, 1.0f, 0.0f, 1.0f);
            }
        }
        t.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GL11.glPopMatrix();
    }

    private boolean shouldRender() {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        Item item = player.field_71071_by.func_70448_g().func_77973_b();
        if (SignalsConfig.client.networkVisualization.isValid(item)) {
            return true;
        }
        RayTraceResult ray = Minecraft.func_71410_x().field_71476_x;
        return ray != null && ray.field_72313_a == RayTraceResult.Type.BLOCK && player.field_70170_p.func_180495_p(ray.func_178782_a()).func_177230_c() instanceof BlockSignalBase;
    }

    private void drawBetween(BufferBuilder buffer, BlockPos p1, BlockPos p2, double offset, float r, float g, float b, float a) {
        ClientEventHandler.drawBetween(buffer, p1, p2, offset, offset, r, g, b, a);
    }

    private static void drawBetween(BufferBuilder buffer, BlockPos p1, BlockPos p2, double offset1, double offset2, float r, float g, float b, float alpha) {
        buffer.func_181662_b((double)p1.func_177958_n() + 0.5, (double)p1.func_177956_o() + offset1, (double)p1.func_177952_p() + 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
        buffer.func_181662_b((double)p2.func_177958_n() + 0.5, (double)p2.func_177956_o() + offset2, (double)p2.func_177952_p() + 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
    }
}

