/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.block;

import com.minemaarten.signals.block.BlockTeleportRail;
import com.minemaarten.signals.client.CreativeTabSignals;
import com.minemaarten.signals.init.ModBlocks;
import com.minemaarten.signals.tileentity.TileEntityTransportRail;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockTransportRail
extends BlockRailPowered
implements ITileEntityProvider {
    public static final PropertyBool FORWARD = PropertyBool.func_177716_a((String)"forward");

    public BlockTransportRail() {
        this.func_149663_c("transport_rail");
        this.func_149647_a(CreativeTabSignals.getInstance());
        ModBlocks.registerBlock((Block)this);
        GameRegistry.registerTileEntity(TileEntityTransportRail.class, (String)"transport_rail");
    }

    public void onMinecartPass(World world, EntityMinecart cart, BlockPos pos) {
        double maxSpeed;
        super.onMinecartPass(world, cart, pos);
        Vec3d vec = new Vec3d(cart.field_70159_w, cart.field_70181_x, cart.field_70179_y);
        double maxAcceleration = 0.2;
        double vecLength = vec.func_72433_c();
        IBlockState state = world.func_180495_p(pos);
        state = state.func_177230_c().func_176221_a(state, (IBlockAccess)world, pos);
        boolean powered = (Boolean)state.func_177229_b((IProperty)field_176569_M);
        double d = maxSpeed = powered ? 0.1 : 0.0;
        if (vecLength > maxSpeed) {
            vecLength = Math.max(vecLength - maxAcceleration, maxSpeed);
        } else if (vecLength < maxSpeed) {
            if (vecLength < 0.1) {
                EnumFacing pushDir = BlockTeleportRail.getDirection((BlockRailBase.EnumRailDirection)state.func_177229_b(this.func_176560_l()), (Boolean)state.func_177229_b((IProperty)FORWARD));
                vec = new Vec3d((double)pushDir.func_82601_c(), 0.0, (double)pushDir.func_82599_e());
            }
            vecLength = Math.min(vecLength + maxAcceleration, maxSpeed);
        }
        vec = vec.func_72432_b().func_186678_a(vecLength);
        cart.field_70159_w = vec.field_72450_a;
        cart.field_70181_x = vec.field_72448_b;
        cart.field_70179_y = vec.field_72449_c;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityTransportRail();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.func_176560_l(), field_176569_M, FORWARD});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityTransportRail te = (TileEntityTransportRail)worldIn.func_175625_s(pos);
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)FORWARD, (Comparable)Boolean.valueOf(te.isForward()));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                TileEntityTransportRail te = (TileEntityTransportRail)worldIn.func_175625_s(pos);
                te.toggleForward();
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("signals.message.teleport_rail_toggled_direction", new Object[0]));
            }
            return true;
        }
        return false;
    }
}

