/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.block;

import com.minemaarten.signals.client.CreativeTabSignals;
import com.minemaarten.signals.init.ModBlocks;
import com.minemaarten.signals.network.NetworkHandler;
import com.minemaarten.signals.network.PacketSpawnParticle;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.RailEdge;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.MCTrain;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import com.minemaarten.signals.tileentity.TileEntityTeleportRail;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockTeleportRail
extends BlockRailBase
implements ITileEntityProvider {
    public static final PropertyBool FORWARD = PropertyBool.func_177716_a((String)"forward");

    public BlockTeleportRail() {
        super(false);
        this.func_149663_c("teleport_rail");
        this.func_149647_a(CreativeTabSignals.getInstance());
        ModBlocks.registerBlock((Block)this);
        GameRegistry.registerTileEntity(TileEntityTeleportRail.class, (String)"signals:teleport_rail");
    }

    public boolean isFlexibleRail(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void onMinecartPass(World world, EntityMinecart cart, BlockPos pos) {
        TileEntityTeleportRail te;
        MCPos telDestination;
        super.onMinecartPass(world, cart, pos);
        if (!world.field_72995_K && (telDestination = (te = (TileEntityTeleportRail)world.func_175625_s(pos)).getLinkedPosition()) != null) {
            this.spawnParticle(cart);
            MCTrain train = RailNetworkManager.getServerInstance().getState().getTrain(cart.func_110124_au());
            if (train != null && train.getCarts().size() == train.cartIDs.size()) {
                Set<MCPos> teleportRails = this.getNeighboringTeleportRails(world, pos);
                for (MCPos cartPos : train.getPositions()) {
                    if (teleportRails.contains(cartPos)) continue;
                    return;
                }
                this.teleport(new HashSet<EntityMinecart>(train.getCarts()), telDestination);
            }
        }
    }

    private void teleport(Set<EntityMinecart> carts, MCPos destination) {
        for (EntityMinecart cart : carts) {
            this.teleport(cart, destination);
        }
    }

    private void teleport(EntityMinecart cart, MCPos destination) {
        if (cart instanceof EntityMinecartContainer) {
            ((EntityMinecartContainer)cart).field_94112_b = false;
        }
        int dimensionIn = destination.getDimID();
        BlockPos destPos = destination.getPos();
        if (!ForgeHooks.onTravelToDimension((Entity)cart, (int)destination.getDimID())) {
            return;
        }
        MinecraftServer minecraftserver = cart.func_184102_h();
        int i = cart.field_71093_bK;
        WorldServer worldserver = minecraftserver.func_71218_a(i);
        WorldServer worldserver1 = minecraftserver.func_71218_a(dimensionIn);
        cart.field_71093_bK = dimensionIn;
        cart.field_70170_p.func_72900_e((Entity)cart);
        cart.field_70128_L = false;
        BlockPos blockpos = destination.getPos();
        cart.func_174828_a(destPos, 90.0f, 0.0f);
        worldserver.func_72866_a((Entity)cart, false);
        Entity entity = EntityList.func_191304_a(cart.getClass(), (World)worldserver1);
        if (entity != null) {
            BlockTeleportRail.copyDataFromOld(entity, (Entity)cart);
            entity.func_174828_a(blockpos, entity.field_70177_z, entity.field_70125_A);
            IBlockState state = destination.getLoadedBlockState();
            if (state.func_177230_c() == ModBlocks.TELEPORT_RAIL) {
                EnumFacing teleportDir = this.getTeleportDirection(state);
                double speed = 0.2;
                entity.field_70159_w = (double)teleportDir.func_82601_c() * speed;
                entity.field_70181_x = (double)teleportDir.func_96559_d() * speed;
                entity.field_70179_y = (double)teleportDir.func_82599_e() * speed;
            } else {
                entity.field_70179_y = 0.0;
                entity.field_70181_x = 0.0;
                entity.field_70159_w = 0.0;
            }
            boolean flag = entity.field_98038_p;
            entity.field_98038_p = true;
            worldserver1.func_72838_d(entity);
            entity.field_98038_p = flag;
            worldserver1.func_72866_a(entity, false);
        }
        cart.field_70128_L = true;
        worldserver.func_82742_i();
        worldserver1.func_82742_i();
    }

    private static void copyDataFromOld(Entity newEntity, Entity entityIn) {
        NBTTagCompound nbttagcompound = entityIn.func_189511_e(new NBTTagCompound());
        nbttagcompound.func_82580_o("Dimension");
        newEntity.func_70020_e(nbttagcompound);
    }

    private Set<MCPos> getNeighboringTeleportRails(World world, BlockPos pos) {
        NetworkRail<MCPos> neighborRail;
        int curIndex;
        HashSet<MCPos> ret = new HashSet<MCPos>();
        MCPos mcPos = new MCPos(world, pos);
        RailEdge<MCPos> edge = RailNetworkManager.getServerInstance().getNetwork().findEdge(mcPos);
        int startIndex = edge.getIndex(mcPos);
        Object thisRailType = edge.get(startIndex).getRailType();
        for (curIndex = startIndex; curIndex >= 0 && (neighborRail = edge.get(curIndex)).getRailType().equals(thisRailType) && ((MCPos)neighborRail.getPos()).getDimID() == world.field_73011_w.getDimension(); --curIndex) {
            ret.add((MCPos)neighborRail.getPos());
        }
        for (curIndex = startIndex + 1; curIndex < edge.length && (neighborRail = edge.get(curIndex)).getRailType().equals(thisRailType) && ((MCPos)neighborRail.getPos()).getDimID() == world.field_73011_w.getDimension(); ++curIndex) {
            ret.add((MCPos)neighborRail.getPos());
        }
        return ret;
    }

    private void spawnParticle(EntityMinecart cart) {
        Random rand = cart.field_70170_p.field_73012_v;
        float maxSpeed = 1.0f;
        float f = (rand.nextFloat() - 0.5f) * maxSpeed;
        float f1 = (rand.nextFloat() - 0.5f) * maxSpeed;
        float f2 = (rand.nextFloat() - 0.5f) * maxSpeed;
        NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumParticleTypes.PORTAL, cart.field_70165_t, cart.field_70163_u, cart.field_70161_v, f, f1, f2), cart.field_70170_p);
    }

    public IProperty<BlockRailBase.EnumRailDirection> func_176560_l() {
        return BlockRailPowered.field_176568_b;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.func_176560_l(), FORWARD});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.func_177016_a((int)(meta >> 1))).func_177226_a((IProperty)FORWARD, (Comparable)Boolean.valueOf((meta & 1) > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (((BlockRailBase.EnumRailDirection)state.func_177229_b(this.func_176560_l())).func_177015_a() << 1) + ((Boolean)state.func_177229_b((IProperty)FORWARD) != false ? 1 : 0);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityTeleportRail();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    private EnumFacing getTeleportDirection(IBlockState state) {
        BlockRailBase.EnumRailDirection railDir = (BlockRailBase.EnumRailDirection)state.func_177229_b(this.func_176560_l());
        boolean forward = (Boolean)state.func_177229_b((IProperty)FORWARD);
        return BlockTeleportRail.getDirection(railDir, forward);
    }

    public static EnumFacing getDirection(BlockRailBase.EnumRailDirection railDir, boolean forward) {
        switch (railDir) {
            case EAST_WEST: {
                return forward ? EnumFacing.EAST : EnumFacing.WEST;
            }
            case ASCENDING_EAST: {
                return forward ? EnumFacing.EAST : EnumFacing.WEST;
            }
            case ASCENDING_WEST: {
                return forward ? EnumFacing.WEST : EnumFacing.EAST;
            }
            case NORTH_SOUTH: {
                return forward ? EnumFacing.NORTH : EnumFacing.SOUTH;
            }
            case ASCENDING_NORTH: {
                return forward ? EnumFacing.NORTH : EnumFacing.SOUTH;
            }
            case ASCENDING_SOUTH: {
                return forward ? EnumFacing.SOUTH : EnumFacing.NORTH;
            }
        }
        throw new IllegalStateException("Invalid rail dir for teleport track: " + railDir);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                worldIn.func_175656_a(pos, state.func_177231_a((IProperty)FORWARD));
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("signals.message.teleport_rail_toggled_direction", new Object[0]));
            }
            return true;
        }
        return false;
    }
}

