/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals;

import com.minemaarten.signals.capabilities.CapabilityDestinationProvider;
import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.chunkloading.ChunkLoadManager;
import com.minemaarten.signals.commands.CommandSignals;
import com.minemaarten.signals.config.SignalsConfig;
import com.minemaarten.signals.dispenser.BehaviorDispenseTicket;
import com.minemaarten.signals.event.EventHandler;
import com.minemaarten.signals.event.RailReplacerEventHandler;
import com.minemaarten.signals.init.ModBlocks;
import com.minemaarten.signals.init.ModItems;
import com.minemaarten.signals.lib.Log;
import com.minemaarten.signals.lib.Versions;
import com.minemaarten.signals.network.NetworkHandler;
import com.minemaarten.signals.proxy.CommonProxy;
import com.minemaarten.signals.rail.RailManager;
import net.minecraft.block.BlockDispenser;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="signals", name="Signals", acceptedMinecraftVersions="[1.12.2,]")
public class Signals {
    @SidedProxy(clientSide="com.minemaarten.signals.proxy.ClientProxy", serverSide="com.minemaarten.signals.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="signals")
    public static Signals instance;
    private ASMDataTable asmData;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent event) {
        event.getModMetadata().version = Versions.fullVersionString();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.preInit();
        ModBlocks.init();
        ModItems.init();
        CapabilityMinecartDestination.register();
        CapabilityDestinationProvider.register();
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RailReplacerEventHandler());
        BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.TICKET, (Object)new BehaviorDispenseTicket());
        ChunkLoadManager.INSTANCE.init();
        this.asmData = event.getAsmData();
        if (!SignalsConfig.enableRailNetwork) {
            Log.warning("RAIL NETWORK IS NOT FUNCTIONAL!");
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        NetworkHandler.init();
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        RailManager.getInstance().initializeAPIImplementors(this.asmData);
        SignalsConfig.client.networkVisualization.initDefaults();
        ConfigManager.sync((String)"signals", (Config.Type)Config.Type.INSTANCE);
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        ServerCommandManager comManager = (ServerCommandManager)event.getServer().func_71187_D();
        comManager.func_71560_a((ICommand)new CommandSignals());
    }
}

