/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.common.utils;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class DimensionalPosition {
    private int dim;
    private int x;
    private int y;
    private int z;

    public DimensionalPosition(int xIn, int yIn, int zIn, int dimension) {
        this.x = xIn;
        this.y = yIn;
        this.z = zIn;
        this.dim = dimension;
    }

    public DimensionalPosition(NBTTagCompound tag) {
        this(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"), tag.func_74762_e("d"));
    }

    public DimensionalPosition(BlockPos pos, int dimension) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dimension);
    }

    public DimensionalPosition(Entity entity) {
        this(entity.func_180425_c(), entity.field_70170_p.field_73011_w.getDimension());
    }

    public DimensionalPosition(TileEntity entity) {
        this(entity.func_174877_v(), entity.func_145831_w().field_73011_w.getDimension());
    }

    public BlockPos getPosition() {
        return new BlockPos(this.getX(), this.getY(), this.getZ());
    }

    public int getX() {
        return this.x;
    }

    public int getDim() {
        return this.dim;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DimensionalPosition: ");
        sb.append(this.dim);
        sb.append(" | x:");
        sb.append(this.x);
        sb.append(", y:");
        sb.append(this.y);
        sb.append(", z:");
        sb.append(this.z);
        return sb.toString();
    }

    public double getDistanceSqFrom(DimensionalPosition pos) {
        if (pos.getDim() != this.getDim()) {
            return Double.POSITIVE_INFINITY;
        }
        int diffx = this.getX() - pos.getX();
        int diffy = this.getY() - pos.getY();
        int diffz = this.getZ() - pos.getZ();
        return diffx * diffx + diffy * diffy + diffz * diffz;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("y", this.y);
        tag.func_74768_a("z", this.z);
        tag.func_74768_a("d", this.dim);
        return tag;
    }
}

