/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.reactor;

import ic2.api.info.Info;
import ic2.api.item.IHazmatLike;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import java.util.ArrayDeque;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techreborn.init.ModItems;
import techreborn.items.reactor.ItemDamageableReactorComponent;
import techreborn.items.reactor.ReactorUtils;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.info.Info", modid="ic2"), @Optional.Interface(iface="ic2.api.item.IHazmatLike", modid="ic2"), @Optional.Interface(iface="ic2.api.reactor.IReactor", modid="ic2"), @Optional.Interface(iface="ic2.api.reactor.IReactorComponent", modid="ic2")})
public class ItemThoriumFuelRod
extends ItemDamageableReactorComponent {
    public final int rodCount;

    public ItemThoriumFuelRod(String name, int rodCount) {
        super(name, 100000);
        this.rodCount = rodCount;
    }

    @Optional.Method(modid="ic2")
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotIndex, boolean isCurrentItem) {
        EntityLivingBase entityLiving;
        if (entity instanceof EntityLivingBase && !IHazmatLike.hasCompleteHazmat((EntityLivingBase)(entityLiving = (EntityLivingBase)entity))) {
            PotionEffect effect = new PotionEffect(Info.POTION_RADIATION, 200, 100);
            entityLiving.func_70690_d(effect);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("Time left: " + (this.getMaxDamage(stack) - this.getDamage(stack)) + " seconds");
    }

    @Override
    @Optional.Method(modid="ic2")
    public void processChamber(ItemStack stack, IReactor reactor, int x, int y, boolean heatRun) {
        if (!reactor.produceEnergy()) {
            return;
        }
        int basePulses = 1 + this.rodCount / 2;
        for (int iteration = 0; iteration < this.rodCount; ++iteration) {
            int heat;
            int dheat;
            int pulses = basePulses;
            if (!heatRun) {
                IntStream.range(0, pulses).forEach(pulse -> this.acceptUraniumPulse(stack, reactor, stack, x, y, x, y, heatRun));
                ReactorUtils.checkPulseable(reactor, x - 1, y, stack, x, y, heatRun);
                ReactorUtils.checkPulseable(reactor, x + 1, y, stack, x, y, heatRun);
                ReactorUtils.checkPulseable(reactor, x, y - 1, stack, x, y, heatRun);
                ReactorUtils.checkPulseable(reactor, x, y + 1, stack, x, y, heatRun);
                continue;
            }
            ArrayDeque<ReactorUtils.ItemStackCoord> heatAcceptors = new ArrayDeque<ReactorUtils.ItemStackCoord>();
            ReactorUtils.checkHeatAcceptor(reactor, x - 1, y, heatAcceptors);
            ReactorUtils.checkHeatAcceptor(reactor, x + 1, y, heatAcceptors);
            ReactorUtils.checkHeatAcceptor(reactor, x, y - 1, heatAcceptors);
            ReactorUtils.checkHeatAcceptor(reactor, x, y + 1, heatAcceptors);
            for (heat = (int)((float)(ReactorUtils.triangularNumber(pulses += ReactorUtils.checkPulseable(reactor, x - 1, y, stack, x, y, heatRun) + ReactorUtils.checkPulseable(reactor, x + 1, y, stack, x, y, heatRun) + ReactorUtils.checkPulseable(reactor, x, y - 1, stack, x, y, heatRun) + ReactorUtils.checkPulseable(reactor, x, y + 1, stack, x, y, heatRun)) * 4) * 0.2f); !heatAcceptors.isEmpty() && heat > 0; heat += dheat) {
                dheat = heat / heatAcceptors.size();
                heat -= dheat;
                ReactorUtils.ItemStackCoord acceptor = (ReactorUtils.ItemStackCoord)heatAcceptors.remove();
                IReactorComponent acceptorComp = (IReactorComponent)acceptor.stack.func_77973_b();
                dheat = acceptorComp.alterHeat(acceptor.stack, reactor, acceptor.x, acceptor.y, dheat);
            }
            if (heat <= 0) continue;
            reactor.addHeat(heat);
        }
        if (!heatRun && this.getDamage(stack) >= this.getMaxDamage(stack) - 1) {
            reactor.setItemAt(x, y, this.getDepletedStack(stack, reactor));
        } else if (!heatRun) {
            this.setDamage(stack, this.getDamage(stack) + 1);
        }
    }

    @Override
    @Optional.Method(modid="ic2")
    public boolean acceptUraniumPulse(ItemStack stack, IReactor reactor, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        if (!heatrun) {
            reactor.addOutput(0.2f);
        }
        return true;
    }

    @Override
    @Optional.Method(modid="ic2")
    public float influenceExplosion(ItemStack itemStack, IReactor reactor) {
        return 2.0f * (float)this.rodCount / 5.0f;
    }

    @Optional.Method(modid="ic2")
    protected ItemStack getDepletedStack(ItemStack stack, IReactor reactor) {
        ItemStack ret;
        switch (this.rodCount) {
            case 1: {
                ret = new ItemStack(ModItems.DEPLETED_THORIUM_FUEL_ROD_SINGLE);
                break;
            }
            case 2: {
                ret = new ItemStack(ModItems.DEPLETED_THORIUM_FUEL_ROD_DUAL);
                break;
            }
            case 4: {
                ret = new ItemStack(ModItems.DEPLETED_THORIUM_FUEL_ROD_QUAD);
                break;
            }
            default: {
                throw new RuntimeException("Invalid rod count: " + this.rodCount);
            }
        }
        return ret.func_77946_l();
    }
}

