/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init.recipes;

import com.google.common.base.CaseFormat;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.util.OreUtil;
import reborncore.common.util.RebornCraftingHelper;
import reborncore.common.util.StringUtils;
import techreborn.Core;
import techreborn.blocks.BlockStorage;
import techreborn.blocks.BlockStorage2;
import techreborn.blocks.cable.EnumCableType;
import techreborn.compat.CompatManager;
import techreborn.config.ConfigTechReborn;
import techreborn.init.IC2Duplicates;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.init.recipes.RecipeMethods;
import techreborn.items.ItemDynamicCell;
import techreborn.items.ItemUpgrades;
import techreborn.items.ingredients.ItemDustsSmall;
import techreborn.items.ingredients.ItemNuggets;
import techreborn.items.ingredients.ItemParts;

@RebornRegistry(modID="techreborn")
public class CraftingTableRecipes
extends RecipeMethods {
    @ConfigRegistry(config="recipes", category="crafting", key="cellRecipe", comment="Enables the new thermal expansion compatible cell recipe")
    public static boolean newCellRecipe = true;

    public static void init() {
        CraftingTableRecipes.registerCompressionRecipes();
        CraftingTableRecipes.registerMixedMetalIngotRecipes();
        CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getStack(ModBlocks.RUBBER_PLANKS, 4), IC2Duplicates.RUBBER_WOOD.getStackBasedOnConfig());
        CraftingTableRecipes.registerShaped(new ItemStack(ModBlocks.RUBBER_LOG_SLAB_HALF, 6), "WWW", Character.valueOf('W'), new ItemStack(ModBlocks.RUBBER_PLANKS));
        CraftingTableRecipes.registerShaped(new ItemStack(ModBlocks.RUBBER_LOG_STAIR, 4), "W  ", "WW ", "WWW", Character.valueOf('W'), new ItemStack(ModBlocks.RUBBER_PLANKS));
        CraftingTableRecipes.registerShapeless(BlockStorage2.getStorageBlockByName("iridium_reinforced_stone", 1), "stone", "plateIridiumAlloy");
        CraftingTableRecipes.registerShapeless(BlockStorage2.getStorageBlockByName("iridium_reinforced_tungstensteel", 1), BlockStorage2.getStorageBlockByName("tungstensteel", 1), "plateIridium");
        CraftingTableRecipes.registerShapeless(BlockStorage2.getStorageBlockByName("iridium_reinforced_tungstensteel", 1), BlockStorage2.getStorageBlockByName("iridium_reinforced_stone", 1), CraftingTableRecipes.getMaterialObject("tungstensteel", RecipeMethods.Type.INGOT));
        if (newCellRecipe) {
            CraftingTableRecipes.registerShaped(ItemDynamicCell.getEmptyCell(16), " T ", "TGT", " T ", Character.valueOf('T'), "ingotTin", Character.valueOf('G'), "paneGlass");
        } else {
            CraftingTableRecipes.registerShaped(ItemDynamicCell.getEmptyCell(16), " T ", "T T", " T ", Character.valueOf('T'), "ingotTin");
        }
        if (!IC2Duplicates.deduplicate()) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.REFINED_IRON_FENCE), "RRR", "RRR", Character.valueOf('R'), "ingotRefinedIron");
        }
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.REINFORCED_GLASS, 7), "GAG", "GGG", "GAG", Character.valueOf('A'), "plateAdvancedAlloy", Character.valueOf('G'), "blockGlass");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.REINFORCED_GLASS, 7), "GGG", "AGA", "GGG", Character.valueOf('A'), "plateAdvancedAlloy", Character.valueOf('G'), "blockGlass");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.WRENCH), "BNB", "NBN", " B ", Character.valueOf('B'), "ingotBronze", Character.valueOf('N'), "nuggetBronze");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.TREE_TAP), " S ", "PPP", "P  ", Character.valueOf('S'), "stickWood", Character.valueOf('P'), "plankWood");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.ELECTRIC_TREE_TAP), "TB", "  ", Character.valueOf('T'), CraftingTableRecipes.getStack(ModItems.TREE_TAP), Character.valueOf('B'), "reBattery");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.NANOSABER), "DC ", "DC ", "GLG", Character.valueOf('L'), "lapotronCrystal", Character.valueOf('C'), "plateCarbon", Character.valueOf('D'), "plateDiamond", Character.valueOf('G'), CraftingTableRecipes.getMaterialObject("glowstone", RecipeMethods.Type.SMALL_DUST));
        ItemStack rockCutter = CraftingTableRecipes.getStack(ModItems.ROCK_CUTTER);
        rockCutter.func_77966_a(Enchantments.field_185306_r, 1);
        CraftingTableRecipes.registerShaped(rockCutter, "DT ", "DT ", "DCB", Character.valueOf('D'), "dustDiamond", Character.valueOf('T'), "ingotTitanium", Character.valueOf('C'), "circuitBasic", Character.valueOf('B'), "reBattery");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.STEEL_DRILL), " S ", "SCS", "SBS", Character.valueOf('S'), "ingotSteel", Character.valueOf('C'), "circuitBasic", Character.valueOf('B'), "reBattery");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.DIAMOND_DRILL), " D ", "DCD", "TST", Character.valueOf('D'), "gemDiamond", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('S'), CraftingTableRecipes.getStack(ModItems.STEEL_DRILL, 1, Short.MAX_VALUE), Character.valueOf('T'), "ingotTitanium");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.ADVANCED_DRILL), " I ", "NCN", "OAO", Character.valueOf('I'), "plateIridiumAlloy", Character.valueOf('N'), "nuggetIridium", Character.valueOf('A'), CraftingTableRecipes.getStack(ModItems.DIAMOND_DRILL, 1, Short.MAX_VALUE), Character.valueOf('C'), "circuitMaster", Character.valueOf('O'), CraftingTableRecipes.getMaterial("overclock", RecipeMethods.Type.UPGRADE));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.STEEL_CHAINSAW), " SS", "SCS", "BS ", Character.valueOf('S'), "ingotSteel", Character.valueOf('C'), "circuitBasic", Character.valueOf('B'), "reBattery");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.DIAMOND_CHAINSAW), " DD", "TCD", "ST ", Character.valueOf('D'), "gemDiamond", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('S'), CraftingTableRecipes.getStack(ModItems.STEEL_CHAINSAW, 1, Short.MAX_VALUE), Character.valueOf('T'), "ingotTitanium");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.ADVANCED_CHAINSAW), " NI", "OCN", "DO ", Character.valueOf('I'), "plateIridiumAlloy", Character.valueOf('N'), "nuggetIridium", Character.valueOf('D'), CraftingTableRecipes.getStack(ModItems.DIAMOND_CHAINSAW, 1, Short.MAX_VALUE), Character.valueOf('C'), "circuitMaster", Character.valueOf('O'), CraftingTableRecipes.getMaterial("overclock", RecipeMethods.Type.UPGRADE));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.STEEL_JACKHAMMER), "SBS", "SCS", " S ", Character.valueOf('S'), "ingotSteel", Character.valueOf('C'), "circuitBasic", Character.valueOf('B'), "reBattery");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.DIAMOND_JACKHAMMER), "DSD", "TCT", " D ", Character.valueOf('D'), "gemDiamond", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('S'), CraftingTableRecipes.getStack(ModItems.STEEL_JACKHAMMER, 1, Short.MAX_VALUE), Character.valueOf('T'), "ingotTitanium");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.ADVANCED_JACKHAMMER), "NDN", "OCO", " I ", Character.valueOf('I'), "plateIridiumAlloy", Character.valueOf('N'), "nuggetIridium", Character.valueOf('D'), CraftingTableRecipes.getStack(ModItems.DIAMOND_JACKHAMMER, 1, Short.MAX_VALUE), Character.valueOf('C'), "circuitMaster", Character.valueOf('O'), CraftingTableRecipes.getMaterial("overclock", RecipeMethods.Type.UPGRADE));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.CLOAKING_DEVICE), "CIC", "IOI", "CIC", Character.valueOf('C'), "ingotChrome", Character.valueOf('I'), "plateIridiumAlloy", Character.valueOf('O'), CraftingTableRecipes.getStack(ModItems.LAPOTRONIC_ORB));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.LAPOTRONIC_ORB_PACK), "FOF", "SPS", "FIF", Character.valueOf('F'), "circuitMaster", Character.valueOf('O'), CraftingTableRecipes.getStack(ModItems.LAPOTRONIC_ORB), Character.valueOf('S'), "craftingSuperconductor", Character.valueOf('I'), "ingotIridium", Character.valueOf('P'), CraftingTableRecipes.getStack(ModItems.LITHIUM_BATTERY_PACK));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.LITHIUM_BATTERY_PACK), "BCB", "BPB", "B B", Character.valueOf('B'), CraftingTableRecipes.getStack(ModItems.LITHIUM_BATTERY), Character.valueOf('P'), "plateAluminum", Character.valueOf('C'), "circuitAdvanced");
        if (ConfigTechReborn.enableGemArmorAndTools) {
            CraftingTableRecipes.addToolAndArmourRecipes(CraftingTableRecipes.getStack(ModItems.RUBY_SWORD), CraftingTableRecipes.getStack(ModItems.RUBY_PICKAXE), CraftingTableRecipes.getStack(ModItems.RUBY_AXE), CraftingTableRecipes.getStack(ModItems.RUBY_HOE), CraftingTableRecipes.getStack(ModItems.RUBY_SPADE), CraftingTableRecipes.getStack(ModItems.RUBY_HELMET), CraftingTableRecipes.getStack(ModItems.RUBY_CHESTPLATE), CraftingTableRecipes.getStack(ModItems.RUBY_LEGGINGS), CraftingTableRecipes.getStack(ModItems.RUBY_BOOTS), "gemRuby");
            CraftingTableRecipes.addToolAndArmourRecipes(CraftingTableRecipes.getStack(ModItems.SAPPHIRE_SWORD), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_PICKAXE), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_AXE), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_HOE), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_SPADE), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_HELMET), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_CHSTPLATE), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_LEGGINGS), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_BOOTS), "gemSapphire");
            CraftingTableRecipes.addToolAndArmourRecipes(CraftingTableRecipes.getStack(ModItems.PERIDOT_SWORD), CraftingTableRecipes.getStack(ModItems.PERIDOT_PICKAXE), CraftingTableRecipes.getStack(ModItems.PERIDOT_AXE), CraftingTableRecipes.getStack(ModItems.PERIDOT_HOE), CraftingTableRecipes.getStack(ModItems.PERIDOT_SAPPHIRE), CraftingTableRecipes.getStack(ModItems.PERIDOT_HELMET), CraftingTableRecipes.getStack(ModItems.PERIDOT_CHESTPLATE), CraftingTableRecipes.getStack(ModItems.PERIDOT_LEGGINGS), CraftingTableRecipes.getStack(ModItems.PERIDOT_BOOTS), "gemPeridot");
            CraftingTableRecipes.addToolAndArmourRecipes(CraftingTableRecipes.getStack(ModItems.BRONZE_SWORD), CraftingTableRecipes.getStack(ModItems.BRONZE_PICKAXE), CraftingTableRecipes.getStack(ModItems.BRONZE_AXE), CraftingTableRecipes.getStack(ModItems.BRONZE_HOE), CraftingTableRecipes.getStack(ModItems.BRONZE_SPADE), CraftingTableRecipes.getStack(ModItems.BRONZE_HELMET), CraftingTableRecipes.getStack(ModItems.BRONZE_CHESTPLATE), CraftingTableRecipes.getStack(ModItems.BRONZE_LEGGINGS), CraftingTableRecipes.getStack(ModItems.BRONZE_BOOTS), "ingotBronze");
        }
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.LAPOTRONIC_ORB), "LLL", "LPL", "LLL", Character.valueOf('L'), "lapotronCrystal", Character.valueOf('P'), "plateIridiumAlloy");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.LITHIUM_BATTERY), " C ", "PFP", "PFP", Character.valueOf('F'), CraftingTableRecipes.getCell("lithium"), Character.valueOf('P'), "plateAluminum", Character.valueOf('C'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_IGOLD));
        if (!IC2Duplicates.deduplicate()) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.ENERGY_CRYSTAL), "RRR", "RDR", "RRR", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.LAPOTRONIC_CRYSTAL), "LCL", "LEL", "LCL", Character.valueOf('L'), CraftingTableRecipes.getStack(Items.field_151100_aR, 1, 4), Character.valueOf('E'), "energyCrystal", Character.valueOf('C'), "circuitBasic");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.RE_BATTERY), " W ", "TRT", "TRT", Character.valueOf('T'), "ingotTin", Character.valueOf('R'), "dustRedstone", Character.valueOf('W'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_ICOPPER));
        }
        CraftingTableRecipes.registerShaped(ItemUpgrades.getUpgradeByName("energy_storage"), "PPP", "WBW", "PCP", Character.valueOf('P'), "plankWood", Character.valueOf('W'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_ICOPPER), Character.valueOf('C'), "circuitBasic", Character.valueOf('B'), "reBattery");
        CraftingTableRecipes.registerShaped(ItemUpgrades.getUpgradeByName("overclock"), "TTT", "WCW", Character.valueOf('T'), CraftingTableRecipes.getMaterial("coolant_simple", RecipeMethods.Type.PART), Character.valueOf('W'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_ICOPPER), Character.valueOf('C'), "circuitBasic");
        CraftingTableRecipes.registerShaped(ItemUpgrades.getUpgradeByName("overclock", 2), " T ", "WCW", Character.valueOf('T'), CraftingTableRecipes.getMaterial("helium_coolant_triple", RecipeMethods.Type.PART), Character.valueOf('W'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_ICOPPER), Character.valueOf('C'), "circuitBasic");
        CraftingTableRecipes.registerShaped(ItemUpgrades.getUpgradeByName("overclock", 2), " T ", "WCW", Character.valueOf('T'), CraftingTableRecipes.getMaterial("nak_coolant_simple", RecipeMethods.Type.PART), Character.valueOf('W'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_ICOPPER), Character.valueOf('C'), "circuitBasic");
        CraftingTableRecipes.registerShaped(ItemUpgrades.getUpgradeByName("transformer"), "GGG", "WTW", "GCG", Character.valueOf('G'), "blockGlass", Character.valueOf('W'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_IGOLD), Character.valueOf('C'), "circuitBasic", Character.valueOf('T'), CraftingTableRecipes.getStack(IC2Duplicates.MVT));
        CraftingTableRecipes.registerShaped(ItemUpgrades.getUpgradeByName("superconductor"), "SOS", "CMC", "SOS", Character.valueOf('C'), EnumCableType.SUPERCONDUCTOR.getStack(), Character.valueOf('M'), CraftingTableRecipes.getMaterial("highly_advanced_machine", RecipeMethods.Type.MACHINE_FRAME), Character.valueOf('O'), CraftingTableRecipes.getMaterial("data_orb", RecipeMethods.Type.PART), Character.valueOf('S'), CraftingTableRecipes.getMaterial("enhanced_super_conductor", RecipeMethods.Type.PART));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("standard", 4, RecipeMethods.Type.MACHINE_CASING), "RRR", "CAC", "RRR", Character.valueOf('R'), "ingotRefinedIron", Character.valueOf('C'), "circuitBasic", Character.valueOf('A'), "machineBlockBasic");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("standard", 4, RecipeMethods.Type.MACHINE_CASING), "RRR", "CAC", "RRR", Character.valueOf('R'), "plateIron", Character.valueOf('C'), "circuitBasic", Character.valueOf('A'), "machineBlockBasic");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("standard", 4, RecipeMethods.Type.MACHINE_CASING), "RRR", "CAC", "RRR", Character.valueOf('R'), "plateAluminum", Character.valueOf('C'), "circuitBasic", Character.valueOf('A'), "machineBlockBasic");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("reinforced", 4, RecipeMethods.Type.MACHINE_CASING), "RRR", "CAC", "RRR", Character.valueOf('R'), "plateSteel", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('A'), "machineBlockAdvanced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("reinforced", 1, RecipeMethods.Type.MACHINE_CASING), "RRR", "CAC", "RRR", Character.valueOf('R'), "plateSteel", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('A'), CraftingTableRecipes.getMaterial("standard", RecipeMethods.Type.MACHINE_CASING));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("advanced", 4, RecipeMethods.Type.MACHINE_CASING), "RRR", "CAC", "RRR", Character.valueOf('R'), "plateChrome", Character.valueOf('C'), "circuitElite", Character.valueOf('A'), "machineBlockElite");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("advanced", 1, RecipeMethods.Type.MACHINE_CASING), "RRR", "CAC", "RRR", Character.valueOf('R'), "plateChrome", Character.valueOf('C'), "circuitElite", Character.valueOf('A'), CraftingTableRecipes.getMaterial("reinforced", RecipeMethods.Type.MACHINE_CASING));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.WIND_MILL), " I ", " G ", " I ", Character.valueOf('I'), "plateMagnalium", Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.GENERATOR));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.WIND_MILL), "IGI", Character.valueOf('I'), "plateMagnalium", Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.GENERATOR));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.LIGHTNING_ROD), "CAC", "ACA", "CAC", Character.valueOf('A'), CraftingTableRecipes.getStack(ModBlocks.MACHINE_CASINGS, 1, 2), Character.valueOf('C'), "circuitMaster");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.IRON_ALLOY_FURNACE), "III", "F F", "III", Character.valueOf('I'), "ingotRefinedIron", Character.valueOf('F'), CraftingTableRecipes.getStack(IC2Duplicates.IRON_FURNACE));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.INDUSTRIAL_ELECTROLYZER), "RER", "CFC", "RER", Character.valueOf('R'), "plateIron", Character.valueOf('E'), CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR), Character.valueOf('C'), "circuitAdvanced", Character.valueOf('F'), "machineBlockAdvanced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.INDUSTRIAL_CENTRIFUGE), "RCR", "AEA", "RCR", Character.valueOf('R'), "ingotRefinedIron", Character.valueOf('E'), CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR), Character.valueOf('A'), "machineBlockAdvanced", Character.valueOf('C'), "circuitAdvanced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.INDUSTRIAL_CENTRIFUGE), "RCR", "AEA", "RCR", Character.valueOf('R'), "plateAluminum", Character.valueOf('E'), CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR), Character.valueOf('A'), "machineBlockAdvanced", Character.valueOf('C'), "circuitAdvanced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.INDUSTRIAL_SAWMILL), "PAP", "SSS", "ACA", Character.valueOf('P'), "ingotRefinedIron", Character.valueOf('A'), "circuitAdvanced", Character.valueOf('S'), CraftingTableRecipes.getMaterial("diamond_saw_blade", RecipeMethods.Type.PART), Character.valueOf('C'), "machineBlockAdvanced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.INDUSTRIAL_BLAST_FURNACE), "CHC", "HBH", "FHF", Character.valueOf('H'), CraftingTableRecipes.getMaterial("cupronickelHeatingCoil", RecipeMethods.Type.PART), Character.valueOf('C'), "circuitAdvanced", Character.valueOf('B'), "machineBlockAdvanced", Character.valueOf('F'), CraftingTableRecipes.getStack(IC2Duplicates.ELECTRICAL_FURNACE));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.INDUSTRIAL_GRINDER), "ECG", "HHH", "CBC", Character.valueOf('E'), CraftingTableRecipes.getStack(ModBlocks.INDUSTRIAL_ELECTROLYZER), Character.valueOf('H'), "craftingDiamondGrinder", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('B'), "machineBlockAdvanced", Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.GRINDER));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.IMPLOSION_COMPRESSOR), "ABA", "CPC", "ABA", Character.valueOf('A'), CraftingTableRecipes.getMaterialObject("advancedAlloy", RecipeMethods.Type.INGOT), Character.valueOf('C'), "circuitAdvanced", Character.valueOf('B'), "machineBlockAdvanced", Character.valueOf('P'), CraftingTableRecipes.getStack(IC2Duplicates.COMPRESSOR));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.VACUUM_FREEZER), "SPS", "CGC", "SPS", Character.valueOf('S'), "plateSteel", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('G'), "glassReinforced", Character.valueOf('P'), CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.DISTILLATION_TOWER), "CMC", "PBP", "EME", Character.valueOf('E'), CraftingTableRecipes.getStack(ModBlocks.INDUSTRIAL_ELECTROLYZER), Character.valueOf('M'), "circuitMaster", Character.valueOf('B'), "machineBlockElite", Character.valueOf('C'), CraftingTableRecipes.getStack(ModBlocks.INDUSTRIAL_CENTRIFUGE), Character.valueOf('P'), CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.PLATE_BENDING_MACHINE), "PCP", "MBM", "PCP", Character.valueOf('P'), CraftingTableRecipes.getStack((Block)Blocks.field_150331_J), Character.valueOf('C'), "circuitBasic", Character.valueOf('M'), CraftingTableRecipes.getStack(IC2Duplicates.COMPRESSOR), Character.valueOf('B'), "machineBlockBasic");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.PLATE_BENDING_MACHINE), "PCP", "MBM", "PCP", Character.valueOf('P'), CraftingTableRecipes.getStack((Block)Blocks.field_150320_F), Character.valueOf('C'), "circuitBasic", Character.valueOf('M'), CraftingTableRecipes.getStack(IC2Duplicates.COMPRESSOR), Character.valueOf('B'), "machineBlockBasic");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.ASSEMBLING_MACHINE), "CIC", "PBP", "CPC", Character.valueOf('I'), CraftingTableRecipes.getStack((Block)Blocks.field_150331_J), Character.valueOf('P'), "plateRefinedIron", Character.valueOf('C'), "circuitBasic", Character.valueOf('B'), "machineBlockBasic");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.ASSEMBLING_MACHINE), "CIC", "PBP", "CPC", Character.valueOf('I'), CraftingTableRecipes.getStack((Block)Blocks.field_150331_J), Character.valueOf('P'), "plateAluminum", Character.valueOf('C'), "circuitBasic", Character.valueOf('B'), "machineBlockBasic");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.WIRE_MILL), "PEP", "CBC", "PSP", Character.valueOf('P'), "plateBrass", Character.valueOf('C'), "circuitBasic", Character.valueOf('E'), CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR), Character.valueOf('B'), "machineBlockBasic", Character.valueOf('S'), CraftingTableRecipes.getStack((Block)Blocks.field_150331_J));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.WIRE_MILL), "PEP", "CBC", "PSP", Character.valueOf('P'), "plateBrass", Character.valueOf('C'), "circuitBasic", Character.valueOf('E'), CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR), Character.valueOf('B'), "machineBlockBasic", Character.valueOf('S'), CraftingTableRecipes.getStack((Block)Blocks.field_150320_F));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.CHEMICAL_REACTOR), "IMI", "CPC", "IEI", Character.valueOf('I'), "plateInvar", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('M'), CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR), Character.valueOf('P'), CraftingTableRecipes.getStack(IC2Duplicates.COMPRESSOR), Character.valueOf('E'), CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.ROLLING_MACHINE), "PCP", "MBM", "PCP", Character.valueOf('P'), CraftingTableRecipes.getStack((Block)Blocks.field_150331_J), Character.valueOf('C'), "circuitAdvanced", Character.valueOf('M'), CraftingTableRecipes.getStack(IC2Duplicates.COMPRESSOR), Character.valueOf('B'), "machineBlockBasic");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.AUTO_CRAFTING_TABLE), "MPM", "PCP", "MPM", Character.valueOf('M'), "circuitAdvanced", Character.valueOf('C'), "workbench", Character.valueOf('P'), "plateIron");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.CHARGE_O_MAT), "ETE", "COC", "EAE", Character.valueOf('E'), "circuitMaster", Character.valueOf('T'), "energyCrystal", Character.valueOf('C'), "chest", Character.valueOf('O'), CraftingTableRecipes.getStack(ModItems.LAPOTRONIC_ORB), Character.valueOf('A'), "machineBlockAdvanced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.ALLOY_SMELTER), " C ", "FMF", "   ", Character.valueOf('C'), "circuitBasic", Character.valueOf('F'), CraftingTableRecipes.getStack(IC2Duplicates.ELECTRICAL_FURNACE), Character.valueOf('M'), "machineBlockBasic");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.INTERDIMENSIONAL_SU), "PAP", "ACA", "PAP", Character.valueOf('P'), "plateIridiumAlloy", Character.valueOf('C'), "chestEnder", Character.valueOf('A'), CraftingTableRecipes.getStack(ModBlocks.ADJUSTABLE_SU));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.ADJUSTABLE_SU), "LLL", "LCL", "LLL", Character.valueOf('L'), CraftingTableRecipes.getStack(ModItems.LAPOTRONIC_ORB), Character.valueOf('C'), "energyCrystal");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.LAPOTRONIC_SU), " L ", "CBC", " M ", Character.valueOf('L'), CraftingTableRecipes.getStack(IC2Duplicates.LVT), Character.valueOf('C'), "circuitAdvanced", Character.valueOf('M'), CraftingTableRecipes.getStack(IC2Duplicates.MVT), Character.valueOf('B'), CraftingTableRecipes.getStack(ModBlocks.LSU_STORAGE));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.LSU_STORAGE), "LLL", "LCL", "LLL", Character.valueOf('L'), "blockLapis", Character.valueOf('C'), "circuitBasic");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.SCRAPBOXINATOR), "ICI", "DSD", "ICI", Character.valueOf('S'), CraftingTableRecipes.getStack(ModItems.SCRAP_BOX), Character.valueOf('C'), "circuitBasic", Character.valueOf('I'), "plateIron", Character.valueOf('D'), "dirt");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.FUSION_CONTROL_COMPUTER), "CCC", "PTP", "CCC", Character.valueOf('P'), "energyCrystal", Character.valueOf('T'), CraftingTableRecipes.getStack(ModBlocks.FUSION_COIL), Character.valueOf('C'), "circuitMaster");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.DIGITAL_CHEST), "PPP", "PDP", "PCP", Character.valueOf('P'), "plateAluminum", Character.valueOf('D'), CraftingTableRecipes.getMaterial("data_orb", RecipeMethods.Type.PART), Character.valueOf('C'), CraftingTableRecipes.getMaterial("computer_monitor", RecipeMethods.Type.PART));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.DIGITAL_CHEST), "PPP", "PDP", "PCP", Character.valueOf('P'), "plateSteel", Character.valueOf('D'), CraftingTableRecipes.getMaterial("data_orb", RecipeMethods.Type.PART), Character.valueOf('C'), CraftingTableRecipes.getMaterial("computer_monitor", RecipeMethods.Type.PART));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.MATTER_FABRICATOR), "ETE", "AOA", "ETE", Character.valueOf('E'), "circuitMaster", Character.valueOf('T'), CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR), Character.valueOf('A'), "machineBlockElite", Character.valueOf('O'), CraftingTableRecipes.getStack(ModItems.LAPOTRONIC_ORB));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.COMPUTER_CUBE), "OMC", "MFM", "CMO", Character.valueOf('O'), CraftingTableRecipes.getMaterial("data_orb", RecipeMethods.Type.PART), Character.valueOf('M'), CraftingTableRecipes.getMaterial("computer_monitor", RecipeMethods.Type.PART), Character.valueOf('C'), "circuitMaster", Character.valueOf('F'), "machineBlockAdvanced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.PLAYER_DETECTOR, true), " D ", "CFC", " D ", Character.valueOf('D'), "circuitStorage", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('F'), CraftingTableRecipes.getStack(ModBlocks.COMPUTER_CUBE));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.DRAGON_EGG_SYPHON), "CTC", "PSP", "CBC", Character.valueOf('C'), "circuitMaster", Character.valueOf('T'), CraftingTableRecipes.getStack(IC2Duplicates.MFE), Character.valueOf('P'), "plateIridiumAlloy", Character.valueOf('S'), "craftingSuperconductor", Character.valueOf('B'), CraftingTableRecipes.getStack(ModItems.LAPOTRONIC_ORB));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.PLASMA_GENERATOR), "PPP", "PTP", "CGC", Character.valueOf('P'), "plateTungstensteel", Character.valueOf('T'), CraftingTableRecipes.getStack(IC2Duplicates.HVT), Character.valueOf('C'), "circuitMaster", Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.GENERATOR));
        if (!IC2Duplicates.deduplicate()) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.LVT), "PWP", "CCC", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('C'), "ingotCopper", Character.valueOf('W'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_TIN));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.MVT), " G ", " M ", " G ", Character.valueOf('M'), "machineBlockBasic", Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_ICOPPER));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.HVT), " H ", "CML", " H ", Character.valueOf('M'), CraftingTableRecipes.getStack(IC2Duplicates.MVT), Character.valueOf('H'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_GOLD), Character.valueOf('C'), "circuitBasic", Character.valueOf('L'), CraftingTableRecipes.getStack(ModItems.LITHIUM_BATTERY));
        }
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.EV_TRANSFORMER), " H ", "CML", " H ", Character.valueOf('M'), CraftingTableRecipes.getStack(IC2Duplicates.HVT), Character.valueOf('H'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_IHV), Character.valueOf('C'), "circuitAdvanced", Character.valueOf('L'), CraftingTableRecipes.getStack(IC2Duplicates.ENERGY_CRYSTAL));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.SOLAR_PANEL, 1, 0), "DLD", "LDL", "CGC", Character.valueOf('D'), "dustCoal", Character.valueOf('L'), "paneGlass", Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.GENERATOR), Character.valueOf('C'), "circuitBasic");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.SOLAR_PANEL, 1, 1), "SSS", "STS", "SSS", Character.valueOf('S'), CraftingTableRecipes.getStack(ModBlocks.SOLAR_PANEL, 1, 0), Character.valueOf('T'), CraftingTableRecipes.getStack(ModBlocks.LV_TRANSFORMER));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.SOLAR_PANEL, 1, 2), "SSS", "STS", "SSS", Character.valueOf('S'), CraftingTableRecipes.getStack(ModBlocks.SOLAR_PANEL, 1, 1), Character.valueOf('T'), CraftingTableRecipes.getStack(ModBlocks.MV_TRANSFORMER));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.SOLAR_PANEL, 1, 3), "SSS", "STS", "SSS", Character.valueOf('S'), CraftingTableRecipes.getStack(ModBlocks.SOLAR_PANEL, 1, 2), Character.valueOf('T'), CraftingTableRecipes.getStack(ModBlocks.HV_TRANSFORMER));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.SOLAR_PANEL, 1, 4), "SSS", "STS", "SSS", Character.valueOf('S'), CraftingTableRecipes.getStack(ModBlocks.SOLAR_PANEL, 1, 3), Character.valueOf('T'), CraftingTableRecipes.getStack(ModBlocks.EV_TRANSFORMER));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.DIESEL_GENERATOR), "III", "IHI", "CGC", Character.valueOf('I'), "plateBronze", Character.valueOf('H'), "glassReinforced", Character.valueOf('C'), "circuitBasic", Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.GENERATOR));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.DIESEL_GENERATOR), "III", "IHI", "CGC", Character.valueOf('I'), "plateBrass", Character.valueOf('H'), "glassReinforced", Character.valueOf('C'), "circuitBasic", Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.GENERATOR));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.SEMI_FLUID_GENERATOR), "III", "IHI", "CGC", Character.valueOf('I'), "plateRefinedIron", Character.valueOf('H'), "glassReinforced", Character.valueOf('C'), "circuitBasic", Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.GENERATOR));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.SEMI_FLUID_GENERATOR), "III", "IHI", "CGC", Character.valueOf('I'), "plateAluminum", Character.valueOf('H'), "glassReinforced", Character.valueOf('C'), "circuitBasic", Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.GENERATOR));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.GAS_TURBINE), "IAI", "WGW", "IAI", Character.valueOf('I'), "plateInvar", Character.valueOf('A'), "circuitAdvanced", Character.valueOf('W'), CraftingTableRecipes.getStack(ModBlocks.WIND_MILL), Character.valueOf('G'), "glassReinforced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.GAS_TURBINE), "IAI", "WGW", "IAI", Character.valueOf('I'), "plateAluminum", Character.valueOf('A'), "circuitAdvanced", Character.valueOf('W'), CraftingTableRecipes.getStack(ModBlocks.WIND_MILL), Character.valueOf('G'), "glassReinforced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.GAS_TURBINE), "IAI", "WGW", "IAI", Character.valueOf('I'), "plateAluminum", Character.valueOf('A'), "circuitAdvanced", Character.valueOf('W'), CraftingTableRecipes.getStack(ModBlocks.WIND_MILL), Character.valueOf('G'), "glassReinforced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.THERMAL_GENERATOR), "III", "IHI", "CGC", Character.valueOf('I'), "plateInvar", Character.valueOf('H'), "glassReinforced", Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.GENERATOR), Character.valueOf('C'), "circuitBasic");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.SOLID_CANNING_MACHINE), "TCT", "TBT", "TTT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), "circuitBasic", Character.valueOf('B'), "machineBlockBasic");
        if (Loader.isModLoaded((String)"ic2")) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.THORIUM_FUEL_ROD_DUAL), "RPR", "   ", "   ", Character.valueOf('R'), CraftingTableRecipes.getStack(ModItems.THORIUM_FUEL_ROD_SINGLE), Character.valueOf('P'), "plateCopper");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.THORIUM_FUEL_ROD_DUAL), "RPR", "   ", "   ", Character.valueOf('R'), CraftingTableRecipes.getStack(ModItems.THORIUM_FUEL_ROD_SINGLE), Character.valueOf('P'), "plateLead");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.THORIUM_FUEL_ROD_QUAD), " R ", "PPP", " R ", Character.valueOf('R'), CraftingTableRecipes.getStack(ModItems.THORIUM_FUEL_ROD_DUAL), Character.valueOf('P'), "plateCopper");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.THORIUM_FUEL_ROD_QUAD), " R ", "PPP", " R ", Character.valueOf('R'), CraftingTableRecipes.getStack(ModItems.THORIUM_FUEL_ROD_DUAL), Character.valueOf('P'), "plateLead");
        }
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.ALARM, 1, 0), "ICI", "SRS", "ICI", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), CraftingTableRecipes.getMaterial("copper", RecipeMethods.Type.CABLE), Character.valueOf('S'), IC2Duplicates.CABLE_ICOPPER.getStackBasedOnConfig(), Character.valueOf('R'), "blockRedstone");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.FLUID_REPLICATOR), "PCP", "CFC", "ESR", Character.valueOf('P'), "plateTungstensteel", Character.valueOf('F'), "machineBlockElite", Character.valueOf('C'), "circuitMaster", Character.valueOf('E'), CraftingTableRecipes.getStack(ModBlocks.INDUSTRIAL_ELECTROLYZER), Character.valueOf('S'), "craftingSuperconductor", Character.valueOf('R'), CraftingTableRecipes.getStack(ModBlocks.CHEMICAL_REACTOR));
        if (!IC2Duplicates.deduplicate()) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.BAT_BOX), "WCW", "BBB", "WWW", Character.valueOf('W'), "plankWood", Character.valueOf('B'), "reBattery", Character.valueOf('C'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_ICOPPER));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.MFE), "GEG", "EME", "GEG", Character.valueOf('M'), "machineBlockBasic", Character.valueOf('E'), "energyCrystal", Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_IGOLD));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.MFSU), "LAL", "LML", "LOL", Character.valueOf('A'), "circuitAdvanced", Character.valueOf('L'), "lapotronCrystal", Character.valueOf('M'), CraftingTableRecipes.getStack(IC2Duplicates.MFE), Character.valueOf('O'), "machineBlockAdvanced");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.COMPRESSOR), "S S", "SCS", "SMS", Character.valueOf('C'), "circuitBasic", Character.valueOf('M'), "machineBlockBasic", Character.valueOf('S'), "stone");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.ELECTRICAL_FURNACE), " C ", "RFR", "   ", Character.valueOf('C'), "circuitBasic", Character.valueOf('F'), CraftingTableRecipes.getStack(IC2Duplicates.IRON_FURNACE), Character.valueOf('R'), "dustRedstone");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.RECYCLER), " E ", "DCD", "GDG", Character.valueOf('D'), "dirt", Character.valueOf('C'), CraftingTableRecipes.getStack(IC2Duplicates.COMPRESSOR), Character.valueOf('G'), "dustGlowstone", Character.valueOf('E'), "circuitBasic");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.IRON_FURNACE), "III", "I I", "III", Character.valueOf('I'), "ingotIron");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.IRON_FURNACE), " I ", "I I", "IFI", Character.valueOf('I'), "ingotIron", Character.valueOf('F'), CraftingTableRecipes.getStack(Blocks.field_150460_al));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR), "TMT", "TCT", "   ", Character.valueOf('T'), CraftingTableRecipes.getStack(ModItems.TREE_TAP, true), Character.valueOf('M'), "machineBlockBasic", Character.valueOf('C'), "circuitBasic");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.GRINDER), "FFF", "SMS", " C ", Character.valueOf('F'), Items.field_151145_ak, Character.valueOf('S'), CraftingTableRecipes.getStack(Blocks.field_150347_e), Character.valueOf('M'), CraftingTableRecipes.getMaterial("machine", RecipeMethods.Type.MACHINE_FRAME), Character.valueOf('C'), "circuitBasic");
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getStack(IC2Duplicates.FREQ_TRANSMITTER), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_ICOPPER), "circuitBasic");
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getStack(IC2Duplicates.GENERATOR), "reBattery", "machineBlockBasic", CraftingTableRecipes.getStack(Blocks.field_150460_al));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.WATER_MILL), "SWS", "WGW", "SWS", Character.valueOf('S'), "stickWood", Character.valueOf('W'), "plankWood", Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.GENERATOR));
        }
        CraftingTableRecipes.registerShaped(EnumCableType.SUPERCONDUCTOR.getStack(), "MFM", "SSS", "MFM", Character.valueOf('M'), CraftingTableRecipes.getMaterial("advanced_machine", RecipeMethods.Type.MACHINE_FRAME), Character.valueOf('S'), "craftingSuperconductor", Character.valueOf('F'), CraftingTableRecipes.getMaterial("energy_flow_circuit", 1, RecipeMethods.Type.PART));
        CraftingTableRecipes.registerShaped(EnumCableType.SUPERCONDUCTOR.getStack(8), "MFM", "SSS", "MFM", Character.valueOf('M'), CraftingTableRecipes.getMaterial("advanced_machine", RecipeMethods.Type.MACHINE_FRAME), Character.valueOf('S'), CraftingTableRecipes.getMaterial("enhanced_super_conductor", RecipeMethods.Type.PART), Character.valueOf('F'), CraftingTableRecipes.getMaterial("energy_flow_circuit", 1, RecipeMethods.Type.PART));
        if (!IC2Duplicates.deduplicate()) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("copper", 6, RecipeMethods.Type.CABLE), "CCC", Character.valueOf('C'), "ingotCopper");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("tin", 9, RecipeMethods.Type.CABLE), "TTT", Character.valueOf('T'), "ingotTin");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("gold", 12, RecipeMethods.Type.CABLE), "GGG", Character.valueOf('G'), "ingotGold");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("hv", 12, RecipeMethods.Type.CABLE), "RRR", Character.valueOf('R'), "ingotRefinedIron");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("insulatedcopper", 6, RecipeMethods.Type.CABLE), "RRR", "CCC", "RRR", Character.valueOf('R'), "itemRubber", Character.valueOf('C'), "ingotCopper");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("insulatedcopper", 6, RecipeMethods.Type.CABLE), "RCR", "RCR", "RCR", Character.valueOf('R'), "itemRubber", Character.valueOf('C'), "ingotCopper");
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial("insulatedcopper", RecipeMethods.Type.CABLE), "itemRubber", CraftingTableRecipes.getMaterial("copper", RecipeMethods.Type.CABLE));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("insulatedgold", 4, RecipeMethods.Type.CABLE), "RRR", "RGR", "RRR", Character.valueOf('R'), "itemRubber", Character.valueOf('G'), "ingotGold");
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial("insulatedgold", RecipeMethods.Type.CABLE), "itemRubber", "itemRubber", CraftingTableRecipes.getMaterial("gold", RecipeMethods.Type.CABLE));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("insulatedhv", 4, RecipeMethods.Type.CABLE), "RRR", "RIR", "RRR", Character.valueOf('R'), "itemRubber", Character.valueOf('I'), "ingotRefinedIron");
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial("insulatedhv", RecipeMethods.Type.CABLE), "itemRubber", "itemRubber", CraftingTableRecipes.getMaterial("hv", RecipeMethods.Type.CABLE));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 4, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond", Character.valueOf('G'), "blockGlass");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 4, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "dustDiamond", Character.valueOf('G'), "blockGlass");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 3, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemRuby", Character.valueOf('G'), "blockGlass");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 3, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "dustRuby", Character.valueOf('G'), "blockGlass");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 6, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "ingotSilver", Character.valueOf('D'), "gemDiamond", Character.valueOf('G'), "blockGlass");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 6, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "ingotSilver", Character.valueOf('D'), "dustDiamond", Character.valueOf('G'), "blockGlass");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 8, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "ingotElectrum", Character.valueOf('D'), "gemDiamond", Character.valueOf('G'), "blockGlass");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 8, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "ingotElectrum", Character.valueOf('D'), "dustDiamond", Character.valueOf('G'), "blockGlass");
        }
        if (!CompatManager.isQuantumStorageLoaded) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.QUANTUM_CHEST), "DCD", "ATA", "DQD", Character.valueOf('D'), CraftingTableRecipes.getMaterial("dataOrb", RecipeMethods.Type.PART), Character.valueOf('C'), CraftingTableRecipes.getMaterial("computerMonitor", RecipeMethods.Type.PART), Character.valueOf('A'), "machineBlockElite", Character.valueOf('Q'), CraftingTableRecipes.getStack(ModBlocks.DIGITAL_CHEST), Character.valueOf('T'), CraftingTableRecipes.getStack(IC2Duplicates.COMPRESSOR));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.QUANTUM_TANK), "EPE", "PCP", "EPE", Character.valueOf('P'), "platePlatinum", Character.valueOf('E'), "circuitAdvanced", Character.valueOf('C'), CraftingTableRecipes.getStack(ModBlocks.QUANTUM_CHEST));
        }
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.LAMP_INCANDESCENT), "GGG", "TCT", "GGG", Character.valueOf('G'), "paneGlass", Character.valueOf('T'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_COPPER), Character.valueOf('C'), CraftingTableRecipes.getMaterial("carbon_fiber", RecipeMethods.Type.PART));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.LAMP_LED), "GGG", "TLT", "GGG", Character.valueOf('G'), "paneGlass", Character.valueOf('T'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_TIN), Character.valueOf('L'), "dustGlowstone");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("iridium_alloy", RecipeMethods.Type.INGOT), "IAI", "ADA", "IAI", Character.valueOf('I'), "ingotIridium", Character.valueOf('D'), "dustDiamond", Character.valueOf('A'), "plateAdvancedAlloy");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.SCRAP_BOX), "SSS", "SSS", "SSS", Character.valueOf('S'), CraftingTableRecipes.getMaterial("scrap", RecipeMethods.Type.PART));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("machine", RecipeMethods.Type.MACHINE_FRAME), "AAA", "A A", "AAA", Character.valueOf('A'), "ingotRefinedIron");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("advanced_machine", RecipeMethods.Type.MACHINE_FRAME), " C ", "AMA", " C ", Character.valueOf('A'), "plateAdvancedAlloy", Character.valueOf('C'), "plateCarbon", Character.valueOf('M'), "machineBlockBasic");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("highly_advanced_machine", RecipeMethods.Type.MACHINE_FRAME), "CTC", "TBT", "CTC", Character.valueOf('C'), "plateChrome", Character.valueOf('T'), "plateTitanium", Character.valueOf('B'), "machineBlockAdvanced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("data_storage_circuit", RecipeMethods.Type.PART), "RGR", "LCL", "EEE", Character.valueOf('R'), "dustRedstone", Character.valueOf('G'), "dustGlowstone", Character.valueOf('L'), "gemLapis", Character.valueOf('C'), "circuitBasic", Character.valueOf('E'), "plateEmerald");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("data_control_circuit", RecipeMethods.Type.PART), "ADA", "DID", "ADA", Character.valueOf('I'), "ingotIridium", Character.valueOf('A'), "circuitAdvanced", Character.valueOf('D'), "circuitStorage");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("energy_flow_circuit", 4, RecipeMethods.Type.PART), "ATA", "LIL", "ATA", Character.valueOf('T'), "ingotTungsten", Character.valueOf('I'), "plateIridiumAlloy", Character.valueOf('A'), "circuitAdvanced", Character.valueOf('L'), "lapotronCrystal");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("data_orb", RecipeMethods.Type.PART), "DDD", "DSD", "DDD", Character.valueOf('D'), "circuitStorage", Character.valueOf('S'), "circuitElite");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("diamond_saw_blade", 4, RecipeMethods.Type.PART), "DSD", "S S", "DSD", Character.valueOf('D'), "dustDiamond", Character.valueOf('S'), "ingotSteel");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("diamond_grinding_head", 2, RecipeMethods.Type.PART), "DSD", "SGS", "DSD", Character.valueOf('S'), "ingotSteel", Character.valueOf('D'), "dustDiamond", Character.valueOf('G'), "gemDiamond");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("tungsten_grinding_head", 2, RecipeMethods.Type.PART), "TST", "SBS", "TST", Character.valueOf('S'), "ingotSteel", Character.valueOf('T'), "ingotTungsten", Character.valueOf('B'), "blockSteel");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("computer_monitor", RecipeMethods.Type.PART), "ADA", "DGD", "ADA", Character.valueOf('D'), "dye", Character.valueOf('A'), "ingotAluminum", Character.valueOf('G'), "paneGlass");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("coolant_simple", 2, RecipeMethods.Type.PART), " T ", "TWT", " T ", Character.valueOf('T'), "ingotTin", Character.valueOf('W'), CraftingTableRecipes.getStack(Items.field_151131_as));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("coolant_simple", 2, RecipeMethods.Type.PART), " T ", "TWT", " T ", Character.valueOf('T'), "ingotTin", Character.valueOf('W'), CraftingTableRecipes.getCell("water"));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("coolant_triple", RecipeMethods.Type.PART), "TTT", "CCC", "TTT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), CraftingTableRecipes.getMaterial("coolant_simple", RecipeMethods.Type.PART));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("coolant_six", RecipeMethods.Type.PART), "TCT", "TPT", "TCT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), CraftingTableRecipes.getMaterial("coolant_triple", RecipeMethods.Type.PART), Character.valueOf('P'), "plateCopper");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("helium_coolant_simple", RecipeMethods.Type.PART), " T ", "TCT", " T ", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), CraftingTableRecipes.getCell("helium"));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("helium_coolant_triple", RecipeMethods.Type.PART), "TTT", "CCC", "TTT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), CraftingTableRecipes.getMaterial("helium_coolant_simple", RecipeMethods.Type.PART));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("helium_coolant_six", RecipeMethods.Type.PART), "THT", "TCT", "THT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), "ingotCopper", Character.valueOf('H'), CraftingTableRecipes.getMaterial("helium_coolant_triple", RecipeMethods.Type.PART));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("nak_coolant_simple", RecipeMethods.Type.PART), "TST", "PCP", "TST", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), CraftingTableRecipes.getMaterial("coolant_simple", RecipeMethods.Type.PART), Character.valueOf('S'), CraftingTableRecipes.getCell("sodium"), Character.valueOf('P'), CraftingTableRecipes.getCell("potassium"));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("nak_coolant_simple", RecipeMethods.Type.PART), "TPT", "SCS", "TPT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), CraftingTableRecipes.getMaterial("coolant_simple", RecipeMethods.Type.PART), Character.valueOf('S'), CraftingTableRecipes.getCell("sodium"), Character.valueOf('P'), CraftingTableRecipes.getCell("potassium"));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("nak_coolant_triple", RecipeMethods.Type.PART), "TTT", "CCC", "TTT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), CraftingTableRecipes.getMaterial("nak_coolant_simple", RecipeMethods.Type.PART));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("nak_coolant_six", RecipeMethods.Type.PART), "THT", "TCT", "THT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), "ingotCopper", Character.valueOf('H'), CraftingTableRecipes.getMaterial("nak_coolant_triple", RecipeMethods.Type.PART));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("super_conductor", 4, RecipeMethods.Type.PART), "CCC", "TIT", "EEE", Character.valueOf('E'), "circuitMaster", Character.valueOf('C'), CraftingTableRecipes.getMaterial("heliumCoolantSimple", RecipeMethods.Type.PART), Character.valueOf('T'), "ingotTungsten", Character.valueOf('I'), "plateIridiumAlloy");
        if (!IC2Duplicates.deduplicate()) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("carbon_fiber", RecipeMethods.Type.PART), " C ", "C C", " C ", Character.valueOf('C'), "dustCoal");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("carbon_fiber", RecipeMethods.Type.PART), "CCC", "C C", "CCC", Character.valueOf('C'), CraftingTableRecipes.getCell("carbon"));
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial("carbon_mesh", RecipeMethods.Type.PART), CraftingTableRecipes.getMaterial("carbon_fiber", RecipeMethods.Type.PART), CraftingTableRecipes.getMaterial("carbon_fiber", RecipeMethods.Type.PART));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("electronic_circuit", RecipeMethods.Type.PART), "WWW", "SRS", "WWW", Character.valueOf('R'), "ingotRefinedIron", Character.valueOf('S'), Items.field_151137_ax, Character.valueOf('W'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_ICOPPER));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("advanced_circuit", RecipeMethods.Type.PART), "RGR", "LCL", "RGR", Character.valueOf('R'), "dustRedstone", Character.valueOf('G'), "dustGlowstone", Character.valueOf('L'), "gemLapis", Character.valueOf('C'), "circuitBasic");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("thick_neutron_reflector", RecipeMethods.Type.PART), " P ", "PCP", " P ", Character.valueOf('P'), "reflectorBasic", Character.valueOf('C'), CraftingTableRecipes.getCell("Berylium"));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("neutron_reflector", RecipeMethods.Type.PART), "TCT", "CPC", "TCT", Character.valueOf('T'), "dustTin", Character.valueOf('C'), "dustCoal", Character.valueOf('P'), "plateCopper");
        }
        ItemStack uuStack = new ItemStack(ModItems.UU_MATTER);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150364_r, 8), " U ", "   ", "   ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150348_b, 16), "   ", " U ", "   ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150433_aE, 16), "U U", "   ", "   ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack((Block)Blocks.field_150349_c, 16), "   ", "U  ", "U  ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150343_Z, 12), "U U", "U U", "   ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150359_w, 32), " U ", "U U", " U ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151100_aR, 32, 3), "UU ", "  U", "UU ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150426_aN, 8), " U ", "U U", "UUU", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack((Block)Blocks.field_150434_aF, 48), " U ", "UUU", "U U", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151120_aE, 48), "U U", "U U", "U U", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150395_bd, 24), "U  ", "U  ", "U  ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151126_ay, 16), "   ", "   ", "UUU", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151119_aD, 48), "UU ", "U  ", "UU ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150392_bi, 64), "U U", " U ", " U ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151016_H, 15), "UUU", "U  ", "UUU", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151103_aS, 32), "U  ", "UU ", "U  ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151008_G, 32), " U ", " U ", "U U", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151100_aR, 48), " UU", " UU", " U ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151079_bi, 1), "UUU", "U U", " U ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151044_h, 5), "  U", "U  ", "  U", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150366_p, 2), "U U", " U ", "U U", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150352_o, 2), " U ", "UUU", " U ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151137_ax, 24), "   ", " U ", "UUU", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151100_aR, 9, 4), " U ", " U ", " UU", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150412_bA, 1), "UU ", "U U", " UU", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151166_bC, 2), "UUU", "UUU", " U ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151045_i, 1), "UUU", "UUU", "UUU", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("tin", 10, RecipeMethods.Type.DUST), "   ", "U U", "  U", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("copper", 10, RecipeMethods.Type.DUST), "  U", "U U", "   ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("lead", 14, RecipeMethods.Type.DUST), "UUU", "UUU", "U  ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("platinum", RecipeMethods.Type.DUST), "  U", "UUU", "UUU", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("tungsten", RecipeMethods.Type.DUST), "U  ", "UUU", "UUU", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("titanium", 2, RecipeMethods.Type.DUST), "UUU", " U ", " U ", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("aluminum", 16, RecipeMethods.Type.DUST), " U ", " U ", "UUU", Character.valueOf('U'), uuStack);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("iridium", 1, RecipeMethods.Type.ORE), "UUU", " U ", "UUU", Character.valueOf('U'), uuStack);
        for (String part : ItemParts.types) {
            if (!part.endsWith("Gear")) continue;
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial(part, RecipeMethods.Type.PART), " O ", "OIO", " O ", Character.valueOf('I'), CraftingTableRecipes.getStack(Items.field_151042_j), Character.valueOf('O'), "ingot" + StringUtils.toFirstCapital((String)part.replace("Gear", "")));
        }
        Core.logHelper.info((Object)"Crafting Table Recipes Added");
    }

    static void registerCompressionRecipes() {
        for (String name : BlockStorage.types) {
            if (OreUtil.hasIngot((String)name)) {
                CraftingTableRecipes.registerShaped(BlockStorage.getStorageBlockByName(name), "AAA", "AAA", "AAA", Character.valueOf('A'), "ingot" + StringUtils.toFirstCapital((String)name));
                CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial(name, 9, RecipeMethods.Type.INGOT), BlockStorage.getStorageBlockByName(name));
                continue;
            }
            if (!OreUtil.hasGem((String)name)) continue;
            CraftingTableRecipes.registerShaped(BlockStorage.getStorageBlockByName(name), "AAA", "AAA", "AAA", Character.valueOf('A'), "gem" + StringUtils.toFirstCapital((String)name));
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial(name, 9, RecipeMethods.Type.GEM), BlockStorage.getStorageBlockByName(name));
        }
        for (String block : BlockStorage2.types) {
            if (OreUtil.hasIngot((String)(block = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, block)))) {
                CraftingTableRecipes.registerShaped(BlockStorage2.getStorageBlockByName(block), "AAA", "AAA", "AAA", Character.valueOf('A'), "ingot" + StringUtils.toFirstCapital((String)block));
                CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial(block, 9, RecipeMethods.Type.INGOT), BlockStorage2.getStorageBlockByName(block));
                continue;
            }
            if (!OreUtil.hasGem((String)block)) continue;
            CraftingTableRecipes.registerShaped(BlockStorage2.getStorageBlockByName(block), "AAA", "AAA", "AAA", Character.valueOf('A'), "gem" + StringUtils.toFirstCapital((String)block));
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial(block, 9, RecipeMethods.Type.GEM), BlockStorage2.getStorageBlockByName(block));
        }
        for (String name : ItemDustsSmall.types) {
            if (name.equals("PLACEHOLDER_ITEM")) continue;
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial(name, 4, RecipeMethods.Type.SMALL_DUST), CraftingTableRecipes.getMaterialObject(name, RecipeMethods.Type.DUST));
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial(name, RecipeMethods.Type.DUST), CraftingTableRecipes.getMaterialObject(name, RecipeMethods.Type.SMALL_DUST), CraftingTableRecipes.getMaterialObject(name, RecipeMethods.Type.SMALL_DUST), CraftingTableRecipes.getMaterialObject(name, RecipeMethods.Type.SMALL_DUST), CraftingTableRecipes.getMaterialObject(name, RecipeMethods.Type.SMALL_DUST));
        }
        for (String nuggets : ItemNuggets.types) {
            if (nuggets.equals("PLACEHOLDER_ITEM") || nuggets.equalsIgnoreCase("diamond")) continue;
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial(nuggets, 9, RecipeMethods.Type.NUGGET), CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "ingot_" + nuggets));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial(nuggets, RecipeMethods.Type.INGOT), "NNN", "NNN", "NNN", Character.valueOf('N'), CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "nugget_" + nuggets));
        }
        CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial("diamond", 9, RecipeMethods.Type.NUGGET), "gemDiamond");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151045_i), "NNN", "NNN", "NNN", Character.valueOf('N'), "nuggetDiamond");
    }

    static void registerMixedMetalIngotRecipes() {
        if (!IC2Duplicates.deduplicate()) {
            CraftingTableRecipes.registerMixedMetal("ingotRefinedIron", "ingotBronze", "ingotTin", 2);
            CraftingTableRecipes.registerMixedMetal("ingotRefinedIron", "ingotBronze", "ingotZinc", 2);
            CraftingTableRecipes.registerMixedMetal("ingotNickel", "ingotBronze", "ingotTin", 3);
            CraftingTableRecipes.registerMixedMetal("ingotNickel", "ingotBronze", "ingotZinc", 3);
            CraftingTableRecipes.registerMixedMetal("ingotNickel", "ingotBronze", "ingotAluminum", 4);
            CraftingTableRecipes.registerMixedMetal("ingotInvar", "ingotBronze", "ingotTin", 4);
            CraftingTableRecipes.registerMixedMetal("ingotInvar", "ingotBronze", "ingotZinc", 4);
            CraftingTableRecipes.registerMixedMetal("ingotInvar", "ingotBronze", "ingotAluminum", 5);
            CraftingTableRecipes.registerMixedMetal("ingotTitanium", "ingotBronze", "ingotTin", 5);
            CraftingTableRecipes.registerMixedMetal("ingotTitanium", "ingotBronze", "ingotZinc", 5);
            CraftingTableRecipes.registerMixedMetal("ingotTungsten", "ingotBronze", "ingotTin", 5);
            CraftingTableRecipes.registerMixedMetal("ingotTungsten", "ingotBronze", "ingotZinc", 5);
            CraftingTableRecipes.registerMixedMetal("ingotTitanium", "ingotBronze", "ingotAluminum", 6);
            CraftingTableRecipes.registerMixedMetal("ingotTungsten", "ingotBronze", "ingotAluminum", 6);
            CraftingTableRecipes.registerMixedMetal("ingotTungstensteel", "ingotBronze", "ingotTin", 8);
            CraftingTableRecipes.registerMixedMetal("ingotTungstensteel", "ingotBronze", "ingotZinc", 8);
            CraftingTableRecipes.registerMixedMetal("ingotTungstensteel", "ingotBronze", "ingotAluminum", 9);
        }
    }

    static void registerMixedMetal(String top, String middle, String bottom, int amount) {
        if (!OreDictionary.doesOreNameExist((String)top)) {
            return;
        }
        if (!OreDictionary.doesOreNameExist((String)middle)) {
            return;
        }
        if (!OreDictionary.doesOreNameExist((String)bottom)) {
            return;
        }
        if (top.equals("ingotRefinedIron") && IC2Duplicates.deduplicate()) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("mixed_metal", amount, RecipeMethods.Type.INGOT), "TTT", "MMM", "BBB", Character.valueOf('T'), "ingotRefinedIron", Character.valueOf('M'), middle, Character.valueOf('B'), bottom);
        } else {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("mixed_metal", amount, RecipeMethods.Type.INGOT), "TTT", "MMM", "BBB", Character.valueOf('T'), top, Character.valueOf('M'), middle, Character.valueOf('B'), bottom);
        }
        if (middle.equals("ingotBronze")) {
            CraftingTableRecipes.registerMixedMetal(top, "ingotBrass", bottom, amount);
        }
        if (bottom.equals("ingotAluminum")) {
            CraftingTableRecipes.registerMixedMetal(top, middle, "ingotAluminium", amount);
        }
    }

    static void registerShaped(ItemStack output, Object ... inputs) {
        RebornCraftingHelper.addShapedOreRecipe((ItemStack)output, (Object[])inputs);
    }

    static void registerShapeless(ItemStack output, Object ... inputs) {
        RebornCraftingHelper.addShapelessOreRecipe((ItemStack)output, (Object[])inputs);
    }

    static void addToolAndArmourRecipes(ItemStack sword, ItemStack pickaxe, ItemStack axe, ItemStack hoe, ItemStack spade, ItemStack helmet, ItemStack chestplate, ItemStack leggings, ItemStack boots, String material) {
        CraftingTableRecipes.registerShaped(sword, "G", "G", "S", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(pickaxe, "GGG", " S ", " S ", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(axe, "GG", "GS", " S", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(hoe, "GG", " S", " S", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(spade, "G", "S", "S", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(helmet, "GGG", "G G", Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(chestplate, "G G", "GGG", "GGG", Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(leggings, "GGG", "G G", "G G", Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(boots, "G G", "G G", Character.valueOf('G'), material);
    }
}

