/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init;

import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.OreUtil;
import reborncore.common.util.RebornCraftingHelper;
import techreborn.Core;
import techreborn.api.recipe.machines.GrinderRecipe;
import techreborn.api.recipe.machines.VacuumFreezerRecipe;
import techreborn.compat.CompatManager;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.init.recipes.AlloySmelterRecipes;
import techreborn.init.recipes.AssemblingMachineRecipes;
import techreborn.init.recipes.BlastFurnaceRecipes;
import techreborn.init.recipes.ChemicalReactorRecipes;
import techreborn.init.recipes.CompressorRecipes;
import techreborn.init.recipes.CraftingTableRecipes;
import techreborn.init.recipes.DistillationTowerRecipes;
import techreborn.init.recipes.ExtractorRecipes;
import techreborn.init.recipes.FluidGeneratorRecipes;
import techreborn.init.recipes.FluidReplicatorRecipes;
import techreborn.init.recipes.FusionReactorRecipes;
import techreborn.init.recipes.ImplosionCompressorRecipes;
import techreborn.init.recipes.IndustrialCentrifugeRecipes;
import techreborn.init.recipes.IndustrialElectrolyzerRecipes;
import techreborn.init.recipes.IndustrialGrinderRecipes;
import techreborn.init.recipes.IndustrialSawmillRecipes;
import techreborn.init.recipes.PlateBendingMachineRecipes;
import techreborn.init.recipes.RollingMachineRecipes;
import techreborn.init.recipes.ScrapboxRecipes;
import techreborn.init.recipes.SmeltingRecipes;
import techreborn.init.recipes.SolidCanningMachineRecipes;
import techreborn.init.recipes.WireMillRecipes;
import techreborn.items.ItemCells;
import techreborn.items.ingredients.ItemDusts;
import techreborn.items.ingredients.ItemIngots;
import techreborn.items.ingredients.ItemParts;
import techreborn.utils.OreDictUtils;

@RebornRegistry(modID="techreborn")
public class ModRecipes {
    public static void init() {
        OreUtil.scanForOres();
        CompatManager.isQuantumStorageLoaded = Loader.isModLoaded((String)"quantumstorage");
        CraftingTableRecipes.init();
        SmeltingRecipes.init();
        ExtractorRecipes.init();
        RollingMachineRecipes.init();
        FluidGeneratorRecipes.init();
        IndustrialGrinderRecipes.init();
        IndustrialCentrifugeRecipes.init();
        IndustrialElectrolyzerRecipes.init();
        ImplosionCompressorRecipes.init();
        ScrapboxRecipes.init();
        ChemicalReactorRecipes.init();
        FusionReactorRecipes.init();
        DistillationTowerRecipes.init();
        AlloySmelterRecipes.init();
        FluidReplicatorRecipes.init();
        BlastFurnaceRecipes.init();
        CompressorRecipes.init();
        PlateBendingMachineRecipes.init();
        AssemblingMachineRecipes.init();
        SolidCanningMachineRecipes.init();
        WireMillRecipes.init();
        ModRecipes.addVacuumFreezerRecipes();
        ModRecipes.addIc2Recipes();
        ModRecipes.addGrinderRecipes();
    }

    public static void postInit() {
        if (ConfigTechReborn.disableRailcraftSteelNuggetRecipe) {
            Iterator iterator = FurnaceRecipes.func_77602_a().func_77599_b().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!(entry.getValue() instanceof ItemStack) || !(entry.getKey() instanceof ItemStack)) continue;
                ItemStack input = (ItemStack)entry.getKey();
                ItemStack output = (ItemStack)entry.getValue();
                if (!ItemUtils.isInputEqual((Object)"nuggetSteel", (ItemStack)output, (boolean)true, (boolean)true, (boolean)false) || !ItemUtils.isInputEqual((Object)"nuggetIron", (ItemStack)input, (boolean)true, (boolean)true, (boolean)false)) continue;
                Core.logHelper.info((Object)"Removing a steelnugget smelting recipe");
                iterator.remove();
            }
        }
        IndustrialSawmillRecipes.init();
    }

    static void addGrinderRecipes() {
        ItemStack marbleStack;
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(ItemParts.getPartByName("plantball"), new ItemStack(Blocks.field_150346_d), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151100_aR, 6, 15), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.field_150347_e), new ItemStack((Block)Blocks.field_150354_m), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.field_150351_n), new ItemStack(Items.field_151145_ak), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.field_151044_h), ItemDusts.getDustByName("coal"), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.field_151044_h, 1, 1), ItemDusts.getDustByName("charcoal"), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.field_151119_aD), ItemDusts.getDustByName("clay"), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.field_150426_aN), ItemDusts.getDustByName("glowstone", 4), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.field_150424_aL), ItemDusts.getDustByName("netherrack"), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.field_150377_bs), ItemDusts.getDustByName("endstone"), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.field_151061_bv), ItemDusts.getDustByName("ender_eye", 2), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.field_151079_bi), ItemDusts.getDustByName("ender_pearl", 2), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.field_150369_x), new ItemStack(Items.field_151100_aR, 10, 4), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.field_150343_Z), ItemDusts.getDustByName("obsidian", 4), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.field_151072_bj), new ItemStack(Items.field_151065_br, 4), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.field_189877_df), new ItemStack(Items.field_151064_bs, 4), 300, 20));
        if (OreUtil.doesOreExistAndValid((String)"stoneMarble")) {
            marbleStack = ModRecipes.getOre("stoneMarble");
            marbleStack.func_190920_e(1);
            RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(marbleStack, ItemDusts.getDustByName("marble"), 300, 20));
        }
        if (OreUtil.doesOreExistAndValid((String)"stoneBasalt")) {
            marbleStack = ModRecipes.getOre("stoneBasalt");
            marbleStack.func_190920_e(1);
            RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(marbleStack, ItemDusts.getDustByName("basalt"), 300, 20));
        }
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe("oreCoal", new ItemStack(Items.field_151044_h, 2), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe("oreDiamond", new ItemStack(Items.field_151045_i, 1), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe("oreEmerald", new ItemStack(Items.field_151166_bC, 1), 300, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe("oreRedstone", new ItemStack(Items.field_151137_ax, 8), 300, 20));
        for (String oreDictionaryName : OreDictionary.getOreNames()) {
            if (!OreDictUtils.isDictPrefixed(oreDictionaryName, "ore", "gem", "ingot")) continue;
            ItemStack oreStack = OreDictUtils.getDictOreOrEmpty(oreDictionaryName, 1);
            String[] data = OreDictUtils.getDictData(oreDictionaryName);
            if (data[0].equals("ore") && (data[1].equals("tungsten") || data[1].equals("titanium") || data[1].equals("aluminium") || data[1].equals("iridium") || data[1].equals("saltpeter") || data[1].equals("coal") || data[1].equals("diamond") || data[1].equals("emerald") || data[1].equals("redstone")) || oreStack.func_190926_b() || data[0].equals("ore") && (data[1].equals("quartz") || data[1].equals("certuzQuartz"))) continue;
            boolean ore = data[0].equals("ore");
            Core.logHelper.debug((Object)("Ore: " + data[1]));
            ItemStack dust = OreDictUtils.getDictOreOrEmpty(OreDictUtils.joinDictName("dust", data[1]), ore ? 2 : 1);
            if (dust.func_190926_b() || dust.func_77973_b() == null) continue;
            dust = dust.func_77946_l();
            if (ore) {
                dust.func_190920_e(2);
            }
            boolean useOreDict = true;
            if (data[1].equalsIgnoreCase("lapis")) {
                useOreDict = false;
            }
            RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(oreStack, dust, 300, 20, useOreDict));
        }
    }

    static void addVacuumFreezerRecipes() {
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(new ItemStack(Blocks.field_150432_aD, 2), new ItemStack(Blocks.field_150403_cj), 60, 64));
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(ItemIngots.getIngotByName("hot_tungstensteel"), ItemIngots.getIngotByName("tungstensteel"), 440, 64));
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(ItemCells.getCellByName("heliumplasma"), ItemCells.getCellByName("helium"), 440, 64));
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(ItemCells.getCellByName("water"), ItemCells.getCellByName("cell"), 60, 64));
    }

    static void addIc2Recipes() {
        RebornCraftingHelper.addShapelessOreRecipe((ItemStack)new ItemStack(ModItems.MANUAL), (Object[])new Object[]{"ingotRefinedIron", Items.field_151122_aG});
    }

    public static ItemStack getBucketWithFluid(Fluid fluid) {
        return FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000));
    }

    public static ItemStack getOre(String name) {
        if (OreDictionary.getOres((String)name).isEmpty()) {
            return new ItemStack(ModItems.MISSING_RECIPE_PLACEHOLDER);
        }
        return ((ItemStack)OreDictionary.getOres((String)name).get(0)).func_77946_l();
    }
}

