/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.repurpose.Events;

import com.google.common.collect.Multimap;
import com.wuest.repurpose.Base.TileEntityBase;
import com.wuest.repurpose.Capabilities.DimensionHome;
import com.wuest.repurpose.Capabilities.DimensionHomeProvider;
import com.wuest.repurpose.Capabilities.IDimensionHome;
import com.wuest.repurpose.Capabilities.ItemBagOfHoldingProvider;
import com.wuest.repurpose.Config.WuestConfiguration;
import com.wuest.repurpose.Items.Containers.BagOfHoldingContainer;
import com.wuest.repurpose.Items.ItemBagOfHolding;
import com.wuest.repurpose.Items.ItemFluffyFabric;
import com.wuest.repurpose.Items.ItemScroll;
import com.wuest.repurpose.Items.ItemSnorkel;
import com.wuest.repurpose.Items.ItemStoneShears;
import com.wuest.repurpose.Items.ItemWhetStone;
import com.wuest.repurpose.ModRegistry;
import com.wuest.repurpose.Proxy.ClientProxy;
import com.wuest.repurpose.Proxy.CommonProxy;
import com.wuest.repurpose.Proxy.Messages.BedLocationMessage;
import com.wuest.repurpose.Proxy.Messages.ConfigSyncMessage;
import com.wuest.repurpose.Repurpose;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(value={Side.SERVER, Side.CLIENT})
public class WuestEventHandler {
    private static HashMap<String, BlockPos> playerBedLocation;
    private static HashMap<String, Integer> playerExistedTicks;

    @SubscribeEvent
    public static void equipmentChangeEvent(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof EntityPlayer && event.getSlot() == EntityEquipmentSlot.MAINHAND) {
            Multimap modifiers = event.getTo().func_111283_C(event.getSlot());
            WuestEventHandler.removeAttackModifiers(event.getTo());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            ItemStack offHandStack;
            NBTTagCompound tag = CommonProxy.proxyConfiguration.ToNBTTagCompound();
            Repurpose.network.sendTo((IMessage)new ConfigSyncMessage(tag), (EntityPlayerMP)event.player);
            System.out.println("Sent config to '" + event.player.getDisplayNameString() + ".'");
            if (!CommonProxy.proxyConfiguration.enableSwiftCombat) {
                for (ItemStack stack : event.player.field_71071_by.field_70462_a) {
                    WuestEventHandler.removeAttackModifiers(stack);
                }
            }
            if ((offHandStack = event.player.func_184592_cb()).func_77973_b() instanceof ItemBagOfHolding) {
                // empty if block
            }
        }
    }

    @SubscribeEvent
    public static void OnClientDisconnectEvent(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        ((ClientProxy)Repurpose.proxy).serverConfiguration = null;
    }

    @SubscribeEvent
    public static void AttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("repurpose", "DimensionHome"), (ICapabilityProvider)new DimensionHomeProvider((Entity)event.getObject(), new DimensionHome()));
        }
    }

    @SubscribeEvent
    public static void AttachItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() instanceof ItemBagOfHolding) {
            ItemBagOfHoldingProvider.AttachNewStackHandlerToStack((ItemStack)event.getObject());
        }
    }

    @SubscribeEvent
    public static void AttachTileEntityCapabilities(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileEntityBase) {
            ArrayList<Capability> arrayList = ((TileEntityBase)((Object)event.getObject())).getAllowedCapabilities();
        }
    }

    @SubscribeEvent
    public static void PlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        IDimensionHome dimensionHome = (IDimensionHome)event.player.getCapability(ModRegistry.DimensionHomes, null);
        if (dimensionHome != null) {
            dimensionHome.setHomePosition(event.toDim, event.player.func_180425_c());
        }
    }

    @SubscribeEvent
    public static void PlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            EntityPlayer original = event.getOriginal();
            EntityPlayer newPlayer = event.getEntityPlayer();
            IDimensionHome originalDimensionHome = (IDimensionHome)original.getCapability(ModRegistry.DimensionHomes, null);
            IDimensionHome newDimensionHome = (IDimensionHome)newPlayer.getCapability(ModRegistry.DimensionHomes, null);
            newDimensionHome.Transfer(originalDimensionHome);
        }
    }

    /*
     * Unable to fully structure code
     */
    @SubscribeEvent(receiveCanceled=true)
    public static void PlayerRightClicked(PlayerInteractEvent event) {
        if (event.getHand() != EnumHand.OFF_HAND) ** GOTO lbl-1000
        if (CommonProxy.proxyConfiguration.rightClickCropHarvest && !event.getWorld().field_72995_K && !event.isCanceled()) {
            p = event.getEntityPlayer();
            currentStack = p.field_71071_by.func_70448_g();
            if (currentStack != null) {
                currentItem = currentStack.func_77973_b();
                boneMealStack = new ItemStack(Items.field_151100_aR, 1, 15);
                boneMeal = boneMealStack.func_77973_b();
                if (currentItem != null && currentItem == boneMeal) {
                    if (CommonProxy.proxyConfiguration.enableVerboseLogging) {
                        System.out.println("Cannot harvest a crop when bone meal is being used.");
                    }
                    return;
                }
            }
            v0 = ageInteger = (crop = (cropState = event.getWorld().func_180495_p(event.getPos())).func_177230_c()) instanceof BlockBeetroot != false ? BlockBeetroot.field_185531_a : BlockCrops.field_176488_a;
            if (crop instanceof BlockCrops || crop instanceof BlockBush) {
                if (CommonProxy.proxyConfiguration.enableVerboseLogging) {
                    System.out.println("Found a crop, check to see if it's fully grown.");
                }
                cropIsMaxAge = false;
                for (IProperty property : cropState.func_177227_a()) {
                    if (!property.func_177701_a().toLowerCase().equals("age") || !(property instanceof PropertyInteger)) continue;
                    ageInteger = (PropertyInteger)property;
                    tempMax = ageInteger.func_177700_c().stream().max((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, compare(int int ), (Ljava/lang/Integer;Ljava/lang/Integer;)I)());
                    if (!tempMax.isPresent()) break;
                    maxAge = (Integer)tempMax.get();
                    cropIsMaxAge = (Integer)cropState.func_177229_b((IProperty)ageInteger) == maxAge;
                    break;
                }
                if (cropIsMaxAge) {
                    if (CommonProxy.proxyConfiguration.enableVerboseLogging) {
                        System.out.println("The crop is fully grown, get the drops, and try to re-plant.");
                    }
                    farmlandPosition = event.getPos().func_177977_b();
                    drops = NonNullList.func_191196_a();
                    crop.getDrops(drops, (IBlockAccess)event.getWorld(), event.getPos(), cropState, 1);
                    event.getWorld().func_175698_g(event.getPos());
                    replanted = EnumActionResult.FAIL;
                    tempState = cropState.func_177226_a((IProperty)ageInteger, (Comparable)Integer.valueOf(0));
                    seed = crop.func_180660_a(tempState, new Random(), 0);
                    for (ItemStack drop : drops) {
                        dropItem = drop.func_77973_b();
                        if (dropItem.getClass() == seed.getClass() && replanted != EnumActionResult.PASS) {
                            facing = event.getFace();
                            replanted = drop.func_179546_a(p, event.getWorld(), farmlandPosition, event.getHand(), EnumFacing.UP, 0.0f, 0.0f, 0.0f);
                            if (replanted == EnumActionResult.SUCCESS || replanted == EnumActionResult.PASS) {
                                replanted = EnumActionResult.PASS;
                                if (!CommonProxy.proxyConfiguration.enableVerboseLogging) continue;
                                System.out.println("Found a 'seed' to plant for the crop [" + crop.getRegistryName().toString() + "] from the crop's drops. Not including it in the list of drops to be added to the player's inventory.");
                                continue;
                            }
                        }
                        p.field_71071_by.func_70441_a(drop);
                        p.field_71069_bz.func_75142_b();
                    }
                    if (replanted != EnumActionResult.PASS) {
                        seeds = new ItemStack(seed);
                        if (p.field_71071_by.func_70431_c(seeds)) {
                            if (CommonProxy.proxyConfiguration.enableVerboseLogging) {
                                System.out.println("The player has the seed for this crop. Attempting to re-plant.");
                            }
                            state = event.getWorld().func_180495_p(farmlandPosition);
                            facing = EnumFacing.UP;
                            if (p.func_175151_a(farmlandPosition.func_177972_a(facing), facing, seeds) && state.func_177230_c().canSustainPlant(state, (IBlockAccess)event.getWorld(), farmlandPosition, EnumFacing.UP, (IPlantable)seeds.func_77973_b()) && event.getWorld().func_175623_d(farmlandPosition.func_177984_a())) {
                                if (CommonProxy.proxyConfiguration.enableVerboseLogging) {
                                    System.out.println("The player is able to edit the top of this farmland and the farmland can sustaing this plant and the block above the farmland is air.");
                                }
                                event.getWorld().func_175656_a(farmlandPosition.func_177984_a(), ((IPlantable)seeds.func_77973_b()).getPlant((IBlockAccess)event.getWorld(), farmlandPosition));
                                if (p instanceof EntityPlayerMP) {
                                    CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)p, farmlandPosition.func_177984_a(), seeds);
                                    p.field_71071_by.func_174925_a(seeds.func_77973_b(), -1, 1, null);
                                    p.field_71069_bz.func_75142_b();
                                    if (CommonProxy.proxyConfiguration.enableVerboseLogging) {
                                        System.out.println("Right-click harvesting succeeded. Removing 1 'seed' item from the player's inventory since a seed was not included in the block drops.");
                                    }
                                }
                            } else if (CommonProxy.proxyConfiguration.enableVerboseLogging) {
                                System.out.println("Plant not re-planted. The player either cannot edit the block above the farmland or the farmland cannot sustaing this plant or the block above the farmland is not air.");
                            }
                        } else if (CommonProxy.proxyConfiguration.enableVerboseLogging) {
                            System.out.println("Plant not re-planted. The player does not have the seed: [" + seed.getRegistryName().toString() + "] in their inventory.");
                        }
                    }
                    event.setCanceled(true);
                    if (CommonProxy.proxyConfiguration.enableVerboseLogging) {
                        System.out.println("Cancelling future player right-clicked events so multiple right-click harvesting mods don't duplicate drops.");
                    }
                }
            } else if (CommonProxy.proxyConfiguration.enableVerboseLogging) {
                System.out.println("The block right-clicked is not a harvestable block. Right-click harvesting did not occur.");
            }
        } else if (!event.getWorld().field_72995_K) {
            if (CommonProxy.proxyConfiguration.rightClickCropHarvest && event.isCanceled()) {
                if (CommonProxy.proxyConfiguration.enableVerboseLogging) {
                    System.out.println("This event was previously canceled, right-click harvesting did not happen from this mod.");
                }
            }
        }
    }

    @SubscribeEvent
    public static void PlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer()) {
            WuestEventHandler.sendPlayerBedLocation(event);
        }
    }

    @SubscribeEvent
    public static void BedrockGeneration(PopulateChunkEvent.Pre event) {
        Chunk chunk;
        int dimension;
        if (!event.getWorld().field_72995_K && Repurpose.proxy.getServerConfiguration().enableFlatBedrockGeneration && (dimension = event.getWorld().field_73011_w.getDimension()) == 0 && (chunk = event.getWorld().func_72964_e(event.getChunkX(), event.getChunkZ())) != null) {
            for (ExtendedBlockStorage storage : chunk.func_76587_i()) {
                if (storage == null) continue;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 1; y < 16; ++y) {
                            if (!storage.func_177485_a(x, y, z).equals(Blocks.field_150357_h.func_176223_P())) continue;
                            storage.func_177484_a(x, y, z, Blocks.field_150348_b.func_176223_P());
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void EntityDied(LivingDropsEvent event) {
        Entity entity;
        if (!event.getEntity().field_70170_p.field_72995_K && ((entity = event.getEntity()) instanceof EntityZombie || entity instanceof EntitySkeleton || entity instanceof EntityCreeper)) {
            double maxPercentage = (double)CommonProxy.proxyConfiguration.monsterHeadDropChance / 100.0;
            double randomChance = WuestEventHandler.getRandomChance(entity.field_70170_p);
            if (randomChance <= maxPercentage) {
                for (EntityItem existingStack : event.getDrops()) {
                    if (existingStack.func_92059_d().func_77973_b() != Items.field_151144_bL) continue;
                    return;
                }
                int meta = entity instanceof EntityZombie ? 2 : (entity instanceof EntitySkeleton ? 0 : 4);
                ItemStack stack = new ItemStack(Items.field_151144_bL, 1, meta);
                EntityItem newItem = new EntityItem(event.getEntity().field_70170_p, event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, stack);
                event.getDrops().add(newItem);
            }
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent onConfigChangedEvent) {
        if (onConfigChangedEvent.getModID().equals("repurpose")) {
            WuestConfiguration.syncConfig();
        }
    }

    @SubscribeEvent
    public static void AnvilUpdate(AnvilUpdateEvent event) {
        ItemStack rightItem = event.getRight();
        ItemStack leftItem = event.getLeft();
        if (rightItem.func_77973_b() instanceof ItemBook) {
            ItemStack enchantedBook = null;
            if (leftItem.func_77973_b() instanceof ItemFluffyFabric) {
                ItemEnchantedBook cfr_ignored_0 = (ItemEnchantedBook)Items.field_151134_bR;
                enchantedBook = ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(Enchantments.field_185306_r, 1));
                event.setCost(3);
            } else if (leftItem.func_77973_b() instanceof ItemWhetStone) {
                ItemEnchantedBook cfr_ignored_1 = (ItemEnchantedBook)Items.field_151134_bR;
                enchantedBook = ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(Enchantments.field_185302_k, 1));
                event.setCost(1);
            } else if (leftItem.func_77973_b() instanceof ItemSnorkel) {
                ItemEnchantedBook cfr_ignored_2 = (ItemEnchantedBook)Items.field_151134_bR;
                enchantedBook = ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(Enchantments.field_185298_f, 1));
                event.setCost(2);
            }
            if (enchantedBook != null) {
                event.setOutput(enchantedBook);
            }
        } else if (rightItem.func_77973_b() instanceof ItemArmor && ((ItemArmor)rightItem.func_77973_b()).field_77881_a == EntityEquipmentSlot.FEET && leftItem.func_77973_b() instanceof ItemFluffyFabric || leftItem.func_77973_b() instanceof ItemArmor && ((ItemArmor)leftItem.func_77973_b()).field_77881_a == EntityEquipmentSlot.FEET && rightItem.func_77973_b() instanceof ItemFluffyFabric) {
            ItemArmor itemType = rightItem.func_77973_b() instanceof ItemArmor ? (ItemArmor)rightItem.func_77973_b() : (ItemArmor)leftItem.func_77973_b();
            ItemStack result = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)itemType.getRegistryName()));
            if (result != null) {
                result.func_77966_a((Enchantment)ModRegistry.StepAssist(), 1);
                event.setCost(2);
            }
            event.setOutput(result);
        }
        if (rightItem.func_77973_b() instanceof ItemScroll || leftItem.func_77973_b() instanceof ItemScroll) {
            event = WuestEventHandler.processScrollUpdate(event);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public static void onDrops(BlockEvent.HarvestDropsEvent event) {
        double maxPercentage;
        Block block;
        block8: {
            block7: {
                block = event.getState().func_177230_c();
                if (event.isCanceled()) return;
                if (event.isSilkTouching()) return;
                if (event.getWorld().field_72995_K) return;
                maxPercentage = 0.01;
                if (block == Blocks.field_150365_q) {
                    maxPercentage = (double)CommonProxy.proxyConfiguration.diamondShardDropChance / 100.0;
                    WuestEventHandler.checkChanceAndAddToDrops(event.getWorld(), event.getDrops(), maxPercentage, ModRegistry.DiamondShard(), 1);
                    return;
                }
                if (block instanceof BlockLeaves) {
                    if (CommonProxy.proxyConfiguration.enableAppleStickExtraDrops) {
                        maxPercentage = (double)CommonProxy.proxyConfiguration.appleDropChance / 100.0;
                        WuestEventHandler.checkChanceAndAddToDrops(event.getWorld(), event.getDrops(), maxPercentage, Items.field_151034_e, 1);
                        maxPercentage = (double)CommonProxy.proxyConfiguration.stickDropChance / 100.0;
                        WuestEventHandler.checkChanceAndAddToDrops(event.getWorld(), event.getDrops(), maxPercentage, Items.field_151055_y, 1);
                        return;
                    }
                }
                if (block instanceof BlockDirt) break block7;
                if (!(block instanceof BlockGrass)) break block8;
            }
            if (CommonProxy.proxyConfiguration.enableExtraDropsFromDirt) {
                maxPercentage = (double)CommonProxy.proxyConfiguration.carrotDropChance / 100.0;
                WuestEventHandler.checkChanceAndAddToDrops(event.getWorld(), event.getDrops(), maxPercentage, Items.field_151172_bF, 1);
                maxPercentage = (double)CommonProxy.proxyConfiguration.potatoDropChance / 100.0;
                WuestEventHandler.checkChanceAndAddToDrops(event.getWorld(), event.getDrops(), maxPercentage, Items.field_151174_bG, 1);
                maxPercentage = (double)CommonProxy.proxyConfiguration.beetRootDropChance / 100.0;
                WuestEventHandler.checkChanceAndAddToDrops(event.getWorld(), event.getDrops(), maxPercentage, Items.field_185164_cV, 1);
                maxPercentage = (double)CommonProxy.proxyConfiguration.boneDropChance / 100.0;
                WuestEventHandler.checkChanceAndAddToDrops(event.getWorld(), event.getDrops(), maxPercentage, Items.field_151103_aS, 1);
                maxPercentage = (double)CommonProxy.proxyConfiguration.clayBallDropChance / 100.0;
                WuestEventHandler.checkChanceAndAddToDrops(event.getWorld(), event.getDrops(), maxPercentage, Items.field_151119_aD, 1);
                return;
            }
        }
        if (!(block instanceof BlockStone)) return;
        if (!CommonProxy.proxyConfiguration.enableExtraDropsFromStone) return;
        maxPercentage = (double)CommonProxy.proxyConfiguration.coalDropChance / 100.0;
        WuestEventHandler.checkChanceAndAddToDrops(event.getWorld(), event.getDrops(), maxPercentage, Items.field_151044_h, 1);
        maxPercentage = (double)CommonProxy.proxyConfiguration.ironNuggetDropChance / 100.0;
        WuestEventHandler.checkChanceAndAddToDrops(event.getWorld(), event.getDrops(), maxPercentage, Items.field_191525_da, 1);
        maxPercentage = (double)CommonProxy.proxyConfiguration.flintDropChance / 100.0;
        WuestEventHandler.checkChanceAndAddToDrops(event.getWorld(), event.getDrops(), maxPercentage, Items.field_151145_ak, 1);
        maxPercentage = (double)CommonProxy.proxyConfiguration.goldNuggetDropChance / 100.0;
        WuestEventHandler.checkChanceAndAddToDrops(event.getWorld(), event.getDrops(), maxPercentage, Items.field_151074_bl, 1);
    }

    @SubscribeEvent
    public static void onPickUp(EntityItemPickupEvent event) {
        if (!event.isCanceled()) {
            boolean setSlot = false;
            EntityPlayer player = event.getEntityPlayer();
            ItemStack eventStack = event.getItem().func_92059_d();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof ItemBagOfHolding)) continue;
                ItemBagOfHoldingProvider handler = ItemBagOfHoldingProvider.GetFromStack(stack);
                if (!handler.opened || !BagOfHoldingContainer.validForContainer(eventStack)) continue;
                int firstEmptySlot = -1;
                for (int j = 0; j < handler.getSlots(); ++j) {
                    int updatedSize;
                    ItemStack pouchStack = handler.getStackInSlot(j);
                    if (pouchStack.func_190926_b() && firstEmptySlot == -1) {
                        firstEmptySlot = j;
                    }
                    if (pouchStack.func_190926_b()) continue;
                    if (!ItemStack.func_179545_c((ItemStack)pouchStack, (ItemStack)eventStack) || (updatedSize = pouchStack.func_190916_E() + eventStack.func_190916_E()) > handler.getSlotLimit(j)) continue;
                    setSlot = true;
                    pouchStack.func_190920_e(updatedSize);
                    handler.setStackInSlot(j, pouchStack);
                    break;
                }
                if (!setSlot && firstEmptySlot != -1) {
                    handler.setStackInSlot(firstEmptySlot, eventStack);
                    setSlot = true;
                }
                if (!setSlot) continue;
                player.func_71001_a((Entity)event.getItem(), event.getItem().func_92059_d().func_190916_E());
                player.func_71064_a(StatList.func_188056_d((Item)event.getItem().func_92059_d().func_77973_b()), event.getItem().func_92059_d().func_190916_E());
                event.getItem().func_70106_y();
                event.setCanceled(true);
                handler.UpdateStack(stack);
                ItemBagOfHolding.RefreshItemStack(player, stack);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModRegistry.ModBlocks.toArray(new Block[ModRegistry.ModBlocks.size()]));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModRegistry.ModItems.toArray(new Item[ModRegistry.ModItems.size()]));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModRegistry.RegisterRecipes();
        ModRegistry.RegisterOreDictionaryRecords();
    }

    @SubscribeEvent
    public static void oreRegistration(OreDictionary.OreRegisterEvent event) {
        ModRegistry.RegisterRepairableMaterials(event.getName(), event.getOre());
    }

    private static void sendPlayerBedLocation(TickEvent.PlayerTickEvent event) {
        if (playerBedLocation == null) {
            playerBedLocation = new HashMap();
        }
        BedLocationMessage message = new BedLocationMessage();
        NBTTagCompound tag = new NBTTagCompound();
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        BlockPos bedPosition = player.func_180470_cg();
        if (bedPosition != null) {
            tag.func_74768_a("bedX", bedPosition.func_177958_n());
            tag.func_74768_a("bedY", bedPosition.func_177956_o());
            tag.func_74768_a("bedZ", bedPosition.func_177952_p());
        }
        message.setMessageTag(tag);
        BlockPos existingBedPosition = null;
        if (playerBedLocation.containsKey(player.func_70005_c_())) {
            existingBedPosition = playerBedLocation.get(player.func_70005_c_());
        } else {
            playerBedLocation.put(player.func_70005_c_(), bedPosition);
        }
        if (existingBedPosition != bedPosition) {
            Repurpose.network.sendTo((IMessage)message, player);
        }
    }

    private static void generatePlayerParticles(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (playerExistedTicks.containsKey(player.func_70005_c_())) {
            int ticks = playerExistedTicks.get(player.func_70005_c_());
            if (ticks % 20 == 0) {
                Repurpose.proxy.generateParticles(player);
                ticks = 0;
            }
            playerExistedTicks.put(player.func_70005_c_(), ++ticks);
        } else {
            playerExistedTicks.put(player.func_70005_c_(), 0);
        }
    }

    private static void checkChanceAndAddToDrops(World world, List<ItemStack> drops, double maxPercentage, Item itemToDrop, int quantity) {
        double randomChance = WuestEventHandler.getRandomChance(world);
        if (randomChance <= maxPercentage) {
            drops.add(new ItemStack(itemToDrop, quantity));
        }
    }

    private static double getRandomChance(World world) {
        double randomChance = world.field_73012_v.nextDouble();
        BigDecimal bigDecimal = new BigDecimal(Double.toString(randomChance));
        bigDecimal = bigDecimal.setScale(3, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }

    private static void removeAttackModifiers(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("AttributeModifiers")) {
            NBTTagList tagList = stack.func_77978_p().func_150295_c("AttributeModifiers", 10);
            ArrayList<Integer> indexesToRemove = new ArrayList<Integer>();
            if (tagList.func_74745_c() >= 2) {
                int i;
                for (i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
                    AttributeModifier attributeModifier = SharedMonsterAttributes.func_111259_a((NBTTagCompound)nbttagcompound);
                    if (attributeModifier.func_111167_a().equals(ItemStoneShears.getAttackDamageID()) || attributeModifier.func_111167_a().equals(ItemStoneShears.getAttackSpeedID())) {
                        indexesToRemove.add(i);
                    }
                    if (!attributeModifier.func_111167_a().equals(ItemStoneShears.getAttackSpeedID()) || attributeModifier.func_111164_d() == 6.0) continue;
                    indexesToRemove.clear();
                }
                for (i = 0; i < indexesToRemove.size(); ++i) {
                    tagList.func_74744_a((Integer)indexesToRemove.get(i) - i);
                }
                if (tagList.func_74745_c() < 2) {
                    stack.func_190919_e("AttributeModifiers");
                } else {
                    stack.func_77983_a("AttributeModifiers", (NBTBase)tagList);
                }
            }
        }
    }

    private static AnvilUpdateEvent processScrollUpdate(AnvilUpdateEvent event) {
        boolean isEnchantedScroll;
        ItemStack leftItemStack = event.getLeft();
        ItemStack rightItemStack = event.getRight();
        ItemStack copyOfLeft = leftItemStack.func_77946_l();
        Map map = EnchantmentHelper.func_82781_a((ItemStack)leftItemStack);
        int i = 0;
        int initialRepairCost = leftItemStack.func_82838_A() + rightItemStack.func_82838_A();
        int k = 0;
        boolean bl = isEnchantedScroll = rightItemStack.func_77973_b() instanceof ItemScroll && !rightItemStack.func_77986_q().func_82582_d();
        if (leftItemStack.func_77984_f() && leftItemStack.func_77973_b().func_82789_a(copyOfLeft, rightItemStack)) {
            int i3;
            int l2 = Math.min(leftItemStack.func_77952_i(), leftItemStack.func_77958_k() / 4);
            if (l2 <= 0) {
                event.setOutput(ItemStack.field_190927_a);
                event.setCost(0);
                return event;
            }
            for (i3 = 0; l2 > 0 && i3 < rightItemStack.func_190916_E(); ++i3) {
                int j3 = leftItemStack.func_77952_i() - l2;
                leftItemStack.func_77964_b(j3);
                ++i;
                l2 = Math.min(leftItemStack.func_77952_i(), leftItemStack.func_77958_k() / 4);
            }
            event.setCost(i3);
        } else {
            if (!isEnchantedScroll && (leftItemStack.func_77973_b() != rightItemStack.func_77973_b() || !leftItemStack.func_77984_f()) || isEnchantedScroll && !leftItemStack.func_77973_b().isBookEnchantable(leftItemStack, rightItemStack)) {
                event.setOutput(ItemStack.field_190927_a);
                event.setCost(0);
                return event;
            }
            if (leftItemStack.func_77984_f() && !isEnchantedScroll) {
                int l = copyOfLeft.func_77958_k() - copyOfLeft.func_77952_i();
                int i1 = rightItemStack.func_77958_k() - rightItemStack.func_77952_i();
                int j1 = i1 + leftItemStack.func_77958_k() * 12 / 100;
                int k1 = l + j1;
                int l1 = leftItemStack.func_77958_k() - k1;
                if (l1 < 0) {
                    l1 = 0;
                }
                if (l1 < leftItemStack.func_77952_i()) {
                    leftItemStack.func_77964_b(l1);
                    i += 2;
                }
            }
            Map map1 = EnchantmentHelper.func_82781_a((ItemStack)rightItemStack);
            boolean validEnchantments = false;
            boolean invalidEnchantments = false;
            for (Enchantment enchantment1 : map1.keySet()) {
                if (enchantment1 == null) continue;
                int i2 = map.containsKey(enchantment1) ? (Integer)map.get(enchantment1) : 0;
                int j2 = (Integer)map1.get(enchantment1);
                j2 = i2 == j2 ? j2 + 1 : Math.max(j2, i2);
                boolean canApplyEnchantment = enchantment1.func_92089_a(copyOfLeft);
                if (copyOfLeft.func_77973_b() == Items.field_151134_bR || copyOfLeft.func_77973_b() instanceof ItemScroll) {
                    canApplyEnchantment = true;
                }
                for (Enchantment enchantment : map.keySet()) {
                    if (enchantment == enchantment1 || enchantment1.func_191560_c(enchantment)) continue;
                    canApplyEnchantment = false;
                    ++i;
                }
                if (!canApplyEnchantment) {
                    invalidEnchantments = true;
                    continue;
                }
                validEnchantments = true;
                if (j2 > enchantment1.func_77325_b()) {
                    j2 = enchantment1.func_77325_b();
                }
                map.put(enchantment1, j2);
                int k3 = 0;
                switch (enchantment1.func_77324_c()) {
                    case COMMON: {
                        k3 = 1;
                        break;
                    }
                    case UNCOMMON: {
                        k3 = 2;
                        break;
                    }
                    case RARE: {
                        k3 = 4;
                        break;
                    }
                    case VERY_RARE: {
                        k3 = 8;
                    }
                }
                if (isEnchantedScroll) {
                    k3 = Math.max(1, k3 / 2);
                }
                i += k3 * j2;
                if (copyOfLeft.func_190916_E() <= 1) continue;
                i = 40;
            }
            if (invalidEnchantments && !validEnchantments) {
                event.setOutput(ItemStack.field_190927_a);
                event.setCost(0);
                return event;
            }
            int maximumCost = initialRepairCost + i;
            if (i <= 0) {
                copyOfLeft = ItemStack.field_190927_a;
            }
            if (k == i && k > 0 && maximumCost >= 40) {
                maximumCost = 39;
            }
            if (!leftItemStack.func_190926_b()) {
                int totalCost = leftItemStack.func_82838_A();
                if (!rightItemStack.func_190926_b() && totalCost < rightItemStack.func_82838_A()) {
                    totalCost = rightItemStack.func_82838_A();
                }
                if (k != i || k == 0) {
                    totalCost = totalCost * 2 + 1;
                }
                copyOfLeft.func_82841_c(totalCost);
                EnchantmentHelper.func_82782_a((Map)map, (ItemStack)copyOfLeft);
                event.setCost(maximumCost);
                event.setOutput(copyOfLeft);
            }
        }
        return event;
    }

    static {
        playerExistedTicks = new HashMap();
    }
}

