/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.repurpose.Blocks;

import com.wuest.repurpose.Base.TileBlockBase;
import com.wuest.repurpose.Config.RedstoneClockPowerConfiguration;
import com.wuest.repurpose.ModRegistry;
import com.wuest.repurpose.Repurpose;
import com.wuest.repurpose.Tiles.TileEntityRedstoneClock;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RedstoneClock
extends TileBlockBase<TileEntityRedstoneClock> {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    protected int tickRate = 20;

    public RedstoneClock(String name) {
        super(Material.field_151573_f, MapColor.field_151656_f);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
        ModRegistry.setBlockName(this, name);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            player.openGui((Object)Repurpose.instance, 5, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public int func_149738_a(World worldIn) {
        return this.tickRate;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        TileEntityRedstoneClock tileEntity = (TileEntityRedstoneClock)((Object)this.getLocalTileEntity((World)worldIn, pos));
        return tileEntity.getRedstoneStrength(blockState, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        TileEntityRedstoneClock tileEntity = (TileEntityRedstoneClock)((Object)this.getLocalTileEntity((World)worldIn, pos));
        return tileEntity.getRedstoneStrength(blockState, side);
    }

    @Override
    public void customBreakBlock(TileEntityRedstoneClock tileEntity, World worldIn, BlockPos pos, IBlockState state) {
        if (tileEntity.getRedstoneStrength(state, null) > 0) {
            this.updateNeighbors(worldIn, pos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    public void updateNeighbors(World worldIn, BlockPos pos) {
        this.notifyNeighborsOfStateChange(worldIn, pos, this);
    }

    public void notifyNeighborsOfStateChange(World worldIn, BlockPos pos, Block blockType) {
        if (ForgeEventFactory.onNeighborNotify((World)worldIn, (BlockPos)pos, (IBlockState)worldIn.func_180495_p(pos), EnumSet.allOf(EnumFacing.class), (boolean)true).isCanceled()) {
            return;
        }
        for (EnumFacing enumfacing : EnumFacing.values()) {
            worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, true);
        }
    }

    @Override
    public int customUpdateState(World worldIn, BlockPos pos, IBlockState state, TileEntityRedstoneClock tileEntity) {
        int i;
        int n = i = tileEntity.getRedstoneStrength(state, null) == 0 ? 15 : 0;
        if (i != 0) {
            for (EnumFacing facing : EnumFacing.values()) {
                if (!worldIn.func_175709_b(pos.func_177972_a(facing), facing.func_176734_d())) continue;
                i = 0;
                tileEntity.setRedstoneStrength(state, i, null);
                worldIn.func_180501_a(pos, state, 3);
                this.updateNeighbors(worldIn, pos);
                return 5;
            }
        }
        state = tileEntity.setRedstoneStrength(state, i, null);
        worldIn.func_180501_a(pos, state, 3);
        this.updateNeighbors(worldIn, pos);
        return i == 0 ? ((RedstoneClockPowerConfiguration)tileEntity.getConfig()).getUnPoweredTick() : ((RedstoneClockPowerConfiguration)tileEntity.getConfig()).getPoweredTick();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        Minecraft minecraft = Minecraft.func_71410_x();
        boolean advancedKeyDown = minecraft.field_71462_r.func_146272_n();
        if (!advancedKeyDown) {
            tooltip.add("Hold" + TextFormatting.BLUE + " Shift " + TextFormatting.GRAY + "for advanced information.");
        } else {
            tooltip.add("This simple clock is able to produce a redstone signal at configurable intervals.  Right Click to configure.");
        }
    }
}

