/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.repurpose.Blocks;

import com.wuest.repurpose.Base.TileBlockBase;
import com.wuest.repurpose.ModRegistry;
import com.wuest.repurpose.Repurpose;
import com.wuest.repurpose.Tiles.TileEntityRedstoneScanner;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRedstoneScanner
extends TileBlockBase<TileEntityRedstoneScanner> {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    protected static final AxisAlignedBB BOUNDING_AABB = new AxisAlignedBB(0.0625, 1.0E-5, 0.0625, 0.9375, 0.625, 0.9375);
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.125, 0.0625, 0.125, 0.875, 0.1875, 0.875);
    protected static final AxisAlignedBB STICK1_AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.3125, 0.625, 0.3125);
    protected static final AxisAlignedBB STICK2_AABB = new AxisAlignedBB(0.6875, 0.0, 0.6875, 0.8125, 0.625, 0.8125);
    protected static final AxisAlignedBB STICK3_AABB = new AxisAlignedBB(0.1875, 0.0, 0.6875, 0.3125, 0.625, 0.8125);
    protected static final AxisAlignedBB STICK4_AABB = new AxisAlignedBB(0.6875, 0.0, 0.1875, 0.8125, 0.625, 0.3125);
    protected int tickRate = 20;

    public BlockRedstoneScanner() {
        super(Material.field_151573_f, MapColor.field_151656_f);
        this.func_149647_a(CreativeTabs.field_78028_d);
        ModRegistry.setBlockName(this, "block_redstone_scanner");
        this.setHarvestLevel(null, 0);
        this.func_149711_c(0.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockRedstoneScanner.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)STICK1_AABB);
        BlockRedstoneScanner.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)STICK2_AABB);
        BlockRedstoneScanner.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)STICK3_AABB);
        BlockRedstoneScanner.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)STICK4_AABB);
        BlockRedstoneScanner.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        TileEntityRedstoneScanner tileEntity = (TileEntityRedstoneScanner)((Object)this.getLocalTileEntity((World)worldIn, pos));
        return tileEntity.getRedstoneStrength();
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        TileEntityRedstoneScanner tileEntity = (TileEntityRedstoneScanner)((Object)this.getLocalTileEntity((World)worldIn, pos));
        return tileEntity.getRedstoneStrength();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            player.openGui((Object)Repurpose.instance, 6, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public int func_149738_a(World worldIn) {
        return this.tickRate;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    @Override
    public int customUpdateState(World worldIn, BlockPos pos, IBlockState state, TileEntityRedstoneScanner tileEntity) {
        state = tileEntity.setRedstoneStrength(state);
        worldIn.func_180501_a(pos, state, 3);
        this.updateNeighbors(worldIn, pos);
        return tileEntity.getTickDelay();
    }

    @Override
    public void customBreakBlock(TileEntityRedstoneScanner tileEntity, World worldIn, BlockPos pos, IBlockState state) {
        if (tileEntity.getRedstoneStrength() > 0) {
            this.updateNeighbors(worldIn, pos);
        }
    }

    public void updateNeighbors(World worldIn, BlockPos pos) {
        this.notifyNeighborsOfStateChange(worldIn, pos, this);
        this.notifyNeighborsOfStateChange(worldIn, pos.func_177977_b(), this);
    }

    public void notifyNeighborsOfStateChange(World worldIn, BlockPos pos, Block blockType) {
        if (ForgeEventFactory.onNeighborNotify((World)worldIn, (BlockPos)pos, (IBlockState)worldIn.func_180495_p(pos), EnumSet.allOf(EnumFacing.class), (boolean)true).isCanceled()) {
            return;
        }
        worldIn.func_175685_c(pos.func_177976_e(), blockType, true);
        worldIn.func_175685_c(pos.func_177974_f(), blockType, true);
        worldIn.func_175685_c(pos.func_177977_b(), blockType, true);
        worldIn.func_175685_c(pos.func_177984_a(), blockType, true);
        worldIn.func_175685_c(pos.func_177978_c(), blockType, true);
        worldIn.func_175685_c(pos.func_177968_d(), blockType, true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        Minecraft minecraft = Minecraft.func_71410_x();
        boolean advancedKeyDown = minecraft.field_71462_r.func_146272_n();
        if (!advancedKeyDown) {
            tooltip.add("Hold" + TextFormatting.BLUE + " Shift " + TextFormatting.GRAY + "for advanced information.");
        } else {
            tooltip.add("This configurable machine is able to connect to nearby redstone sensitive devices, and send a signal to them based on nearby entities. Right Click to configure.");
        }
    }
}

