/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.repurpose.Blocks;

import com.wuest.repurpose.ModRegistry;
import com.wuest.repurpose.Proxy.CommonProxy;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCustomWall
extends Block {
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    protected static final AxisAlignedBB[] axis1 = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.3125, 1.0, 0.875, 0.6875), new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    protected static final AxisAlignedBB[] axis2 = new AxisAlignedBB[]{axis1[0].func_186666_e(1.5), axis1[1].func_186666_e(1.5), axis1[2].func_186666_e(1.5), axis1[3].func_186666_e(1.5), axis1[4].func_186666_e(1.5), axis1[5].func_186666_e(1.5), axis1[6].func_186666_e(1.5), axis1[7].func_186666_e(1.5), axis1[8].func_186666_e(1.5), axis1[9].func_186666_e(1.5), axis1[10].func_186666_e(1.5), axis1[11].func_186666_e(1.5), axis1[12].func_186666_e(1.5), axis1[13].func_186666_e(1.5), axis1[14].func_186666_e(1.5), axis1[15].func_186666_e(1.5)};
    public EnumType BlockVariant;

    public BlockCustomWall(Block modelBlock, EnumType variant) {
        super(variant.getMaterial());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a(VARIANT, (Comparable)((Object)variant)));
        this.func_149711_c(modelBlock.func_176195_g(null, null, null));
        this.func_149752_b(modelBlock.func_149638_a(null) * 5.0f / 3.0f);
        this.func_149672_a(modelBlock.func_185467_w());
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.setHarvestLevel("shovel", 0);
        this.BlockVariant = variant;
        if (this.BlockVariant == EnumType.DIRT) {
            this.func_149675_a(true);
        }
        ModRegistry.setBlockName(this, variant.getUnlocalizedName());
    }

    @SideOnly(value=Side.CLIENT)
    public static void RegisterBlockRenderer() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                return worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
            }
        }, new Block[]{ModRegistry.GrassWall()});
        Minecraft.func_71410_x().getItemColors().func_186731_a(new IItemColor(){

            public int getColorFromItemstack(ItemStack stack, int tintIndex) {
                ItemBlock itemBlock;
                Item item = stack.func_77973_b();
                if (item instanceof ItemBlock && (itemBlock = (ItemBlock)item).func_179223_d() instanceof BlockCustomWall) {
                    BlockCustomWall customWall = (BlockCustomWall)itemBlock.func_179223_d();
                    if (customWall.BlockVariant == EnumType.GRASS) {
                        BlockPos pos = Minecraft.func_71410_x().field_71439_g.func_180425_c();
                        WorldClient world = Minecraft.func_71410_x().field_71441_e;
                        return pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)world, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
                    }
                }
                return -1;
            }

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return this.getColorFromItemstack(stack, tintIndex);
            }
        }, new Block[]{ModRegistry.GrassWall()});
    }

    public static int getBlockIndex(IBlockState blockState) {
        int i = 0;
        if (((Boolean)blockState.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)blockState.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (((Boolean)blockState.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (((Boolean)blockState.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            if (CommonProxy.proxyConfiguration.enableGrassSpreadToCustomDirt && worldIn.func_175671_l(pos.func_177984_a()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    if (blockpos.func_177956_o() >= 0 && blockpos.func_177956_o() < 256 && !worldIn.func_175667_e(blockpos)) {
                        return;
                    }
                    IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177984_a());
                    IBlockState iblockstate1 = worldIn.func_180495_p(blockpos);
                    if (iblockstate1.func_177230_c() != Blocks.field_150349_c && iblockstate1.func_177230_c() != ModRegistry.GrassStairs() && iblockstate1.func_177230_c() != ModRegistry.GrassWall() && iblockstate1.func_177230_c() != ModRegistry.GrassSlab() && iblockstate1.func_177230_c() != ModRegistry.DoubleGrassSlab() || worldIn.func_175671_l(blockpos.func_177984_a()) < 4) continue;
                    IBlockState grassStairsState = ModRegistry.GrassWall().func_176223_P();
                    worldIn.func_180501_a(pos, grassStairsState, 3);
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModRegistry.DirtWall());
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return this.BlockVariant == EnumType.GRASS;
    }

    @SideOnly(value=Side.CLIENT)
    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.field_181083_K;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return axis1[BlockCustomWall.getBlockIndex(state)];
    }

    public AxisAlignedBB func_180640_a(IBlockState blockState, World worldIn, BlockPos pos) {
        blockState = this.func_176221_a(blockState, (IBlockAccess)worldIn, pos);
        return axis2[BlockCustomWall.getBlockIndex(blockState)];
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.isSideSolid(world, pos, EnumFacing.UP)) {
            return true;
        }
        return this instanceof BlockCustomWall;
    }

    public String func_149732_F() {
        return I18n.func_74838_a((String)(this.func_149739_a() + "." + BlockWall.EnumType.NORMAL.func_176659_c() + ".name"));
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        Material material = block.func_149688_o(iblockstate);
        if (block == Blocks.field_180401_cv) {
            return false;
        }
        return !(block instanceof BlockCustomWall) && !(block instanceof BlockFenceGate) ? (material.func_76218_k() && iblockstate.func_185917_h() ? material != Material.field_151572_C : false) : true;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean flag = this.canConnectTo(worldIn, pos.func_177978_c());
        boolean flag1 = this.canConnectTo(worldIn, pos.func_177974_f());
        boolean flag2 = this.canConnectTo(worldIn, pos.func_177968_d());
        boolean flag3 = this.canConnectTo(worldIn, pos.func_177976_e());
        boolean flag4 = flag && !flag1 && flag2 && !flag3 || !flag && flag1 && !flag2 && flag3;
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(!flag4 || !worldIn.func_175623_d(pos.func_177984_a()))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(flag)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(flag1)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(flag2)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(flag3));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, NORTH, EAST, WEST, SOUTH, VARIANT});
    }

    public static enum EnumType implements IStringSerializable
    {
        DIRT(0, "block_dirt_wall", "block_dirt_wall", Material.field_151578_c),
        GRASS(1, "block_grass_wall", "block_grass_wall", Material.field_151578_c);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private String unlocalizedName;
        private Material material;

        private EnumType(int meta, String name, String unlocalizedName, Material blockMaterial) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
            this.material = blockMaterial;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public Material getMaterial() {
            return this.material;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType customwall$enumtype;
                EnumType.META_LOOKUP[customwall$enumtype.getMetadata()] = customwall$enumtype = enumTypeArray[i];
            }
        }
    }
}

