/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.repurpose.Base;

import com.wuest.repurpose.Base.BaseConfig;
import com.wuest.repurpose.Capabilities.ITransferable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public abstract class TileEntityBase<T extends BaseConfig>
extends TileEntity {
    protected T config;
    protected ArrayList<Capability> allowedCapabilities;

    protected TileEntityBase() {
    }

    public T getConfig() {
        return this.config;
    }

    public void setConfig(T value) {
        this.config = value;
        this.func_70296_d();
    }

    public ArrayList<Capability> getAllowedCapabilities() {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList();
            this.addAllowedCapabilities();
        }
        return this.allowedCapabilities;
    }

    public void setAllowedCapabilities(ArrayList<Capability> allowedCapabilities) {
        this.allowedCapabilities = allowedCapabilities;
        this.func_70296_d();
    }

    public ItemStack transferCapabilities(ItemStack stack) {
        for (Capability allowedCapability : this.getAllowedCapabilities()) {
            Object stackCapability = stack.getCapability(allowedCapability, EnumFacing.NORTH);
            Object tileEntityCapability = this.getCapability(allowedCapability, EnumFacing.NORTH);
            if (stackCapability == null || tileEntityCapability == null || !(stackCapability instanceof ITransferable) || !(tileEntityCapability instanceof ITransferable)) continue;
            ((ITransferable)stackCapability).Transfer((ITransferable)tileEntityCapability);
        }
        return stack;
    }

    public Class<T> getTypeParameterClass() {
        Type type = ((Object)((Object)this)).getClass().getGenericSuperclass();
        ParameterizedType paramType = (ParameterizedType)type;
        return (Class)paramType.getActualTypeArguments()[0];
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        if (this.field_174879_c.func_177958_n() == 0 && this.field_174879_c.func_177956_o() == 0 && this.field_174879_c.func_177952_p() == 0) {
            return super.func_189518_D_();
        }
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public void onChunkUnload() {
        this.func_189515_b(this.getTileData());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean func_145842_c(int id, int type) {
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_145836_u() {
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.config != null) {
            ((BaseConfig)this.config).WriteToNBTCompound(compound);
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.config = ((BaseConfig)this.createConfigInstance()).ReadFromNBTTagCompound(compound);
    }

    public T createConfigInstance() {
        try {
            return (T)((BaseConfig)this.getTypeParameterClass().newInstance());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void addAllowedCapabilities() {
    }
}

