/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.stackie.proxy;

import com.github.lunatrius.stackie.command.StackieCommand;
import com.github.lunatrius.stackie.handler.ConfigurationHandler;
import com.github.lunatrius.stackie.handler.StackingHandlerTick;
import com.github.lunatrius.stackie.reference.Reference;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;

public abstract class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        Reference.logger = event.getModLog();
        FMLInterModComms.sendMessage((String)"LunatriusCore", (String)"checkUpdate", (String)"14.23.0.2512");
    }

    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)StackingHandlerTick.INSTANCE);
    }

    public void postInit(FMLPostInitializationEvent event) {
        for (String info : ConfigurationHandler.General.stackSizes) {
            String[] parts = info.split("-");
            if (parts.length != 2) continue;
            try {
                String uniqueName = parts[0];
                int stackSize = MathHelper.func_76125_a((int)Integer.parseInt(parts[1], 10), (int)1, (int)64);
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(uniqueName));
                if (item == null) continue;
                item.func_77625_d(stackSize);
            }
            catch (Exception e) {
                Reference.logger.error("Invalid format?", (Throwable)e);
            }
        }
    }

    public void serverStarting(FMLServerStartingEvent event) {
        StackingHandlerTick.INSTANCE.setServer(event.getServer());
        event.registerServerCommand((ICommand)new StackieCommand());
    }

    public void serverStopping(FMLServerStoppingEvent event) {
        StackingHandlerTick.INSTANCE.setServer(null);
    }
}

