/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.stackie.handler;

import com.github.lunatrius.stackie.handler.ConfigurationHandler;
import com.github.lunatrius.stackie.handler.StackingHandler;
import com.github.lunatrius.stackie.reference.Reference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class StackingHandlerTick
extends StackingHandler {
    public static final StackingHandlerTick INSTANCE = new StackingHandlerTick();
    private MinecraftServer server = null;
    private int ticks = -1;

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (--this.ticks < 0) {
            if (this.server != null && this.server.field_71305_c != null) {
                this.processWorlds(this.server.field_71305_c);
            }
            this.ticks = ConfigurationHandler.General.interval;
        }
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    private void processWorlds(WorldServer[] worldServers) {
        for (WorldServer world : worldServers) {
            ArrayList<EntityItem> entityItems = new ArrayList<EntityItem>();
            ArrayList<EntityXPOrb> entityExperienceOrbs = new ArrayList<EntityXPOrb>();
            for (Entity entity : world.field_72996_f) {
                if (entity.field_70128_L) continue;
                Class<?> clazz = entity.getClass();
                if (EntityItem.class.equals(clazz)) {
                    entityItems.add((EntityItem)entity);
                    continue;
                }
                if (!EntityXPOrb.class.equals(clazz)) continue;
                entityExperienceOrbs.add((EntityXPOrb)entity);
            }
            if (entityItems.size() >= 2 && entityItems.size() <= ConfigurationHandler.General.stackLimit) {
                try {
                    this.stackItems(Lists.reverse(entityItems));
                }
                catch (Exception e) {
                    Reference.logger.error("Could not stack items!", (Throwable)e);
                }
            }
            if (entityExperienceOrbs.size() < 2 || entityExperienceOrbs.size() > ConfigurationHandler.General.stackLimit) continue;
            try {
                this.stackExperience(Lists.reverse(entityExperienceOrbs));
            }
            catch (Exception e) {
                Reference.logger.error("Could not stack experience!", (Throwable)e);
            }
        }
    }

    private void stackItems(List<EntityItem> entityItems) {
        ListIterator<EntityItem> iteratorL = entityItems.listIterator();
        while (iteratorL.hasNext()) {
            EntityItem entityItemL = iteratorL.next();
            if (entityItemL.field_70128_L) continue;
            ListIterator<EntityItem> iteratorR = entityItems.listIterator(iteratorL.nextIndex());
            while (iteratorR.hasNext()) {
                boolean merged;
                EntityItem entityItemR = iteratorR.next();
                if (entityItemR.field_70128_L || !this.areEntitiesClose((Entity)entityItemL, (Entity)entityItemR) || !(merged = this.stackItems(entityItemL, entityItemR))) continue;
                entityItemR.func_70106_y();
            }
        }
    }

    private void stackExperience(List<EntityXPOrb> entityOrbs) {
        ListIterator<EntityXPOrb> iteratorL = entityOrbs.listIterator();
        while (iteratorL.hasNext()) {
            EntityXPOrb entityOrbL = iteratorL.next();
            if (entityOrbL.field_70128_L) continue;
            ListIterator<EntityXPOrb> iteratorR = entityOrbs.listIterator(iteratorL.nextIndex());
            while (iteratorR.hasNext()) {
                boolean merged;
                EntityXPOrb entityOrbR = iteratorR.next();
                if (entityOrbR.field_70128_L || !this.areEntitiesClose((Entity)entityOrbL, (Entity)entityOrbR) || !(merged = this.stackExperience(entityOrbL, entityOrbR))) continue;
                entityOrbR.func_70106_y();
            }
        }
    }
}

