/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.forestry.filters;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.network.NetworkUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.integration.forestry.filters.SpeciesMode;
import crazypants.enderio.util.Prep;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandler;

public class SpeciesItemFilter
implements IInventory,
IItemFilter.WithGhostSlots {
    private static final boolean DEFAULT_BLACKLIST = false;
    private static final boolean DEFAULT_STICKY = false;
    private static final SpeciesMode DEFAULT_SPECIES_MODE = SpeciesMode.BOTH;
    boolean isBlacklist = false;
    boolean sticky = false;
    SpeciesMode speciesMode = DEFAULT_SPECIES_MODE;
    private NNList<ItemStack> items;
    private String[] primarySpeciesUids;
    private String[] secondarySpeciesUids;

    public void copyFrom(SpeciesItemFilter o) {
        this.isBlacklist = o.isBlacklist;
        this.sticky = o.sticky;
        this.speciesMode = o.speciesMode;
        this.items = o.items;
        this.primarySpeciesUids = o.primarySpeciesUids;
        this.secondarySpeciesUids = o.secondarySpeciesUids;
    }

    public SpeciesItemFilter() {
        this(10);
    }

    private SpeciesItemFilter(int numItems) {
        this.items = new NNList(numItems, (Object)ItemStack.field_190927_a);
        this.primarySpeciesUids = new String[numItems];
        this.secondarySpeciesUids = new String[numItems];
    }

    public boolean doesItemPassFilter(@Nullable IItemHandler inventory, @Nonnull ItemStack item) {
        return this.doesItemPassFilter(item);
    }

    public boolean doesItemPassFilter(@Nonnull ItemStack item) {
        if (!this.isValid()) {
            return true;
        }
        boolean matched = this.itemMatched(item);
        return this.isBlacklist ? !matched : matched;
    }

    private boolean itemMatched(@Nonnull ItemStack item) {
        if (Prep.isInvalid((ItemStack)item)) {
            return false;
        }
        ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(item);
        if (speciesRoot == null) {
            return false;
        }
        IIndividual member = speciesRoot.getMember(item);
        if (member == null) {
            return false;
        }
        IGenome genome = member.getGenome();
        String primarySpeciesUid = genome.getPrimary().getUID();
        String secondarySpeciesUid = genome.getSecondary().getUID();
        block5: for (int slot = 0; slot < this.items.size(); ++slot) {
            ItemStack slotItem = (ItemStack)this.items.get(slot);
            if (slotItem.func_77973_b() != item.func_77973_b()) continue;
            switch (this.speciesMode) {
                case BOTH: {
                    if (!this.primarySpeciesUids[slot].equals(primarySpeciesUid) || !this.secondarySpeciesUids[slot].equals(secondarySpeciesUid)) continue block5;
                    return true;
                }
                case PRIMARY: {
                    if (!this.primarySpeciesUids[slot].equals(primarySpeciesUid)) continue block5;
                    return true;
                }
                case SECONDARY: {
                    if (!this.secondarySpeciesUids[slot].equals(secondarySpeciesUid)) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isValid() {
        for (ItemStack item : this.items) {
            if (item.func_190926_b() || AlleleManager.alleleRegistry.getSpeciesRoot(item) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isBlacklist() {
        return this.isBlacklist;
    }

    public void setBlacklist(boolean isBlacklist) {
        this.isBlacklist = isBlacklist;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public SpeciesMode getSpeciesMode() {
        return this.speciesMode;
    }

    public void setSpeciesMode(SpeciesMode mode) {
        this.speciesMode = mode;
    }

    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        nbtRoot.func_74757_a("isBlacklist", this.isBlacklist);
        nbtRoot.func_74757_a("sticky", this.sticky);
        nbtRoot.func_74774_a("speciesMode", (byte)this.speciesMode.ordinal());
        int i = 0;
        for (ItemStack item : this.items) {
            if (item != null) {
                nbtRoot.func_74782_a("item" + i, (NBTBase)item.serializeNBT());
            }
            ++i;
        }
    }

    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        this.isBlacklist = nbtRoot.func_74767_n("isBlacklist");
        this.sticky = nbtRoot.func_74767_n("sticky");
        this.speciesMode = SpeciesMode.values()[nbtRoot.func_74771_c("speciesMode") & 0xFF];
        int numItems = 10;
        this.items = new NNList(numItems, (Object)ItemStack.field_190927_a);
        this.primarySpeciesUids = new String[numItems];
        this.secondarySpeciesUids = new String[numItems];
        for (int i = 0; i < numItems; ++i) {
            NBTBase tag = nbtRoot.func_74781_a("item" + i);
            ItemStack itemStack = ItemStack.field_190927_a;
            if (tag instanceof NBTTagCompound) {
                itemStack = new ItemStack((NBTTagCompound)tag);
            }
            this.setItem(i, itemStack);
        }
    }

    @Nonnull
    private ItemStack setItem(int slot, @Nonnull ItemStack itemStack) {
        IIndividual member;
        if (slot < 0 || slot >= this.items.size()) {
            return ItemStack.field_190927_a;
        }
        ItemStack prevStack = (ItemStack)this.items.get(slot);
        if (!prevStack.func_190926_b()) {
            this.primarySpeciesUids[slot] = null;
            this.secondarySpeciesUids[slot] = null;
        }
        this.items.set(slot, (Object)itemStack);
        ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(itemStack);
        if (speciesRoot != null && (member = speciesRoot.getMember(itemStack)) != null) {
            IGenome genome = member.getGenome();
            this.primarySpeciesUids[slot] = genome.getPrimary().getUID();
            this.secondarySpeciesUids[slot] = genome.getSecondary().getUID();
        }
        return prevStack;
    }

    public void writeToByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound root = new NBTTagCompound();
        this.writeToNBT(root);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)root, (ByteBuf)buf);
    }

    public void readFromByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound tag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.readFromNBT(tag);
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    @Nonnull
    public ItemStack func_70301_a(int i) {
        if (i < 0 || i >= this.items.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.items.get(i);
    }

    @Nonnull
    public ItemStack func_70298_a(int fromSlot, int amount) {
        this.setItem(fromSlot, ItemStack.field_190927_a);
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int i, @Nonnull ItemStack itemstack) {
        ItemStack copy = itemstack.func_77946_l();
        copy.func_190920_e(0);
        this.setItem(i, copy);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return this.setItem(index, ItemStack.field_190927_a);
    }

    public void func_174888_l() {
        for (int i = 0; i < this.items.size(); ++i) {
            this.setItem(i, ItemStack.field_190927_a);
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return "Species Item Filter";
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return true;
    }

    public void func_174889_b(@Nonnull EntityPlayer e) {
    }

    public void func_174886_c(@Nonnull EntityPlayer e) {
    }

    public boolean func_94041_b(int i, @Nonnull ItemStack itemstack) {
        return true;
    }

    public void createGhostSlots(@Nonnull NNList<GhostSlot> slots, int xOffset, int yOffset, @Nullable Runnable cb) {
        int index = 0;
        int numRows = 2;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < 5; ++col) {
                int x = xOffset + col * 18;
                int y = yOffset + row * 20;
                slots.add((Object)new ItemFilterGhostSlot(index, x, y, cb));
                ++index;
            }
        }
    }

    public int getSlotCount() {
        return this.func_70302_i_();
    }

    public boolean isDefault() {
        return !this.isValid() && !this.isBlacklist && this.speciesMode == DEFAULT_SPECIES_MODE && !this.sticky;
    }

    public String toString() {
        return "SpeciesItemFilter [speciesMode=" + (Object)((Object)this.speciesMode) + ", items=" + this.items + "]";
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public boolean func_191420_l() {
        return this.items.isEmpty() || this.items.stream().allMatch(ItemStack::func_190926_b);
    }

    class ItemFilterGhostSlot
    extends GhostSlot {
        private final Runnable cb;

        ItemFilterGhostSlot(int slot, int x, int y, Runnable cb) {
            this.setX(x);
            this.setY(y);
            this.setSlot(slot);
            this.cb = cb;
        }

        public void putStack(@Nonnull ItemStack stack, int realsize) {
            if (AlleleManager.alleleRegistry.getSpeciesRoot(stack) != null) {
                stack = stack.func_77946_l();
                stack.func_190920_e(1);
                SpeciesItemFilter.this.setItem(this.getSlot(), stack);
            } else {
                SpeciesItemFilter.this.setItem(this.getSlot(), ItemStack.field_190927_a);
            }
            this.cb.run();
        }

        @Nonnull
        public ItemStack getStack() {
            return SpeciesItemFilter.this.func_70301_a(this.getSlot());
        }
    }
}

