/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.asm;

import com.google.gson.Gson;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.forge.asm.IOTGASMBiome;
import com.pg85.otg.forge.dimensions.WorldProviderOTG;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class OTGHooks {
    public static int getIDForObject(Biome biome) {
        return ((IOTGASMBiome)biome).getSavedId();
    }

    public static double getGravityFactor(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof WorldProviderOTG) {
            return ((WorldProviderOTG)entity.field_70170_p.field_73011_w).getGravityFactor();
        }
        return 0.08;
    }

    public static double getGravityFactorMineCart(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof WorldProviderOTG) {
            double baseGravityFactor = (Double)WorldStandardValues.gravityFactor.getDefaultValue();
            double gravityFactor = ((WorldProviderOTG)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)0.04f * (gravityFactor / baseGravityFactor);
        }
        return 0.04f;
    }

    public static double getGravityFactorArrow(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof WorldProviderOTG) {
            double baseGravityFactor = (Double)WorldStandardValues.gravityFactor.getDefaultValue();
            double gravityFactor = ((WorldProviderOTG)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)0.05f * (gravityFactor / baseGravityFactor);
        }
        return 0.05f;
    }

    public static double getGravityFactorBoat(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof WorldProviderOTG) {
            double baseGravityFactor = (Double)WorldStandardValues.gravityFactor.getDefaultValue();
            double gravityFactor = ((WorldProviderOTG)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)-0.04f * (gravityFactor / baseGravityFactor);
        }
        return -0.04f;
    }

    public static double getGravityFactorFallingBlock(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof WorldProviderOTG) {
            double baseGravityFactor = (Double)WorldStandardValues.gravityFactor.getDefaultValue();
            double gravityFactor = ((WorldProviderOTG)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)0.04f * (gravityFactor / baseGravityFactor);
        }
        return 0.04f;
    }

    public static double getGravityFactorItem(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof WorldProviderOTG) {
            double baseGravityFactor = (Double)WorldStandardValues.gravityFactor.getDefaultValue();
            double gravityFactor = ((WorldProviderOTG)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)0.04f * (gravityFactor / baseGravityFactor);
        }
        return 0.04f;
    }

    public static double getGravityFactorLlamaSpit(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof WorldProviderOTG) {
            double baseGravityFactor = (Double)WorldStandardValues.gravityFactor.getDefaultValue();
            double gravityFactor = ((WorldProviderOTG)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)0.06f * (gravityFactor / baseGravityFactor);
        }
        return 0.06f;
    }

    public static double getGravityFactorShulkerBullet(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof WorldProviderOTG) {
            double baseGravityFactor = (Double)WorldStandardValues.gravityFactor.getDefaultValue();
            double gravityFactor = ((WorldProviderOTG)entity.field_70170_p.field_73011_w).getGravityFactor();
            return 0.04 * (gravityFactor / baseGravityFactor);
        }
        return 0.04;
    }

    public static float getGravityFactorThrowable(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof WorldProviderOTG) {
            double baseGravityFactor = (Double)WorldStandardValues.gravityFactor.getDefaultValue();
            double gravityFactor = ((WorldProviderOTG)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (float)((double)0.03f * (gravityFactor / baseGravityFactor));
        }
        return 0.03f;
    }

    public static double getGravityFactorTNTPrimed(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof WorldProviderOTG) {
            double baseGravityFactor = (Double)WorldStandardValues.gravityFactor.getDefaultValue();
            double gravityFactor = ((WorldProviderOTG)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)0.04f * (gravityFactor / baseGravityFactor);
        }
        return 0.04f;
    }

    public static double getGravityFactorXPOrb(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof WorldProviderOTG) {
            double baseGravityFactor = (Double)WorldStandardValues.gravityFactor.getDefaultValue();
            double gravityFactor = ((WorldProviderOTG)entity.field_70170_p.field_73011_w).getGravityFactor();
            return (double)0.03f * (gravityFactor / baseGravityFactor);
        }
        return 0.03f;
    }

    public static double getFallDamageFactor(double y, Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof WorldProviderOTG) {
            return ((WorldProviderOTG)entity.field_70170_p.field_73011_w).getFallDamageFactor(y);
        }
        return y;
    }

    public static int countMissingRegistryEntries(LinkedHashMap<ResourceLocation, Map<ResourceLocation, Integer>> missing) {
        int count;
        if (missing.containsKey(new ResourceLocation("minecraft", "biomes"))) {
            Gson gson = new Gson();
            ArrayList<ResourceLocation> biomesToRemove = new ArrayList<ResourceLocation>();
            Map<ResourceLocation, Integer> biomes = missing.get(new ResourceLocation("minecraft", "biomes"));
            for (ResourceLocation biomeResourceLocation : biomes.keySet()) {
                String jsonInString;
                if (biomeResourceLocation == null || !(jsonInString = gson.toJson((Object)biomeResourceLocation)).contains(":\"openterraingenerator\",")) continue;
                biomesToRemove.add(biomeResourceLocation);
            }
            for (ResourceLocation biomeResourceLocation : biomesToRemove) {
                biomes.remove(biomeResourceLocation);
            }
        }
        if ((count = missing.values().stream().mapToInt(Map::size).sum()) > 0) {
            System.out.println("Items/Blocks/Biomes appear to be missing from the registry. Forge will show an error message about this and you will not be able to join the world. Forge will display a list of missing registry entries, you can ignore any otg biomes on that list as they do not actually need to be registered. The missing registries error is caused by other mods, not OTG.");
        }
        return count;
    }
}

