/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.recipes;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import zabi.minecraft.extraalchemy.lib.Log;
import zabi.minecraft.extraalchemy.potion.PotionTypeBase;

public class GsonRecipe {
    public int level = 0;
    public int durationSeconds = 0;
    public String ingredient = "";
    public String basePotionType = "minecraft:awkward";
    public String effect = "";
    public String name = "";
    public boolean autoGenerateStrongVersion = false;
    public boolean autoGenerateLongVersion = false;
    public int durationLongVersion = 0;
    public int durationStrongVersion = 0;

    public boolean check() {
        if (this.name.trim().length() == 0) {
            Log.e("Potion custom name is empty");
            return false;
        }
        if (this.effect.trim().length() == 0) {
            Log.e("Potion effect is empty");
            return false;
        }
        if (this.basePotionType.trim().length() == 0) {
            Log.e("Potion base type is empty");
            return false;
        }
        if (this.ingredient.trim().length() == 0) {
            Log.e("Potion ingredient is empty");
            return false;
        }
        String ingredientItem = this.ingredient.split("@")[0];
        if (!ForgeRegistries.POTIONS.containsKey(GsonRecipe.r(this.effect))) {
            Log.e("Potion effect doesn't exist: " + this.effect);
            return false;
        }
        if (!ForgeRegistries.POTION_TYPES.containsKey(GsonRecipe.r(this.basePotionType))) {
            Log.e("Potion base type doesn't exist: " + this.basePotionType);
            return false;
        }
        if (!ForgeRegistries.ITEMS.containsKey(GsonRecipe.r(ingredientItem))) {
            Log.e("Potion ingredient doesn't exist: " + ingredientItem);
            return false;
        }
        Potion p = (Potion)ForgeRegistries.POTIONS.getValue(GsonRecipe.r(this.effect));
        if (p.func_76403_b() != (this.durationSeconds == 0) && p.func_76403_b() == !this.autoGenerateLongVersion && p.func_76403_b() == (this.durationLongVersion == 0) && p.func_76403_b() == (this.durationStrongVersion == 0)) {
            Log.e("An instant potion cannot have non-zero durations. Non instant potions must specify a non-zero duration");
            return false;
        }
        return true;
    }

    private static ResourceLocation r(String s) {
        return new ResourceLocation(s);
    }

    public ItemStack getIngredient() {
        String[] parts = this.ingredient.split("@");
        return new ItemStack((Item)ForgeRegistries.ITEMS.getValue(GsonRecipe.r(parts[0])), 1, parts.length > 1 ? Integer.parseInt(parts[1]) : Short.MAX_VALUE);
    }

    private Potion getEffect() {
        return (Potion)ForgeRegistries.POTIONS.getValue(GsonRecipe.r(this.effect));
    }

    public PotionType getBase() {
        return (PotionType)ForgeRegistries.POTION_TYPES.getValue(GsonRecipe.r(this.basePotionType));
    }

    public PotionTypeBase generateType() {
        return new PotionTypeBase(this.getEffect(), this.durationSeconds * 20, this.level, this.name);
    }

    public PotionTypeBase generateTypeLong() {
        return new PotionTypeBase(this.getEffect(), this.durationLongVersion * 20, this.level, this.name + "_long");
    }

    public PotionTypeBase generateTypeStrong() {
        return new PotionTypeBase(this.getEffect(), this.durationStrongVersion * 20, this.level + 1, this.name + "_strong");
    }
}

