/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.client;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zabi.minecraft.extraalchemy.ModConfig;
import zabi.minecraft.extraalchemy.integration.ModIDs;
import zabi.minecraft.extraalchemy.items.MinervaMedal;
import zabi.minecraft.extraalchemy.potion.PotionTypeBase;

@SideOnly(value=Side.CLIENT)
public class PotionDescriptionTooltipHandler {
    @SubscribeEvent
    public void onTooltipEvent(ItemTooltipEvent evt) {
        PotionType pt;
        List toolTip = evt.getToolTip();
        if (evt.getItemStack().func_77973_b() == MinervaMedal.medal) {
            return;
        }
        if (evt.getItemStack().func_77942_o() && evt.getItemStack().func_77978_p().func_74764_b("splitresult")) {
            toolTip.add(I18n.func_135052_a((String)"item.byproduct", (Object[])new Object[0]).replace("%", "" + evt.getItemStack().func_77978_p().func_74762_e("splitresult")));
        }
        if ((pt = PotionUtils.func_185191_c((ItemStack)evt.getItemStack())) instanceof PotionTypeBase && !((PotionTypeBase)pt).isArtificial()) {
            String potName = ((PotionTypeBase)pt).getPotion().func_76393_a();
            String textRaw = I18n.func_135052_a((String)("description." + potName), (Object[])new Object[0]);
            String badJoke = I18n.func_135052_a((String)("funny." + potName), (Object[])new Object[0]);
            PotionDescriptionTooltipHandler.addCredits(toolTip, "Extra Alchemy", evt.getItemStack());
            if (ModConfig.client.showBadJoke) {
                toolTip.add(ChatFormatting.GREEN + ChatFormatting.ITALIC.toString() + I18n.func_135052_a((String)badJoke, (Object[])new Object[0]));
            }
            if (PotionDescriptionTooltipHandler.shouldShowHint(evt.getFlags().func_194127_a())) {
                toolTip.add("");
                toolTip.add(textRaw);
            } else if (!ModConfig.client.descriptionMode.name().equals("NONE")) {
                toolTip.add(I18n.func_135052_a((String)("tooltip.togglef3." + ModConfig.client.descriptionMode.name()), (Object[])new Object[0]));
            }
        } else if (!pt.func_185170_a().isEmpty()) {
            PotionDescriptionTooltipHandler.addCredits(toolTip, ModIDs.getModName(pt.getRegistryName().func_110624_b()), evt.getItemStack());
        }
    }

    private static boolean shouldShowHint(boolean advTooltips) {
        return advTooltips && ModConfig.client.descriptionMode == ModConfig.Mode.F3H || GuiScreen.func_175283_s() && ModConfig.client.descriptionMode == ModConfig.Mode.ALT || GuiScreen.func_146271_m() && ModConfig.client.descriptionMode == ModConfig.Mode.CTRL || GuiScreen.func_146272_n() && ModConfig.client.descriptionMode == ModConfig.Mode.SHIFT;
    }

    private static void addCredits(List<String> toolTip, String modname, ItemStack stack) {
        if (!PotionDescriptionTooltipHandler.isVanillaItem(stack)) {
            toolTip.add("");
            toolTip.add(ChatFormatting.GOLD + I18n.func_135052_a((String)"tooltip.credit", (Object[])new Object[]{modname}));
        }
    }

    private static boolean isVanillaItem(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151068_bn || stack.func_77973_b() == Items.field_185156_bI || stack.func_77973_b() == Items.field_185155_bH || stack.func_77973_b() == Items.field_185167_i;
    }
}

