/*
 * Decompiled with CFR 0.152.
 */
package panda.divergentunderground.integration;

import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismFluids;
import mekanism.common.MekanismItems;
import mekanism.common.Resource;
import mekanism.common.recipe.RecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import panda.divergentunderground.DivergentUnderground;
import panda.divergentunderground.experimental.CompatibilityPlugin;
import panda.divergentunderground.experimental.ICompatibilityPlugin;
import panda.divergentunderground.init.ModBlocks;
import panda.divergentunderground.init.ModItems;
import panda.divergentunderground.proxy.ClientProxy;
import panda.divergentunderground.registries.OreRegistry;
import panda.divergentunderground.registries.RockRegistry;

@CompatibilityPlugin(value="mekanism")
public class MekanismCompat
implements ICompatibilityPlugin {
    private static final String texturePath = "mekanism:blocks/";
    private static final String modid = "mekanism";
    public static final Block ORE_BLOCK = MekanismBlocks.OreBlock;
    public static final Block HARD_OSMIUM = ModBlocks.makeHardBlock(ORE_BLOCK.func_176203_a(0), 1, "mekanism:blocks/osmiumore", "mekanism", "osmium");
    public static final Block HARD_COPPER = ModBlocks.makeHardBlock(ORE_BLOCK.func_176203_a(1), 1, "mekanism:blocks/copperore", "mekanism", "copper");
    public static final Block HARD_TIN = ModBlocks.makeHardBlock(ORE_BLOCK.func_176203_a(2), 1, "mekanism:blocks/tinore", "mekanism", "tin");
    public static final Item ORE_OSMIUM = ModItems.makeOre("mekanism", "osmium");
    public static final Item ORE_COPPER = ModItems.makeOre("mekanism", "copper");
    public static final Item ORE_TIN = ModItems.makeOre("mekanism", "tin");

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void init() {
        RockRegistry.addRock(ORE_BLOCK, 0, ModItems.ROCK_STONE);
        RockRegistry.addRock(ORE_BLOCK, 1, ModItems.ROCK_STONE);
        RockRegistry.addRock(ORE_BLOCK, 2, ModItems.ROCK_STONE);
        OreRegistry.addOre(ORE_BLOCK, 0, ORE_OSMIUM);
        OreRegistry.addOre(ORE_BLOCK, 1, ORE_COPPER);
        OreRegistry.addOre(ORE_BLOCK, 2, ORE_TIN);
        GameRegistry.addSmelting((Item)ORE_OSMIUM, (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 1), (float)1.0f);
        GameRegistry.addSmelting((Item)ORE_COPPER, (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 5), (float)1.0f);
        GameRegistry.addSmelting((Item)ORE_TIN, (ItemStack)new ItemStack(MekanismItems.Ingot, 1, 6), (float)1.0f);
        RecipeHandler.addEnrichmentChamberRecipe((ItemStack)new ItemStack(ORE_OSMIUM), (ItemStack)new ItemStack(MekanismItems.Dust, 2, Resource.OSMIUM.ordinal()));
        RecipeHandler.addEnrichmentChamberRecipe((ItemStack)new ItemStack(ORE_COPPER), (ItemStack)new ItemStack(MekanismItems.Dust, 2, Resource.COPPER.ordinal()));
        RecipeHandler.addEnrichmentChamberRecipe((ItemStack)new ItemStack(ORE_TIN), (ItemStack)new ItemStack(MekanismItems.Dust, 2, Resource.TIN.ordinal()));
        RecipeHandler.addEnrichmentChamberRecipe((ItemStack)new ItemStack(ModItems.ORE_IRON), (ItemStack)new ItemStack(MekanismItems.Dust, 2, Resource.TIN.ordinal()));
        RecipeHandler.addEnrichmentChamberRecipe((ItemStack)new ItemStack(ModItems.ORE_GOLD), (ItemStack)new ItemStack(MekanismItems.Dust, 2, Resource.TIN.ordinal()));
        RecipeHandler.addChemicalDissolutionChamberRecipe((ItemStack)new ItemStack(ORE_OSMIUM), (GasStack)new GasStack(GasRegistry.getGas((String)"osmium"), 1000));
        RecipeHandler.addChemicalDissolutionChamberRecipe((ItemStack)new ItemStack(ORE_COPPER), (GasStack)new GasStack(GasRegistry.getGas((String)"copper"), 1000));
        RecipeHandler.addChemicalDissolutionChamberRecipe((ItemStack)new ItemStack(ORE_TIN), (GasStack)new GasStack(GasRegistry.getGas((String)"tin"), 1000));
        RecipeHandler.addChemicalDissolutionChamberRecipe((ItemStack)new ItemStack(ModItems.ORE_IRON), (GasStack)new GasStack(GasRegistry.getGas((String)"tin"), 1000));
        RecipeHandler.addChemicalDissolutionChamberRecipe((ItemStack)new ItemStack(ModItems.ORE_GOLD), (GasStack)new GasStack(GasRegistry.getGas((String)"tin"), 1000));
        RecipeHandler.addPurificationChamberRecipe((ItemStack)new ItemStack(ORE_OSMIUM), (ItemStack)new ItemStack(MekanismItems.Clump, 3, Resource.OSMIUM.ordinal()));
        RecipeHandler.addPurificationChamberRecipe((ItemStack)new ItemStack(ORE_COPPER), (ItemStack)new ItemStack(MekanismItems.Clump, 3, Resource.COPPER.ordinal()));
        RecipeHandler.addPurificationChamberRecipe((ItemStack)new ItemStack(ORE_TIN), (ItemStack)new ItemStack(MekanismItems.Clump, 3, Resource.TIN.ordinal()));
        RecipeHandler.addPurificationChamberRecipe((ItemStack)new ItemStack(ModItems.ORE_IRON), (ItemStack)new ItemStack(MekanismItems.Clump, 3, Resource.TIN.ordinal()));
        RecipeHandler.addPurificationChamberRecipe((ItemStack)new ItemStack(ModItems.ORE_GOLD), (ItemStack)new ItemStack(MekanismItems.Clump, 3, Resource.TIN.ordinal()));
        RecipeHandler.addChemicalInjectionChamberRecipe((ItemStack)new ItemStack(ORE_OSMIUM), (Gas)MekanismFluids.HydrogenChloride, (ItemStack)new ItemStack(MekanismItems.Shard, 4, Resource.OSMIUM.ordinal()));
        RecipeHandler.addChemicalInjectionChamberRecipe((ItemStack)new ItemStack(ORE_COPPER), (Gas)MekanismFluids.HydrogenChloride, (ItemStack)new ItemStack(MekanismItems.Shard, 4, Resource.COPPER.ordinal()));
        RecipeHandler.addChemicalInjectionChamberRecipe((ItemStack)new ItemStack(ORE_TIN), (Gas)MekanismFluids.HydrogenChloride, (ItemStack)new ItemStack(MekanismItems.Shard, 4, Resource.TIN.ordinal()));
        RecipeHandler.addChemicalInjectionChamberRecipe((ItemStack)new ItemStack(ModItems.ORE_IRON), (Gas)MekanismFluids.HydrogenChloride, (ItemStack)new ItemStack(MekanismItems.Shard, 4, Resource.TIN.ordinal()));
        RecipeHandler.addChemicalInjectionChamberRecipe((ItemStack)new ItemStack(ModItems.ORE_GOLD), (Gas)MekanismFluids.HydrogenChloride, (ItemStack)new ItemStack(MekanismItems.Shard, 4, Resource.TIN.ordinal()));
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)HARD_OSMIUM);
        registry.register((IForgeRegistryEntry)HARD_COPPER);
        registry.register((IForgeRegistryEntry)HARD_TIN);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)ORE_OSMIUM);
        registry.register((IForgeRegistryEntry)ORE_COPPER);
        registry.register((IForgeRegistryEntry)ORE_TIN);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, HARD_OSMIUM);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, HARD_COPPER);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, HARD_TIN);
        DivergentUnderground.doDicts("Copper", ORE_COPPER, HARD_COPPER);
        DivergentUnderground.doDicts("Tin", ORE_TIN, HARD_TIN);
        DivergentUnderground.doDicts("Osmium", ORE_OSMIUM, HARD_OSMIUM);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        ClientProxy.registerItemModel(ORE_OSMIUM);
        ClientProxy.registerBlockModel(HARD_OSMIUM);
        ClientProxy.registerItemModel(ORE_COPPER);
        ClientProxy.registerBlockModel(HARD_COPPER);
        ClientProxy.registerItemModel(ORE_TIN);
        ClientProxy.registerBlockModel(HARD_TIN);
    }
}

